/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeDomainChangeProgress</code> request. Contains progress information for the requested
 * domain change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDomainChangeProgressResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DescribeDomainChangeProgressResponse.Builder, DescribeDomainChangeProgressResponse> {
    private static final SdkField<ChangeProgressStatusDetails> CHANGE_PROGRESS_STATUS_FIELD = SdkField
            .<ChangeProgressStatusDetails> builder(MarshallingType.SDK_POJO).memberName("ChangeProgressStatus")
            .getter(getter(DescribeDomainChangeProgressResponse::changeProgressStatus))
            .setter(setter(Builder::changeProgressStatus)).constructor(ChangeProgressStatusDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_PROGRESS_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ChangeProgressStatusDetails changeProgressStatus;

    private DescribeDomainChangeProgressResponse(BuilderImpl builder) {
        super(builder);
        this.changeProgressStatus = builder.changeProgressStatus;
    }

    /**
     * <p>
     * Container for information about the stages of a configuration change happening on a domain.
     * </p>
     * 
     * @return Container for information about the stages of a configuration change happening on a domain.
     */
    public final ChangeProgressStatusDetails changeProgressStatus() {
        return changeProgressStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(changeProgressStatus());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainChangeProgressResponse)) {
            return false;
        }
        DescribeDomainChangeProgressResponse other = (DescribeDomainChangeProgressResponse) obj;
        return Objects.equals(changeProgressStatus(), other.changeProgressStatus());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDomainChangeProgressResponse").add("ChangeProgressStatus", changeProgressStatus())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeProgressStatus":
            return Optional.ofNullable(clazz.cast(changeProgressStatus()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChangeProgressStatus", CHANGE_PROGRESS_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainChangeProgressResponse, T> g) {
        return obj -> g.apply((DescribeDomainChangeProgressResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDomainChangeProgressResponse> {
        /**
         * <p>
         * Container for information about the stages of a configuration change happening on a domain.
         * </p>
         * 
         * @param changeProgressStatus
         *        Container for information about the stages of a configuration change happening on a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressStatus(ChangeProgressStatusDetails changeProgressStatus);

        /**
         * <p>
         * Container for information about the stages of a configuration change happening on a domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link ChangeProgressStatusDetails.Builder}
         * avoiding the need to create one manually via {@link ChangeProgressStatusDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ChangeProgressStatusDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #changeProgressStatus(ChangeProgressStatusDetails)}.
         * 
         * @param changeProgressStatus
         *        a consumer that will call methods on {@link ChangeProgressStatusDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeProgressStatus(ChangeProgressStatusDetails)
         */
        default Builder changeProgressStatus(Consumer<ChangeProgressStatusDetails.Builder> changeProgressStatus) {
            return changeProgressStatus(ChangeProgressStatusDetails.builder().applyMutation(changeProgressStatus).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private ChangeProgressStatusDetails changeProgressStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainChangeProgressResponse model) {
            super(model);
            changeProgressStatus(model.changeProgressStatus);
        }

        public final ChangeProgressStatusDetails.Builder getChangeProgressStatus() {
            return changeProgressStatus != null ? changeProgressStatus.toBuilder() : null;
        }

        public final void setChangeProgressStatus(ChangeProgressStatusDetails.BuilderImpl changeProgressStatus) {
            this.changeProgressStatus = changeProgressStatus != null ? changeProgressStatus.build() : null;
        }

        @Override
        public final Builder changeProgressStatus(ChangeProgressStatusDetails changeProgressStatus) {
            this.changeProgressStatus = changeProgressStatus;
            return this;
        }

        @Override
        public DescribeDomainChangeProgressResponse build() {
            return new DescribeDomainChangeProgressResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
