/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeVpcEndpointsResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DescribeVpcEndpointsResponse.Builder, DescribeVpcEndpointsResponse> {
    private static final SdkField<List<VpcEndpoint>> VPC_ENDPOINTS_FIELD = SdkField
            .<List<VpcEndpoint>> builder(MarshallingType.LIST)
            .memberName("VpcEndpoints")
            .getter(getter(DescribeVpcEndpointsResponse::vpcEndpoints))
            .setter(setter(Builder::vpcEndpoints))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoints").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcEndpoint> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpoint::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VpcEndpointError>> VPC_ENDPOINT_ERRORS_FIELD = SdkField
            .<List<VpcEndpointError>> builder(MarshallingType.LIST)
            .memberName("VpcEndpointErrors")
            .getter(getter(DescribeVpcEndpointsResponse::vpcEndpointErrors))
            .setter(setter(Builder::vpcEndpointErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcEndpointError> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpointError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINTS_FIELD,
            VPC_ENDPOINT_ERRORS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VpcEndpoint> vpcEndpoints;

    private final List<VpcEndpointError> vpcEndpointErrors;

    private DescribeVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoints = builder.vpcEndpoints;
        this.vpcEndpointErrors = builder.vpcEndpointErrors;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpoints property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcEndpoints() {
        return vpcEndpoints != null && !(vpcEndpoints instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about each requested VPC endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpoints} method.
     * </p>
     * 
     * @return Information about each requested VPC endpoint.
     */
    public final List<VpcEndpoint> vpcEndpoints() {
        return vpcEndpoints;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpointErrors property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcEndpointErrors() {
        return vpcEndpointErrors != null && !(vpcEndpointErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Any errors associated with the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpointErrors} method.
     * </p>
     * 
     * @return Any errors associated with the request.
     */
    public final List<VpcEndpointError> vpcEndpointErrors() {
        return vpcEndpointErrors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpoints() ? vpcEndpoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpointErrors() ? vpcEndpointErrors() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVpcEndpointsResponse)) {
            return false;
        }
        DescribeVpcEndpointsResponse other = (DescribeVpcEndpointsResponse) obj;
        return hasVpcEndpoints() == other.hasVpcEndpoints() && Objects.equals(vpcEndpoints(), other.vpcEndpoints())
                && hasVpcEndpointErrors() == other.hasVpcEndpointErrors()
                && Objects.equals(vpcEndpointErrors(), other.vpcEndpointErrors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeVpcEndpointsResponse").add("VpcEndpoints", hasVpcEndpoints() ? vpcEndpoints() : null)
                .add("VpcEndpointErrors", hasVpcEndpointErrors() ? vpcEndpointErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpoints":
            return Optional.ofNullable(clazz.cast(vpcEndpoints()));
        case "VpcEndpointErrors":
            return Optional.ofNullable(clazz.cast(vpcEndpointErrors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpoints", VPC_ENDPOINTS_FIELD);
        map.put("VpcEndpointErrors", VPC_ENDPOINT_ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVpcEndpointsResponse, T> g) {
        return obj -> g.apply((DescribeVpcEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeVpcEndpointsResponse> {
        /**
         * <p>
         * Information about each requested VPC endpoint.
         * </p>
         * 
         * @param vpcEndpoints
         *        Information about each requested VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints);

        /**
         * <p>
         * Information about each requested VPC endpoint.
         * </p>
         * 
         * @param vpcEndpoints
         *        Information about each requested VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoints(VpcEndpoint... vpcEndpoints);

        /**
         * <p>
         * Information about each requested VPC endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.VpcEndpoint.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.VpcEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.VpcEndpoint.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcEndpoints(List<VpcEndpoint>)}.
         * 
         * @param vpcEndpoints
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.VpcEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpoints(java.util.Collection<VpcEndpoint>)
         */
        Builder vpcEndpoints(Consumer<VpcEndpoint.Builder>... vpcEndpoints);

        /**
         * <p>
         * Any errors associated with the request.
         * </p>
         * 
         * @param vpcEndpointErrors
         *        Any errors associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointErrors(Collection<VpcEndpointError> vpcEndpointErrors);

        /**
         * <p>
         * Any errors associated with the request.
         * </p>
         * 
         * @param vpcEndpointErrors
         *        Any errors associated with the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointErrors(VpcEndpointError... vpcEndpointErrors);

        /**
         * <p>
         * Any errors associated with the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.VpcEndpointError.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opensearch.model.VpcEndpointError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.VpcEndpointError.Builder#build()} is called
         * immediately and its result is passed to {@link #vpcEndpointErrors(List<VpcEndpointError>)}.
         * 
         * @param vpcEndpointErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.VpcEndpointError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointErrors(java.util.Collection<VpcEndpointError>)
         */
        Builder vpcEndpointErrors(Consumer<VpcEndpointError.Builder>... vpcEndpointErrors);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private List<VpcEndpoint> vpcEndpoints = DefaultSdkAutoConstructList.getInstance();

        private List<VpcEndpointError> vpcEndpointErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVpcEndpointsResponse model) {
            super(model);
            vpcEndpoints(model.vpcEndpoints);
            vpcEndpointErrors(model.vpcEndpointErrors);
        }

        public final List<VpcEndpoint.Builder> getVpcEndpoints() {
            List<VpcEndpoint.Builder> result = VpcEndpointsCopier.copyToBuilder(this.vpcEndpoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpoints(Collection<VpcEndpoint.BuilderImpl> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointsCopier.copyFromBuilder(vpcEndpoints);
        }

        @Override
        public final Builder vpcEndpoints(Collection<VpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = VpcEndpointsCopier.copy(vpcEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(VpcEndpoint... vpcEndpoints) {
            vpcEndpoints(Arrays.asList(vpcEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpoints(Consumer<VpcEndpoint.Builder>... vpcEndpoints) {
            vpcEndpoints(Stream.of(vpcEndpoints).map(c -> VpcEndpoint.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<VpcEndpointError.Builder> getVpcEndpointErrors() {
            List<VpcEndpointError.Builder> result = VpcEndpointErrorListCopier.copyToBuilder(this.vpcEndpointErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointErrors(Collection<VpcEndpointError.BuilderImpl> vpcEndpointErrors) {
            this.vpcEndpointErrors = VpcEndpointErrorListCopier.copyFromBuilder(vpcEndpointErrors);
        }

        @Override
        public final Builder vpcEndpointErrors(Collection<VpcEndpointError> vpcEndpointErrors) {
            this.vpcEndpointErrors = VpcEndpointErrorListCopier.copy(vpcEndpointErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrors(VpcEndpointError... vpcEndpointErrors) {
            vpcEndpointErrors(Arrays.asList(vpcEndpointErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrors(Consumer<VpcEndpointError.Builder>... vpcEndpointErrors) {
            vpcEndpointErrors(Stream.of(vpcEndpointErrors).map(c -> VpcEndpointError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeVpcEndpointsResponse build() {
            return new DescribeVpcEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
