/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of data source that is used for direct queries. This is a supported Amazon Web Services service, such as
 * CloudWatch Logs or Security Lake.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectQueryDataSourceType implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectQueryDataSourceType.Builder, DirectQueryDataSourceType> {
    private static final SdkField<CloudWatchDirectQueryDataSource> CLOUD_WATCH_LOG_FIELD = SdkField
            .<CloudWatchDirectQueryDataSource> builder(MarshallingType.SDK_POJO).memberName("CloudWatchLog")
            .getter(getter(DirectQueryDataSourceType::cloudWatchLog)).setter(setter(Builder::cloudWatchLog))
            .constructor(CloudWatchDirectQueryDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchLog").build()).build();

    private static final SdkField<SecurityLakeDirectQueryDataSource> SECURITY_LAKE_FIELD = SdkField
            .<SecurityLakeDirectQueryDataSource> builder(MarshallingType.SDK_POJO).memberName("SecurityLake")
            .getter(getter(DirectQueryDataSourceType::securityLake)).setter(setter(Builder::securityLake))
            .constructor(SecurityLakeDirectQueryDataSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityLake").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_FIELD,
            SECURITY_LAKE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CloudWatchDirectQueryDataSource cloudWatchLog;

    private final SecurityLakeDirectQueryDataSource securityLake;

    private final Type type;

    private DirectQueryDataSourceType(BuilderImpl builder) {
        this.cloudWatchLog = builder.cloudWatchLog;
        this.securityLake = builder.securityLake;
        this.type = builder.type;
    }

    /**
     * <p>
     * Specifies CloudWatch Logs as a type of data source for direct queries.
     * </p>
     * 
     * @return Specifies CloudWatch Logs as a type of data source for direct queries.
     */
    public final CloudWatchDirectQueryDataSource cloudWatchLog() {
        return cloudWatchLog;
    }

    /**
     * <p>
     * Specifies Security Lake as a type of data source for direct queries.
     * </p>
     * 
     * @return Specifies Security Lake as a type of data source for direct queries.
     */
    public final SecurityLakeDirectQueryDataSource securityLake() {
        return securityLake;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(cloudWatchLog());
        hashCode = 31 * hashCode + Objects.hashCode(securityLake());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectQueryDataSourceType)) {
            return false;
        }
        DirectQueryDataSourceType other = (DirectQueryDataSourceType) obj;
        return Objects.equals(cloudWatchLog(), other.cloudWatchLog()) && Objects.equals(securityLake(), other.securityLake());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectQueryDataSourceType").add("CloudWatchLog", cloudWatchLog())
                .add("SecurityLake", securityLake()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CloudWatchLog":
            return Optional.ofNullable(clazz.cast(cloudWatchLog()));
        case "SecurityLake":
            return Optional.ofNullable(clazz.cast(securityLake()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #cloudWatchLog()} initialized to the given value.
     *
     * <p>
     * Specifies CloudWatch Logs as a type of data source for direct queries.
     * </p>
     * 
     * @param cloudWatchLog
     *        Specifies CloudWatch Logs as a type of data source for direct queries.
     */
    public static DirectQueryDataSourceType fromCloudWatchLog(CloudWatchDirectQueryDataSource cloudWatchLog) {
        return builder().cloudWatchLog(cloudWatchLog).build();
    }

    /**
     * Create an instance of this class with {@link #cloudWatchLog()} initialized to the given value.
     *
     * <p>
     * Specifies CloudWatch Logs as a type of data source for direct queries.
     * </p>
     * 
     * @param cloudWatchLog
     *        Specifies CloudWatch Logs as a type of data source for direct queries.
     */
    public static DirectQueryDataSourceType fromCloudWatchLog(Consumer<CloudWatchDirectQueryDataSource.Builder> cloudWatchLog) {
        CloudWatchDirectQueryDataSource.Builder builder = CloudWatchDirectQueryDataSource.builder();
        cloudWatchLog.accept(builder);
        return fromCloudWatchLog(builder.build());
    }

    /**
     * Create an instance of this class with {@link #securityLake()} initialized to the given value.
     *
     * <p>
     * Specifies Security Lake as a type of data source for direct queries.
     * </p>
     * 
     * @param securityLake
     *        Specifies Security Lake as a type of data source for direct queries.
     */
    public static DirectQueryDataSourceType fromSecurityLake(SecurityLakeDirectQueryDataSource securityLake) {
        return builder().securityLake(securityLake).build();
    }

    /**
     * Create an instance of this class with {@link #securityLake()} initialized to the given value.
     *
     * <p>
     * Specifies Security Lake as a type of data source for direct queries.
     * </p>
     * 
     * @param securityLake
     *        Specifies Security Lake as a type of data source for direct queries.
     */
    public static DirectQueryDataSourceType fromSecurityLake(Consumer<SecurityLakeDirectQueryDataSource.Builder> securityLake) {
        SecurityLakeDirectQueryDataSource.Builder builder = SecurityLakeDirectQueryDataSource.builder();
        securityLake.accept(builder);
        return fromSecurityLake(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CloudWatchLog", CLOUD_WATCH_LOG_FIELD);
        map.put("SecurityLake", SECURITY_LAKE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectQueryDataSourceType, T> g) {
        return obj -> g.apply((DirectQueryDataSourceType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectQueryDataSourceType> {
        /**
         * <p>
         * Specifies CloudWatch Logs as a type of data source for direct queries.
         * </p>
         * 
         * @param cloudWatchLog
         *        Specifies CloudWatch Logs as a type of data source for direct queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cloudWatchLog(CloudWatchDirectQueryDataSource cloudWatchLog);

        /**
         * <p>
         * Specifies CloudWatch Logs as a type of data source for direct queries.
         * </p>
         * This is a convenience method that creates an instance of the {@link CloudWatchDirectQueryDataSource.Builder}
         * avoiding the need to create one manually via {@link CloudWatchDirectQueryDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CloudWatchDirectQueryDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #cloudWatchLog(CloudWatchDirectQueryDataSource)}.
         * 
         * @param cloudWatchLog
         *        a consumer that will call methods on {@link CloudWatchDirectQueryDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cloudWatchLog(CloudWatchDirectQueryDataSource)
         */
        default Builder cloudWatchLog(Consumer<CloudWatchDirectQueryDataSource.Builder> cloudWatchLog) {
            return cloudWatchLog(CloudWatchDirectQueryDataSource.builder().applyMutation(cloudWatchLog).build());
        }

        /**
         * <p>
         * Specifies Security Lake as a type of data source for direct queries.
         * </p>
         * 
         * @param securityLake
         *        Specifies Security Lake as a type of data source for direct queries.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityLake(SecurityLakeDirectQueryDataSource securityLake);

        /**
         * <p>
         * Specifies Security Lake as a type of data source for direct queries.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link SecurityLakeDirectQueryDataSource.Builder} avoiding the need to create one manually via
         * {@link SecurityLakeDirectQueryDataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityLakeDirectQueryDataSource.Builder#build()} is called
         * immediately and its result is passed to {@link #securityLake(SecurityLakeDirectQueryDataSource)}.
         * 
         * @param securityLake
         *        a consumer that will call methods on {@link SecurityLakeDirectQueryDataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityLake(SecurityLakeDirectQueryDataSource)
         */
        default Builder securityLake(Consumer<SecurityLakeDirectQueryDataSource.Builder> securityLake) {
            return securityLake(SecurityLakeDirectQueryDataSource.builder().applyMutation(securityLake).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CloudWatchDirectQueryDataSource cloudWatchLog;

        private SecurityLakeDirectQueryDataSource securityLake;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DirectQueryDataSourceType model) {
            cloudWatchLog(model.cloudWatchLog);
            securityLake(model.securityLake);
        }

        public final CloudWatchDirectQueryDataSource.Builder getCloudWatchLog() {
            return cloudWatchLog != null ? cloudWatchLog.toBuilder() : null;
        }

        public final void setCloudWatchLog(CloudWatchDirectQueryDataSource.BuilderImpl cloudWatchLog) {
            Object oldValue = this.cloudWatchLog;
            this.cloudWatchLog = cloudWatchLog != null ? cloudWatchLog.build() : null;
            handleUnionValueChange(Type.CLOUD_WATCH_LOG, oldValue, this.cloudWatchLog);
        }

        @Override
        public final Builder cloudWatchLog(CloudWatchDirectQueryDataSource cloudWatchLog) {
            Object oldValue = this.cloudWatchLog;
            this.cloudWatchLog = cloudWatchLog;
            handleUnionValueChange(Type.CLOUD_WATCH_LOG, oldValue, this.cloudWatchLog);
            return this;
        }

        public final SecurityLakeDirectQueryDataSource.Builder getSecurityLake() {
            return securityLake != null ? securityLake.toBuilder() : null;
        }

        public final void setSecurityLake(SecurityLakeDirectQueryDataSource.BuilderImpl securityLake) {
            Object oldValue = this.securityLake;
            this.securityLake = securityLake != null ? securityLake.build() : null;
            handleUnionValueChange(Type.SECURITY_LAKE, oldValue, this.securityLake);
        }

        @Override
        public final Builder securityLake(SecurityLakeDirectQueryDataSource securityLake) {
            Object oldValue = this.securityLake;
            this.securityLake = securityLake;
            handleUnionValueChange(Type.SECURITY_LAKE, oldValue, this.securityLake);
            return this;
        }

        @Override
        public DirectQueryDataSourceType build() {
            return new DirectQueryDataSourceType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see DirectQueryDataSourceType#type()
     */
    public enum Type {
        CLOUD_WATCH_LOG,

        SECURITY_LAKE,

        UNKNOWN_TO_SDK_VERSION
    }
}
