/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for information about nodes on the domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainNodesStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainNodesStatus.Builder, DomainNodesStatus> {
    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(DomainNodesStatus::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeType").getter(getter(DomainNodesStatus::nodeTypeAsString)).setter(setter(Builder::nodeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(DomainNodesStatus::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(DomainNodesStatus::instanceTypeAsString))
            .setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> NODE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NodeStatus").getter(getter(DomainNodesStatus::nodeStatusAsString)).setter(setter(Builder::nodeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeStatus").build()).build();

    private static final SdkField<String> STORAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageType").getter(getter(DomainNodesStatus::storageType)).setter(setter(Builder::storageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageType").build()).build();

    private static final SdkField<String> STORAGE_VOLUME_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageVolumeType").getter(getter(DomainNodesStatus::storageVolumeTypeAsString))
            .setter(setter(Builder::storageVolumeType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageVolumeType").build()).build();

    private static final SdkField<String> STORAGE_SIZE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StorageSize").getter(getter(DomainNodesStatus::storageSize)).setter(setter(Builder::storageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NODE_ID_FIELD,
            NODE_TYPE_FIELD, AVAILABILITY_ZONE_FIELD, INSTANCE_TYPE_FIELD, NODE_STATUS_FIELD, STORAGE_TYPE_FIELD,
            STORAGE_VOLUME_TYPE_FIELD, STORAGE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String nodeId;

    private final String nodeType;

    private final String availabilityZone;

    private final String instanceType;

    private final String nodeStatus;

    private final String storageType;

    private final String storageVolumeType;

    private final String storageSize;

    private DomainNodesStatus(BuilderImpl builder) {
        this.nodeId = builder.nodeId;
        this.nodeType = builder.nodeType;
        this.availabilityZone = builder.availabilityZone;
        this.instanceType = builder.instanceType;
        this.nodeStatus = builder.nodeStatus;
        this.storageType = builder.storageType;
        this.storageVolumeType = builder.storageVolumeType;
        this.storageSize = builder.storageSize;
    }

    /**
     * <p>
     * The ID of the node.
     * </p>
     * 
     * @return The ID of the node.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * Indicates whether the nodes is a data, master, or UltraWarm node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the nodes is a data, master, or UltraWarm node.
     * @see NodeType
     */
    public final NodeType nodeType() {
        return NodeType.fromValue(nodeType);
    }

    /**
     * <p>
     * Indicates whether the nodes is a data, master, or UltraWarm node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeType} will
     * return {@link NodeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeTypeAsString}.
     * </p>
     * 
     * @return Indicates whether the nodes is a data, master, or UltraWarm node.
     * @see NodeType
     */
    public final String nodeTypeAsString() {
        return nodeType;
    }

    /**
     * <p>
     * The Availability Zone of the node.
     * </p>
     * 
     * @return The Availability Zone of the node.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * The instance type information of the node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link OpenSearchPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type information of the node.
     * @see OpenSearchPartitionInstanceType
     */
    public final OpenSearchPartitionInstanceType instanceType() {
        return OpenSearchPartitionInstanceType.fromValue(instanceType);
    }

    /**
     * <p>
     * The instance type information of the node.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #instanceType} will
     * return {@link OpenSearchPartitionInstanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #instanceTypeAsString}.
     * </p>
     * 
     * @return The instance type information of the node.
     * @see OpenSearchPartitionInstanceType
     */
    public final String instanceTypeAsString() {
        return instanceType;
    }

    /**
     * <p>
     * Indicates if the node is active or in standby.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeStatus} will
     * return {@link NodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeStatusAsString}.
     * </p>
     * 
     * @return Indicates if the node is active or in standby.
     * @see NodeStatus
     */
    public final NodeStatus nodeStatus() {
        return NodeStatus.fromValue(nodeStatus);
    }

    /**
     * <p>
     * Indicates if the node is active or in standby.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #nodeStatus} will
     * return {@link NodeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nodeStatusAsString}.
     * </p>
     * 
     * @return Indicates if the node is active or in standby.
     * @see NodeStatus
     */
    public final String nodeStatusAsString() {
        return nodeStatus;
    }

    /**
     * <p>
     * Indicates if the node has EBS or instance storage.
     * </p>
     * 
     * @return Indicates if the node has EBS or instance storage.
     */
    public final String storageType() {
        return storageType;
    }

    /**
     * <p>
     * If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data nodes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageVolumeType}
     * will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageVolumeTypeAsString}.
     * </p>
     * 
     * @return If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data nodes.
     * @see VolumeType
     */
    public final VolumeType storageVolumeType() {
        return VolumeType.fromValue(storageVolumeType);
    }

    /**
     * <p>
     * If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data nodes.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #storageVolumeType}
     * will return {@link VolumeType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #storageVolumeTypeAsString}.
     * </p>
     * 
     * @return If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data nodes.
     * @see VolumeType
     */
    public final String storageVolumeTypeAsString() {
        return storageVolumeType;
    }

    /**
     * <p>
     * The storage size of the node, in GiB.
     * </p>
     * 
     * @return The storage size of the node, in GiB.
     */
    public final String storageSize() {
        return storageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(instanceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageType());
        hashCode = 31 * hashCode + Objects.hashCode(storageVolumeTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(storageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainNodesStatus)) {
            return false;
        }
        DomainNodesStatus other = (DomainNodesStatus) obj;
        return Objects.equals(nodeId(), other.nodeId()) && Objects.equals(nodeTypeAsString(), other.nodeTypeAsString())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(instanceTypeAsString(), other.instanceTypeAsString())
                && Objects.equals(nodeStatusAsString(), other.nodeStatusAsString())
                && Objects.equals(storageType(), other.storageType())
                && Objects.equals(storageVolumeTypeAsString(), other.storageVolumeTypeAsString())
                && Objects.equals(storageSize(), other.storageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainNodesStatus").add("NodeId", nodeId()).add("NodeType", nodeTypeAsString())
                .add("AvailabilityZone", availabilityZone()).add("InstanceType", instanceTypeAsString())
                .add("NodeStatus", nodeStatusAsString()).add("StorageType", storageType())
                .add("StorageVolumeType", storageVolumeTypeAsString()).add("StorageSize", storageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "NodeType":
            return Optional.ofNullable(clazz.cast(nodeTypeAsString()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceTypeAsString()));
        case "NodeStatus":
            return Optional.ofNullable(clazz.cast(nodeStatusAsString()));
        case "StorageType":
            return Optional.ofNullable(clazz.cast(storageType()));
        case "StorageVolumeType":
            return Optional.ofNullable(clazz.cast(storageVolumeTypeAsString()));
        case "StorageSize":
            return Optional.ofNullable(clazz.cast(storageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("NodeId", NODE_ID_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("AvailabilityZone", AVAILABILITY_ZONE_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("NodeStatus", NODE_STATUS_FIELD);
        map.put("StorageType", STORAGE_TYPE_FIELD);
        map.put("StorageVolumeType", STORAGE_VOLUME_TYPE_FIELD);
        map.put("StorageSize", STORAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainNodesStatus, T> g) {
        return obj -> g.apply((DomainNodesStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainNodesStatus> {
        /**
         * <p>
         * The ID of the node.
         * </p>
         * 
         * @param nodeId
         *        The ID of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * Indicates whether the nodes is a data, master, or UltraWarm node.
         * </p>
         * 
         * @param nodeType
         *        Indicates whether the nodes is a data, master, or UltraWarm node.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(String nodeType);

        /**
         * <p>
         * Indicates whether the nodes is a data, master, or UltraWarm node.
         * </p>
         * 
         * @param nodeType
         *        Indicates whether the nodes is a data, master, or UltraWarm node.
         * @see NodeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeType
         */
        Builder nodeType(NodeType nodeType);

        /**
         * <p>
         * The Availability Zone of the node.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * The instance type information of the node.
         * </p>
         * 
         * @param instanceType
         *        The instance type information of the node.
         * @see OpenSearchPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenSearchPartitionInstanceType
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The instance type information of the node.
         * </p>
         * 
         * @param instanceType
         *        The instance type information of the node.
         * @see OpenSearchPartitionInstanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OpenSearchPartitionInstanceType
         */
        Builder instanceType(OpenSearchPartitionInstanceType instanceType);

        /**
         * <p>
         * Indicates if the node is active or in standby.
         * </p>
         * 
         * @param nodeStatus
         *        Indicates if the node is active or in standby.
         * @see NodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeStatus
         */
        Builder nodeStatus(String nodeStatus);

        /**
         * <p>
         * Indicates if the node is active or in standby.
         * </p>
         * 
         * @param nodeStatus
         *        Indicates if the node is active or in standby.
         * @see NodeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NodeStatus
         */
        Builder nodeStatus(NodeStatus nodeStatus);

        /**
         * <p>
         * Indicates if the node has EBS or instance storage.
         * </p>
         * 
         * @param storageType
         *        Indicates if the node has EBS or instance storage.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageType(String storageType);

        /**
         * <p>
         * If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data nodes.
         * </p>
         * 
         * @param storageVolumeType
         *        If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data
         *        nodes.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder storageVolumeType(String storageVolumeType);

        /**
         * <p>
         * If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data nodes.
         * </p>
         * 
         * @param storageVolumeType
         *        If the nodes has EBS storage, indicates if the volume type is gp2 or gp3. Only applicable for data
         *        nodes.
         * @see VolumeType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VolumeType
         */
        Builder storageVolumeType(VolumeType storageVolumeType);

        /**
         * <p>
         * The storage size of the node, in GiB.
         * </p>
         * 
         * @param storageSize
         *        The storage size of the node, in GiB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageSize(String storageSize);
    }

    static final class BuilderImpl implements Builder {
        private String nodeId;

        private String nodeType;

        private String availabilityZone;

        private String instanceType;

        private String nodeStatus;

        private String storageType;

        private String storageVolumeType;

        private String storageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainNodesStatus model) {
            nodeId(model.nodeId);
            nodeType(model.nodeType);
            availabilityZone(model.availabilityZone);
            instanceType(model.instanceType);
            nodeStatus(model.nodeStatus);
            storageType(model.storageType);
            storageVolumeType(model.storageVolumeType);
            storageSize(model.storageSize);
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final String getNodeType() {
            return nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        @Override
        public final Builder nodeType(NodeType nodeType) {
            this.nodeType(nodeType == null ? null : nodeType.toString());
            return this;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        @Override
        public final Builder instanceType(OpenSearchPartitionInstanceType instanceType) {
            this.instanceType(instanceType == null ? null : instanceType.toString());
            return this;
        }

        public final String getNodeStatus() {
            return nodeStatus;
        }

        public final void setNodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
        }

        @Override
        public final Builder nodeStatus(String nodeStatus) {
            this.nodeStatus = nodeStatus;
            return this;
        }

        @Override
        public final Builder nodeStatus(NodeStatus nodeStatus) {
            this.nodeStatus(nodeStatus == null ? null : nodeStatus.toString());
            return this;
        }

        public final String getStorageType() {
            return storageType;
        }

        public final void setStorageType(String storageType) {
            this.storageType = storageType;
        }

        @Override
        public final Builder storageType(String storageType) {
            this.storageType = storageType;
            return this;
        }

        public final String getStorageVolumeType() {
            return storageVolumeType;
        }

        public final void setStorageVolumeType(String storageVolumeType) {
            this.storageVolumeType = storageVolumeType;
        }

        @Override
        public final Builder storageVolumeType(String storageVolumeType) {
            this.storageVolumeType = storageVolumeType;
            return this;
        }

        @Override
        public final Builder storageVolumeType(VolumeType storageVolumeType) {
            this.storageVolumeType(storageVolumeType == null ? null : storageVolumeType.toString());
            return this;
        }

        public final String getStorageSize() {
            return storageSize;
        }

        public final void setStorageSize(String storageSize) {
            this.storageSize = storageSize;
        }

        @Override
        public final Builder storageSize(String storageSize) {
            this.storageSize = storageSize;
            return this;
        }

        @Override
        public DomainNodesStatus build() {
            return new DomainNodesStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
