/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the response returned by the <code>GetCompatibleVersions</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCompatibleVersionsResponse extends OpenSearchResponse implements
        ToCopyableBuilder<GetCompatibleVersionsResponse.Builder, GetCompatibleVersionsResponse> {
    private static final SdkField<List<CompatibleVersionsMap>> COMPATIBLE_VERSIONS_FIELD = SdkField
            .<List<CompatibleVersionsMap>> builder(MarshallingType.LIST)
            .memberName("CompatibleVersions")
            .getter(getter(GetCompatibleVersionsResponse::compatibleVersions))
            .setter(setter(Builder::compatibleVersions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompatibleVersions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CompatibleVersionsMap> builder(MarshallingType.SDK_POJO)
                                            .constructor(CompatibleVersionsMap::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COMPATIBLE_VERSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CompatibleVersionsMap> compatibleVersions;

    private GetCompatibleVersionsResponse(BuilderImpl builder) {
        super(builder);
        this.compatibleVersions = builder.compatibleVersions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompatibleVersions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompatibleVersions() {
        return compatibleVersions != null && !(compatibleVersions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompatibleVersions} method.
     * </p>
     * 
     * @return A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
     */
    public final List<CompatibleVersionsMap> compatibleVersions() {
        return compatibleVersions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCompatibleVersions() ? compatibleVersions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCompatibleVersionsResponse)) {
            return false;
        }
        GetCompatibleVersionsResponse other = (GetCompatibleVersionsResponse) obj;
        return hasCompatibleVersions() == other.hasCompatibleVersions()
                && Objects.equals(compatibleVersions(), other.compatibleVersions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCompatibleVersionsResponse")
                .add("CompatibleVersions", hasCompatibleVersions() ? compatibleVersions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CompatibleVersions":
            return Optional.ofNullable(clazz.cast(compatibleVersions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CompatibleVersions", COMPATIBLE_VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCompatibleVersionsResponse, T> g) {
        return obj -> g.apply((GetCompatibleVersionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCompatibleVersionsResponse> {
        /**
         * <p>
         * A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
         * </p>
         * 
         * @param compatibleVersions
         *        A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleVersions(Collection<CompatibleVersionsMap> compatibleVersions);

        /**
         * <p>
         * A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
         * </p>
         * 
         * @param compatibleVersions
         *        A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder compatibleVersions(CompatibleVersionsMap... compatibleVersions);

        /**
         * <p>
         * A map of OpenSearch or Elasticsearch versions and the versions you can upgrade them to.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap.Builder#build()} is called
         * immediately and its result is passed to {@link #compatibleVersions(List<CompatibleVersionsMap>)}.
         * 
         * @param compatibleVersions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.CompatibleVersionsMap.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #compatibleVersions(java.util.Collection<CompatibleVersionsMap>)
         */
        Builder compatibleVersions(Consumer<CompatibleVersionsMap.Builder>... compatibleVersions);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private List<CompatibleVersionsMap> compatibleVersions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCompatibleVersionsResponse model) {
            super(model);
            compatibleVersions(model.compatibleVersions);
        }

        public final List<CompatibleVersionsMap.Builder> getCompatibleVersions() {
            List<CompatibleVersionsMap.Builder> result = CompatibleVersionsListCopier.copyToBuilder(this.compatibleVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCompatibleVersions(Collection<CompatibleVersionsMap.BuilderImpl> compatibleVersions) {
            this.compatibleVersions = CompatibleVersionsListCopier.copyFromBuilder(compatibleVersions);
        }

        @Override
        public final Builder compatibleVersions(Collection<CompatibleVersionsMap> compatibleVersions) {
            this.compatibleVersions = CompatibleVersionsListCopier.copy(compatibleVersions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleVersions(CompatibleVersionsMap... compatibleVersions) {
            compatibleVersions(Arrays.asList(compatibleVersions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder compatibleVersions(Consumer<CompatibleVersionsMap.Builder>... compatibleVersions) {
            compatibleVersions(Stream.of(compatibleVersions).map(c -> CompatibleVersionsMap.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetCompatibleVersionsResponse build() {
            return new GetCompatibleVersionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
