/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about a scheduled configuration change for an OpenSearch Service domain. This actions can be a <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/service-software.html">service software
 * update</a> or a <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/auto-tune.html#auto-tune-types">blue/green
 * Auto-Tune enhancement</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScheduledAction implements SdkPojo, Serializable, ToCopyableBuilder<ScheduledAction.Builder, ScheduledAction> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(ScheduledAction::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(ScheduledAction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> SEVERITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Severity").getter(getter(ScheduledAction::severityAsString)).setter(setter(Builder::severity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Severity").build()).build();

    private static final SdkField<Long> SCHEDULED_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("ScheduledTime").getter(getter(ScheduledAction::scheduledTime)).setter(setter(Builder::scheduledTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledTime").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ScheduledAction::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> SCHEDULED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduledBy").getter(getter(ScheduledAction::scheduledByAsString)).setter(setter(Builder::scheduledBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduledBy").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ScheduledAction::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Boolean> MANDATORY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Mandatory").getter(getter(ScheduledAction::mandatory)).setter(setter(Builder::mandatory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Mandatory").build()).build();

    private static final SdkField<Boolean> CANCELLABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Cancellable").getter(getter(ScheduledAction::cancellable)).setter(setter(Builder::cancellable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Cancellable").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            SEVERITY_FIELD, SCHEDULED_TIME_FIELD, DESCRIPTION_FIELD, SCHEDULED_BY_FIELD, STATUS_FIELD, MANDATORY_FIELD,
            CANCELLABLE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String severity;

    private final Long scheduledTime;

    private final String description;

    private final String scheduledBy;

    private final String status;

    private final Boolean mandatory;

    private final Boolean cancellable;

    private ScheduledAction(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.severity = builder.severity;
        this.scheduledTime = builder.scheduledTime;
        this.description = builder.description;
        this.scheduledBy = builder.scheduledBy;
        this.status = builder.status;
        this.mandatory = builder.mandatory;
        this.cancellable = builder.cancellable;
    }

    /**
     * <p>
     * The unique identifier of the scheduled action.
     * </p>
     * 
     * @return The unique identifier of the scheduled action.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of action that will be taken on the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action that will be taken on the domain.
     * @see ActionType
     */
    public final ActionType type() {
        return ActionType.fromValue(type);
    }

    /**
     * <p>
     * The type of action that will be taken on the domain.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link ActionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of action that will be taken on the domain.
     * @see ActionType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The severity of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ActionSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the action.
     * @see ActionSeverity
     */
    public final ActionSeverity severity() {
        return ActionSeverity.fromValue(severity);
    }

    /**
     * <p>
     * The severity of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #severity} will
     * return {@link ActionSeverity#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #severityAsString}.
     * </p>
     * 
     * @return The severity of the action.
     * @see ActionSeverity
     */
    public final String severityAsString() {
        return severity;
    }

    /**
     * <p>
     * The time when the change is scheduled to happen.
     * </p>
     * 
     * @return The time when the change is scheduled to happen.
     */
    public final Long scheduledTime() {
        return scheduledTime;
    }

    /**
     * <p>
     * A description of the action to be taken.
     * </p>
     * 
     * @return A description of the action to be taken.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service automatically (
     * <code>SYSTEM</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduledBy} will
     * return {@link ScheduledBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduledByAsString}.
     * </p>
     * 
     * @return Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service automatically
     *         (<code>SYSTEM</code>).
     * @see ScheduledBy
     */
    public final ScheduledBy scheduledBy() {
        return ScheduledBy.fromValue(scheduledBy);
    }

    /**
     * <p>
     * Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service automatically (
     * <code>SYSTEM</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduledBy} will
     * return {@link ScheduledBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduledByAsString}.
     * </p>
     * 
     * @return Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service automatically
     *         (<code>SYSTEM</code>).
     * @see ScheduledBy
     */
    public final String scheduledByAsString() {
        return scheduledBy;
    }

    /**
     * <p>
     * The current status of the scheduled action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the scheduled action.
     * @see ActionStatus
     */
    public final ActionStatus status() {
        return ActionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the scheduled action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ActionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the scheduled action.
     * @see ActionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * Whether the action is required or optional.
     * </p>
     * 
     * @return Whether the action is required or optional.
     */
    public final Boolean mandatory() {
        return mandatory;
    }

    /**
     * <p>
     * Whether or not the scheduled action is cancellable.
     * </p>
     * 
     * @return Whether or not the scheduled action is cancellable.
     */
    public final Boolean cancellable() {
        return cancellable;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(severityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledTime());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(scheduledByAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(mandatory());
        hashCode = 31 * hashCode + Objects.hashCode(cancellable());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledAction)) {
            return false;
        }
        ScheduledAction other = (ScheduledAction) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(severityAsString(), other.severityAsString())
                && Objects.equals(scheduledTime(), other.scheduledTime()) && Objects.equals(description(), other.description())
                && Objects.equals(scheduledByAsString(), other.scheduledByAsString())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(mandatory(), other.mandatory())
                && Objects.equals(cancellable(), other.cancellable());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScheduledAction").add("Id", id()).add("Type", typeAsString())
                .add("Severity", severityAsString()).add("ScheduledTime", scheduledTime()).add("Description", description())
                .add("ScheduledBy", scheduledByAsString()).add("Status", statusAsString()).add("Mandatory", mandatory())
                .add("Cancellable", cancellable()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Severity":
            return Optional.ofNullable(clazz.cast(severityAsString()));
        case "ScheduledTime":
            return Optional.ofNullable(clazz.cast(scheduledTime()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ScheduledBy":
            return Optional.ofNullable(clazz.cast(scheduledByAsString()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "Mandatory":
            return Optional.ofNullable(clazz.cast(mandatory()));
        case "Cancellable":
            return Optional.ofNullable(clazz.cast(cancellable()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Id", ID_FIELD);
        map.put("Type", TYPE_FIELD);
        map.put("Severity", SEVERITY_FIELD);
        map.put("ScheduledTime", SCHEDULED_TIME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ScheduledBy", SCHEDULED_BY_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("Mandatory", MANDATORY_FIELD);
        map.put("Cancellable", CANCELLABLE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledAction, T> g) {
        return obj -> g.apply((ScheduledAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScheduledAction> {
        /**
         * <p>
         * The unique identifier of the scheduled action.
         * </p>
         * 
         * @param id
         *        The unique identifier of the scheduled action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of action that will be taken on the domain.
         * </p>
         * 
         * @param type
         *        The type of action that will be taken on the domain.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of action that will be taken on the domain.
         * </p>
         * 
         * @param type
         *        The type of action that will be taken on the domain.
         * @see ActionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionType
         */
        Builder type(ActionType type);

        /**
         * <p>
         * The severity of the action.
         * </p>
         * 
         * @param severity
         *        The severity of the action.
         * @see ActionSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionSeverity
         */
        Builder severity(String severity);

        /**
         * <p>
         * The severity of the action.
         * </p>
         * 
         * @param severity
         *        The severity of the action.
         * @see ActionSeverity
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionSeverity
         */
        Builder severity(ActionSeverity severity);

        /**
         * <p>
         * The time when the change is scheduled to happen.
         * </p>
         * 
         * @param scheduledTime
         *        The time when the change is scheduled to happen.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scheduledTime(Long scheduledTime);

        /**
         * <p>
         * A description of the action to be taken.
         * </p>
         * 
         * @param description
         *        A description of the action to be taken.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service automatically (
         * <code>SYSTEM</code>).
         * </p>
         * 
         * @param scheduledBy
         *        Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service
         *        automatically (<code>SYSTEM</code>).
         * @see ScheduledBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledBy
         */
        Builder scheduledBy(String scheduledBy);

        /**
         * <p>
         * Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service automatically (
         * <code>SYSTEM</code>).
         * </p>
         * 
         * @param scheduledBy
         *        Whether the action was scheduled manually (<code>CUSTOMER</code>, or by OpenSearch Service
         *        automatically (<code>SYSTEM</code>).
         * @see ScheduledBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduledBy
         */
        Builder scheduledBy(ScheduledBy scheduledBy);

        /**
         * <p>
         * The current status of the scheduled action.
         * </p>
         * 
         * @param status
         *        The current status of the scheduled action.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the scheduled action.
         * </p>
         * 
         * @param status
         *        The current status of the scheduled action.
         * @see ActionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ActionStatus
         */
        Builder status(ActionStatus status);

        /**
         * <p>
         * Whether the action is required or optional.
         * </p>
         * 
         * @param mandatory
         *        Whether the action is required or optional.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mandatory(Boolean mandatory);

        /**
         * <p>
         * Whether or not the scheduled action is cancellable.
         * </p>
         * 
         * @param cancellable
         *        Whether or not the scheduled action is cancellable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancellable(Boolean cancellable);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String severity;

        private Long scheduledTime;

        private String description;

        private String scheduledBy;

        private String status;

        private Boolean mandatory;

        private Boolean cancellable;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledAction model) {
            id(model.id);
            type(model.type);
            severity(model.severity);
            scheduledTime(model.scheduledTime);
            description(model.description);
            scheduledBy(model.scheduledBy);
            status(model.status);
            mandatory(model.mandatory);
            cancellable(model.cancellable);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getSeverity() {
            return severity;
        }

        public final void setSeverity(String severity) {
            this.severity = severity;
        }

        @Override
        public final Builder severity(String severity) {
            this.severity = severity;
            return this;
        }

        @Override
        public final Builder severity(ActionSeverity severity) {
            this.severity(severity == null ? null : severity.toString());
            return this;
        }

        public final Long getScheduledTime() {
            return scheduledTime;
        }

        public final void setScheduledTime(Long scheduledTime) {
            this.scheduledTime = scheduledTime;
        }

        @Override
        public final Builder scheduledTime(Long scheduledTime) {
            this.scheduledTime = scheduledTime;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getScheduledBy() {
            return scheduledBy;
        }

        public final void setScheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
        }

        @Override
        public final Builder scheduledBy(String scheduledBy) {
            this.scheduledBy = scheduledBy;
            return this;
        }

        @Override
        public final Builder scheduledBy(ScheduledBy scheduledBy) {
            this.scheduledBy(scheduledBy == null ? null : scheduledBy.toString());
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ActionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Boolean getMandatory() {
            return mandatory;
        }

        public final void setMandatory(Boolean mandatory) {
            this.mandatory = mandatory;
        }

        @Override
        public final Builder mandatory(Boolean mandatory) {
            this.mandatory = mandatory;
            return this;
        }

        public final Boolean getCancellable() {
            return cancellable;
        }

        public final void setCancellable(Boolean cancellable) {
            this.cancellable = cancellable;
        }

        @Override
        public final Builder cancellable(Boolean cancellable) {
            this.cancellable = cancellable;
            return this;
        }

        @Override
        public ScheduledAction build() {
            return new ScheduledAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
