/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code>StartDomainMaintenance</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartDomainMaintenanceRequest extends OpenSearchRequest implements
        ToCopyableBuilder<StartDomainMaintenanceRequest.Builder, StartDomainMaintenanceRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(StartDomainMaintenanceRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DomainName").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(StartDomainMaintenanceRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(StartDomainMaintenanceRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ACTION_FIELD, NODE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String action;

    private final String nodeId;

    private StartDomainMaintenanceRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.action = builder.action;
        this.nodeId = builder.nodeId;
    }

    /**
     * <p>
     * The name of the domain.
     * </p>
     * 
     * @return The name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link MaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The name of the action.
     * @see MaintenanceType
     */
    public final MaintenanceType action() {
        return MaintenanceType.fromValue(action);
    }

    /**
     * <p>
     * The name of the action.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link MaintenanceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The name of the action.
     * @see MaintenanceType
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The ID of the data node.
     * </p>
     * 
     * @return The ID of the data node.
     */
    public final String nodeId() {
        return nodeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartDomainMaintenanceRequest)) {
            return false;
        }
        StartDomainMaintenanceRequest other = (StartDomainMaintenanceRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(nodeId(), other.nodeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartDomainMaintenanceRequest").add("DomainName", domainName()).add("Action", actionAsString())
                .add("NodeId", nodeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("Action", ACTION_FIELD);
        map.put("NodeId", NODE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartDomainMaintenanceRequest, T> g) {
        return obj -> g.apply((StartDomainMaintenanceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartDomainMaintenanceRequest> {
        /**
         * <p>
         * The name of the domain.
         * </p>
         * 
         * @param domainName
         *        The name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param action
         *        The name of the action.
         * @see MaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceType
         */
        Builder action(String action);

        /**
         * <p>
         * The name of the action.
         * </p>
         * 
         * @param action
         *        The name of the action.
         * @see MaintenanceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MaintenanceType
         */
        Builder action(MaintenanceType action);

        /**
         * <p>
         * The ID of the data node.
         * </p>
         * 
         * @param nodeId
         *        The ID of the data node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String action;

        private String nodeId;

        private BuilderImpl() {
        }

        private BuilderImpl(StartDomainMaintenanceRequest model) {
            super(model);
            domainName(model.domainName);
            action(model.action);
            nodeId(model.nodeId);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(MaintenanceType action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getNodeId() {
            return nodeId;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartDomainMaintenanceRequest build() {
            return new StartDomainMaintenanceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
