/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the request parameters to the <code>StartServiceSoftwareUpdate</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartServiceSoftwareUpdateRequest extends OpenSearchRequest implements
        ToCopyableBuilder<StartServiceSoftwareUpdateRequest.Builder, StartServiceSoftwareUpdateRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(StartServiceSoftwareUpdateRequest::domainName))
            .setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> SCHEDULE_AT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScheduleAt").getter(getter(StartServiceSoftwareUpdateRequest::scheduleAtAsString))
            .setter(setter(Builder::scheduleAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScheduleAt").build()).build();

    private static final SdkField<Long> DESIRED_START_TIME_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DesiredStartTime").getter(getter(StartServiceSoftwareUpdateRequest::desiredStartTime))
            .setter(setter(Builder::desiredStartTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredStartTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SCHEDULE_AT_FIELD, DESIRED_START_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String domainName;

    private final String scheduleAt;

    private final Long desiredStartTime;

    private StartServiceSoftwareUpdateRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.scheduleAt = builder.scheduleAt;
        this.desiredStartTime = builder.desiredStartTime;
    }

    /**
     * <p>
     * The name of the domain that you want to update to the latest service software.
     * </p>
     * 
     * @return The name of the domain that you want to update to the latest service software.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * When to start the service software update.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this value,
     * you must also provide a value for <code>DesiredStartTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window. There's no
     * guarantee that the update will happen during the next immediate window. Depending on capacity, it might happen in
     * subsequent days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
     * <code>TIMESTAMP</code> if you do.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleAt} will
     * return {@link ScheduleAt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAtAsString}.
     * </p>
     * 
     * @return When to start the service software update.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
     *         value, you must also provide a value for <code>DesiredStartTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window.
     *         There's no guarantee that the update will happen during the next immediate window. Depending on capacity,
     *         it might happen in subsequent days.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
     *         <code>TIMESTAMP</code> if you do.
     * @see ScheduleAt
     */
    public final ScheduleAt scheduleAt() {
        return ScheduleAt.fromValue(scheduleAt);
    }

    /**
     * <p>
     * When to start the service software update.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity available.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this value,
     * you must also provide a value for <code>DesiredStartTime</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window. There's no
     * guarantee that the update will happen during the next immediate window. Depending on capacity, it might happen in
     * subsequent days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
     * <code>TIMESTAMP</code> if you do.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scheduleAt} will
     * return {@link ScheduleAt#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #scheduleAtAsString}.
     * </p>
     * 
     * @return When to start the service software update.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
     *         available.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
     *         value, you must also provide a value for <code>DesiredStartTime</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window.
     *         There's no guarantee that the update will happen during the next immediate window. Depending on capacity,
     *         it might happen in subsequent days.
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
     *         <code>TIMESTAMP</code> if you do.
     * @see ScheduleAt
     */
    public final String scheduleAtAsString() {
        return scheduleAt;
    }

    /**
     * <p>
     * The Epoch timestamp when you want the service software update to start. You only need to specify this parameter
     * if you set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
     * </p>
     * 
     * @return The Epoch timestamp when you want the service software update to start. You only need to specify this
     *         parameter if you set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
     */
    public final Long desiredStartTime() {
        return desiredStartTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(scheduleAtAsString());
        hashCode = 31 * hashCode + Objects.hashCode(desiredStartTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartServiceSoftwareUpdateRequest)) {
            return false;
        }
        StartServiceSoftwareUpdateRequest other = (StartServiceSoftwareUpdateRequest) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(scheduleAtAsString(), other.scheduleAtAsString())
                && Objects.equals(desiredStartTime(), other.desiredStartTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartServiceSoftwareUpdateRequest").add("DomainName", domainName())
                .add("ScheduleAt", scheduleAtAsString()).add("DesiredStartTime", desiredStartTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "ScheduleAt":
            return Optional.ofNullable(clazz.cast(scheduleAtAsString()));
        case "DesiredStartTime":
            return Optional.ofNullable(clazz.cast(desiredStartTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("ScheduleAt", SCHEDULE_AT_FIELD);
        map.put("DesiredStartTime", DESIRED_START_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartServiceSoftwareUpdateRequest, T> g) {
        return obj -> g.apply((StartServiceSoftwareUpdateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartServiceSoftwareUpdateRequest> {
        /**
         * <p>
         * The name of the domain that you want to update to the latest service software.
         * </p>
         * 
         * @param domainName
         *        The name of the domain that you want to update to the latest service software.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * When to start the service software update.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         * available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
         * value, you must also provide a value for <code>DesiredStartTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window. There's
         * no guarantee that the update will happen during the next immediate window. Depending on capacity, it might
         * happen in subsequent days.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
         * <code>TIMESTAMP</code> if you do.
         * </p>
         * 
         * @param scheduleAt
         *        When to start the service software update.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify
         *        this value, you must also provide a value for <code>DesiredStartTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window.
         *        There's no guarantee that the update will happen during the next immediate window. Depending on
         *        capacity, it might happen in subsequent days.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
         *        <code>TIMESTAMP</code> if you do.
         * @see ScheduleAt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleAt
         */
        Builder scheduleAt(String scheduleAt);

        /**
         * <p>
         * When to start the service software update.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         * available.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify this
         * value, you must also provide a value for <code>DesiredStartTime</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window. There's
         * no guarantee that the update will happen during the next immediate window. Depending on capacity, it might
         * happen in subsequent days.
         * </p>
         * </li>
         * </ul>
         * <p>
         * Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
         * <code>TIMESTAMP</code> if you do.
         * </p>
         * 
         * @param scheduleAt
         *        When to start the service software update.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NOW</code> - Immediately schedules the update to happen in the current hour if there's capacity
         *        available.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>TIMESTAMP</code> - Lets you specify a custom date and time to apply the update. If you specify
         *        this value, you must also provide a value for <code>DesiredStartTime</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>OFF_PEAK_WINDOW</code> - Marks the update to be picked up during an upcoming off-peak window.
         *        There's no guarantee that the update will happen during the next immediate window. Depending on
         *        capacity, it might happen in subsequent days.
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Default: <code>NOW</code> if you don't specify a value for <code>DesiredStartTime</code>, and
         *        <code>TIMESTAMP</code> if you do.
         * @see ScheduleAt
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScheduleAt
         */
        Builder scheduleAt(ScheduleAt scheduleAt);

        /**
         * <p>
         * The Epoch timestamp when you want the service software update to start. You only need to specify this
         * parameter if you set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
         * </p>
         * 
         * @param desiredStartTime
         *        The Epoch timestamp when you want the service software update to start. You only need to specify this
         *        parameter if you set <code>ScheduleAt</code> to <code>TIMESTAMP</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredStartTime(Long desiredStartTime);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private String scheduleAt;

        private Long desiredStartTime;

        private BuilderImpl() {
        }

        private BuilderImpl(StartServiceSoftwareUpdateRequest model) {
            super(model);
            domainName(model.domainName);
            scheduleAt(model.scheduleAt);
            desiredStartTime(model.desiredStartTime);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getScheduleAt() {
            return scheduleAt;
        }

        public final void setScheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
        }

        @Override
        public final Builder scheduleAt(String scheduleAt) {
            this.scheduleAt = scheduleAt;
            return this;
        }

        @Override
        public final Builder scheduleAt(ScheduleAt scheduleAt) {
            this.scheduleAt(scheduleAt == null ? null : scheduleAt.toString());
            return this;
        }

        public final Long getDesiredStartTime() {
            return desiredStartTime;
        }

        public final void setDesiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
        }

        @Override
        public final Builder desiredStartTime(Long desiredStartTime) {
            this.desiredStartTime = desiredStartTime;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartServiceSoftwareUpdateRequest build() {
            return new StartServiceSoftwareUpdateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
