/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for request parameters to the <code>UpdatePackage</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageRequest extends OpenSearchRequest implements
        ToCopyableBuilder<UpdatePackageRequest.Builder, UpdatePackageRequest> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(UpdatePackageRequest::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()).build();

    private static final SdkField<PackageSource> PACKAGE_SOURCE_FIELD = SdkField
            .<PackageSource> builder(MarshallingType.SDK_POJO).memberName("PackageSource")
            .getter(getter(UpdatePackageRequest::packageSource)).setter(setter(Builder::packageSource))
            .constructor(PackageSource::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageSource").build()).build();

    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageDescription").getter(getter(UpdatePackageRequest::packageDescription))
            .setter(setter(Builder::packageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build())
            .build();

    private static final SdkField<String> COMMIT_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CommitMessage").getter(getter(UpdatePackageRequest::commitMessage))
            .setter(setter(Builder::commitMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CommitMessage").build()).build();

    private static final SdkField<PackageConfiguration> PACKAGE_CONFIGURATION_FIELD = SdkField
            .<PackageConfiguration> builder(MarshallingType.SDK_POJO).memberName("PackageConfiguration")
            .getter(getter(UpdatePackageRequest::packageConfiguration)).setter(setter(Builder::packageConfiguration))
            .constructor(PackageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageConfiguration").build())
            .build();

    private static final SdkField<PackageEncryptionOptions> PACKAGE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<PackageEncryptionOptions> builder(MarshallingType.SDK_POJO).memberName("PackageEncryptionOptions")
            .getter(getter(UpdatePackageRequest::packageEncryptionOptions)).setter(setter(Builder::packageEncryptionOptions))
            .constructor(PackageEncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageEncryptionOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            PACKAGE_SOURCE_FIELD, PACKAGE_DESCRIPTION_FIELD, COMMIT_MESSAGE_FIELD, PACKAGE_CONFIGURATION_FIELD,
            PACKAGE_ENCRYPTION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageID;

    private final PackageSource packageSource;

    private final String packageDescription;

    private final String commitMessage;

    private final PackageConfiguration packageConfiguration;

    private final PackageEncryptionOptions packageEncryptionOptions;

    private UpdatePackageRequest(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.packageSource = builder.packageSource;
        this.packageDescription = builder.packageDescription;
        this.commitMessage = builder.commitMessage;
        this.packageConfiguration = builder.packageConfiguration;
        this.packageEncryptionOptions = builder.packageEncryptionOptions;
    }

    /**
     * <p>
     * The unique identifier for the package.
     * </p>
     * 
     * @return The unique identifier for the package.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * <p>
     * Amazon S3 bucket and key for the package.
     * </p>
     * 
     * @return Amazon S3 bucket and key for the package.
     */
    public final PackageSource packageSource() {
        return packageSource;
    }

    /**
     * <p>
     * A new description of the package.
     * </p>
     * 
     * @return A new description of the package.
     */
    public final String packageDescription() {
        return packageDescription;
    }

    /**
     * <p>
     * Commit message for the updated file, which is shown as part of <code>GetPackageVersionHistoryResponse</code>.
     * </p>
     * 
     * @return Commit message for the updated file, which is shown as part of
     *         <code>GetPackageVersionHistoryResponse</code>.
     */
    public final String commitMessage() {
        return commitMessage;
    }

    /**
     * <p>
     * The updated configuration details for a package.
     * </p>
     * 
     * @return The updated configuration details for a package.
     */
    public final PackageConfiguration packageConfiguration() {
        return packageConfiguration;
    }

    /**
     * <p>
     * Encryption options for a package.
     * </p>
     * 
     * @return Encryption options for a package.
     */
    public final PackageEncryptionOptions packageEncryptionOptions() {
        return packageEncryptionOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(packageSource());
        hashCode = 31 * hashCode + Objects.hashCode(packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(commitMessage());
        hashCode = 31 * hashCode + Objects.hashCode(packageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(packageEncryptionOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageRequest)) {
            return false;
        }
        UpdatePackageRequest other = (UpdatePackageRequest) obj;
        return Objects.equals(packageID(), other.packageID()) && Objects.equals(packageSource(), other.packageSource())
                && Objects.equals(packageDescription(), other.packageDescription())
                && Objects.equals(commitMessage(), other.commitMessage())
                && Objects.equals(packageConfiguration(), other.packageConfiguration())
                && Objects.equals(packageEncryptionOptions(), other.packageEncryptionOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageRequest").add("PackageID", packageID()).add("PackageSource", packageSource())
                .add("PackageDescription", packageDescription()).add("CommitMessage", commitMessage())
                .add("PackageConfiguration", packageConfiguration()).add("PackageEncryptionOptions", packageEncryptionOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "PackageSource":
            return Optional.ofNullable(clazz.cast(packageSource()));
        case "PackageDescription":
            return Optional.ofNullable(clazz.cast(packageDescription()));
        case "CommitMessage":
            return Optional.ofNullable(clazz.cast(commitMessage()));
        case "PackageConfiguration":
            return Optional.ofNullable(clazz.cast(packageConfiguration()));
        case "PackageEncryptionOptions":
            return Optional.ofNullable(clazz.cast(packageEncryptionOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageID", PACKAGE_ID_FIELD);
        map.put("PackageSource", PACKAGE_SOURCE_FIELD);
        map.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
        map.put("CommitMessage", COMMIT_MESSAGE_FIELD);
        map.put("PackageConfiguration", PACKAGE_CONFIGURATION_FIELD);
        map.put("PackageEncryptionOptions", PACKAGE_ENCRYPTION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageRequest, T> g) {
        return obj -> g.apply((UpdatePackageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePackageRequest> {
        /**
         * <p>
         * The unique identifier for the package.
         * </p>
         * 
         * @param packageID
         *        The unique identifier for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * <p>
         * Amazon S3 bucket and key for the package.
         * </p>
         * 
         * @param packageSource
         *        Amazon S3 bucket and key for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageSource(PackageSource packageSource);

        /**
         * <p>
         * Amazon S3 bucket and key for the package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageSource.Builder} avoiding the need
         * to create one manually via {@link PackageSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageSource.Builder#build()} is called immediately and its
         * result is passed to {@link #packageSource(PackageSource)}.
         * 
         * @param packageSource
         *        a consumer that will call methods on {@link PackageSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageSource(PackageSource)
         */
        default Builder packageSource(Consumer<PackageSource.Builder> packageSource) {
            return packageSource(PackageSource.builder().applyMutation(packageSource).build());
        }

        /**
         * <p>
         * A new description of the package.
         * </p>
         * 
         * @param packageDescription
         *        A new description of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDescription(String packageDescription);

        /**
         * <p>
         * Commit message for the updated file, which is shown as part of <code>GetPackageVersionHistoryResponse</code>.
         * </p>
         * 
         * @param commitMessage
         *        Commit message for the updated file, which is shown as part of
         *        <code>GetPackageVersionHistoryResponse</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder commitMessage(String commitMessage);

        /**
         * <p>
         * The updated configuration details for a package.
         * </p>
         * 
         * @param packageConfiguration
         *        The updated configuration details for a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageConfiguration(PackageConfiguration packageConfiguration);

        /**
         * <p>
         * The updated configuration details for a package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageConfiguration.Builder} avoiding
         * the need to create one manually via {@link PackageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #packageConfiguration(PackageConfiguration)}.
         * 
         * @param packageConfiguration
         *        a consumer that will call methods on {@link PackageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageConfiguration(PackageConfiguration)
         */
        default Builder packageConfiguration(Consumer<PackageConfiguration.Builder> packageConfiguration) {
            return packageConfiguration(PackageConfiguration.builder().applyMutation(packageConfiguration).build());
        }

        /**
         * <p>
         * Encryption options for a package.
         * </p>
         * 
         * @param packageEncryptionOptions
         *        Encryption options for a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions);

        /**
         * <p>
         * Encryption options for a package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageEncryptionOptions.Builder}
         * avoiding the need to create one manually via {@link PackageEncryptionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageEncryptionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #packageEncryptionOptions(PackageEncryptionOptions)}.
         * 
         * @param packageEncryptionOptions
         *        a consumer that will call methods on {@link PackageEncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageEncryptionOptions(PackageEncryptionOptions)
         */
        default Builder packageEncryptionOptions(Consumer<PackageEncryptionOptions.Builder> packageEncryptionOptions) {
            return packageEncryptionOptions(PackageEncryptionOptions.builder().applyMutation(packageEncryptionOptions).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String packageID;

        private PackageSource packageSource;

        private String packageDescription;

        private String commitMessage;

        private PackageConfiguration packageConfiguration;

        private PackageEncryptionOptions packageEncryptionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageRequest model) {
            super(model);
            packageID(model.packageID);
            packageSource(model.packageSource);
            packageDescription(model.packageDescription);
            commitMessage(model.commitMessage);
            packageConfiguration(model.packageConfiguration);
            packageEncryptionOptions(model.packageEncryptionOptions);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final PackageSource.Builder getPackageSource() {
            return packageSource != null ? packageSource.toBuilder() : null;
        }

        public final void setPackageSource(PackageSource.BuilderImpl packageSource) {
            this.packageSource = packageSource != null ? packageSource.build() : null;
        }

        @Override
        public final Builder packageSource(PackageSource packageSource) {
            this.packageSource = packageSource;
            return this;
        }

        public final String getPackageDescription() {
            return packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final String getCommitMessage() {
            return commitMessage;
        }

        public final void setCommitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
        }

        @Override
        public final Builder commitMessage(String commitMessage) {
            this.commitMessage = commitMessage;
            return this;
        }

        public final PackageConfiguration.Builder getPackageConfiguration() {
            return packageConfiguration != null ? packageConfiguration.toBuilder() : null;
        }

        public final void setPackageConfiguration(PackageConfiguration.BuilderImpl packageConfiguration) {
            this.packageConfiguration = packageConfiguration != null ? packageConfiguration.build() : null;
        }

        @Override
        public final Builder packageConfiguration(PackageConfiguration packageConfiguration) {
            this.packageConfiguration = packageConfiguration;
            return this;
        }

        public final PackageEncryptionOptions.Builder getPackageEncryptionOptions() {
            return packageEncryptionOptions != null ? packageEncryptionOptions.toBuilder() : null;
        }

        public final void setPackageEncryptionOptions(PackageEncryptionOptions.BuilderImpl packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions != null ? packageEncryptionOptions.build() : null;
        }

        @Override
        public final Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageRequest build() {
            return new UpdatePackageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
