/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The progress details of a specific domain configuration change.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ChangeProgressStatusDetails implements SdkPojo, Serializable,
        ToCopyableBuilder<ChangeProgressStatusDetails.Builder, ChangeProgressStatusDetails> {
    private static final SdkField<String> CHANGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChangeId").getter(getter(ChangeProgressStatusDetails::changeId)).setter(setter(Builder::changeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeId").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ChangeProgressStatusDetails::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ChangeProgressStatusDetails::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<String>> PENDING_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PendingProperties")
            .getter(getter(ChangeProgressStatusDetails::pendingProperties))
            .setter(setter(Builder::pendingProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> COMPLETED_PROPERTIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("CompletedProperties")
            .getter(getter(ChangeProgressStatusDetails::completedProperties))
            .setter(setter(Builder::completedProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletedProperties").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> TOTAL_NUMBER_OF_STAGES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("TotalNumberOfStages").getter(getter(ChangeProgressStatusDetails::totalNumberOfStages))
            .setter(setter(Builder::totalNumberOfStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalNumberOfStages").build())
            .build();

    private static final SdkField<List<ChangeProgressStage>> CHANGE_PROGRESS_STAGES_FIELD = SdkField
            .<List<ChangeProgressStage>> builder(MarshallingType.LIST)
            .memberName("ChangeProgressStages")
            .getter(getter(ChangeProgressStatusDetails::changeProgressStages))
            .setter(setter(Builder::changeProgressStages))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChangeProgressStages").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ChangeProgressStage> builder(MarshallingType.SDK_POJO)
                                            .constructor(ChangeProgressStage::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ChangeProgressStatusDetails::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<String> CONFIG_CHANGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ConfigChangeStatus").getter(getter(ChangeProgressStatusDetails::configChangeStatusAsString))
            .setter(setter(Builder::configChangeStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConfigChangeStatus").build())
            .build();

    private static final SdkField<String> INITIATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitiatedBy").getter(getter(ChangeProgressStatusDetails::initiatedByAsString))
            .setter(setter(Builder::initiatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHANGE_ID_FIELD,
            START_TIME_FIELD, STATUS_FIELD, PENDING_PROPERTIES_FIELD, COMPLETED_PROPERTIES_FIELD, TOTAL_NUMBER_OF_STAGES_FIELD,
            CHANGE_PROGRESS_STAGES_FIELD, LAST_UPDATED_TIME_FIELD, CONFIG_CHANGE_STATUS_FIELD, INITIATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String changeId;

    private final Instant startTime;

    private final String status;

    private final List<String> pendingProperties;

    private final List<String> completedProperties;

    private final Integer totalNumberOfStages;

    private final List<ChangeProgressStage> changeProgressStages;

    private final Instant lastUpdatedTime;

    private final String configChangeStatus;

    private final String initiatedBy;

    private ChangeProgressStatusDetails(BuilderImpl builder) {
        this.changeId = builder.changeId;
        this.startTime = builder.startTime;
        this.status = builder.status;
        this.pendingProperties = builder.pendingProperties;
        this.completedProperties = builder.completedProperties;
        this.totalNumberOfStages = builder.totalNumberOfStages;
        this.changeProgressStages = builder.changeProgressStages;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.configChangeStatus = builder.configChangeStatus;
        this.initiatedBy = builder.initiatedBy;
    }

    /**
     * <p>
     * The unique change identifier associated with a specific domain configuration change.
     * </p>
     * 
     * @return The unique change identifier associated with a specific domain configuration change.
     */
    public final String changeId() {
        return changeId;
    }

    /**
     * <p>
     * The time at which the configuration change is made on the domain.
     * </p>
     * 
     * @return The time at which the configuration change is made on the domain.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The overall status of the domain configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OverallChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The overall status of the domain configuration change.
     * @see OverallChangeStatus
     */
    public final OverallChangeStatus status() {
        return OverallChangeStatus.fromValue(status);
    }

    /**
     * <p>
     * The overall status of the domain configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link OverallChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The overall status of the domain configuration change.
     * @see OverallChangeStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the PendingProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPendingProperties() {
        return pendingProperties != null && !(pendingProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of properties in the domain configuration change that are still pending.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPendingProperties} method.
     * </p>
     * 
     * @return The list of properties in the domain configuration change that are still pending.
     */
    public final List<String> pendingProperties() {
        return pendingProperties;
    }

    /**
     * For responses, this returns true if the service returned a value for the CompletedProperties property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCompletedProperties() {
        return completedProperties != null && !(completedProperties instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of properties in the domain configuration change that have completed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCompletedProperties} method.
     * </p>
     * 
     * @return The list of properties in the domain configuration change that have completed.
     */
    public final List<String> completedProperties() {
        return completedProperties;
    }

    /**
     * <p>
     * The total number of stages required for the configuration change.
     * </p>
     * 
     * @return The total number of stages required for the configuration change.
     */
    public final Integer totalNumberOfStages() {
        return totalNumberOfStages;
    }

    /**
     * For responses, this returns true if the service returned a value for the ChangeProgressStages property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasChangeProgressStages() {
        return changeProgressStages != null && !(changeProgressStages instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The specific stages that the domain is going through to perform the configuration change.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasChangeProgressStages} method.
     * </p>
     * 
     * @return The specific stages that the domain is going through to perform the configuration change.
     */
    public final List<ChangeProgressStage> changeProgressStages() {
        return changeProgressStages;
    }

    /**
     * <p>
     * The last time that the status of the configuration change was updated.
     * </p>
     * 
     * @return The last time that the status of the configuration change was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * The current status of the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configChangeStatus} will return {@link ConfigChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #configChangeStatusAsString}.
     * </p>
     * 
     * @return The current status of the configuration change.
     * @see ConfigChangeStatus
     */
    public final ConfigChangeStatus configChangeStatus() {
        return ConfigChangeStatus.fromValue(configChangeStatus);
    }

    /**
     * <p>
     * The current status of the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #configChangeStatus} will return {@link ConfigChangeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #configChangeStatusAsString}.
     * </p>
     * 
     * @return The current status of the configuration change.
     * @see ConfigChangeStatus
     */
    public final String configChangeStatusAsString() {
        return configChangeStatus;
    }

    /**
     * <p>
     * The IAM principal who initiated the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiatedBy} will
     * return {@link InitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiatedByAsString}.
     * </p>
     * 
     * @return The IAM principal who initiated the configuration change.
     * @see InitiatedBy
     */
    public final InitiatedBy initiatedBy() {
        return InitiatedBy.fromValue(initiatedBy);
    }

    /**
     * <p>
     * The IAM principal who initiated the configuration change.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #initiatedBy} will
     * return {@link InitiatedBy#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #initiatedByAsString}.
     * </p>
     * 
     * @return The IAM principal who initiated the configuration change.
     * @see InitiatedBy
     */
    public final String initiatedByAsString() {
        return initiatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(changeId());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPendingProperties() ? pendingProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCompletedProperties() ? completedProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(totalNumberOfStages());
        hashCode = 31 * hashCode + Objects.hashCode(hasChangeProgressStages() ? changeProgressStages() : null);
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(configChangeStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(initiatedByAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ChangeProgressStatusDetails)) {
            return false;
        }
        ChangeProgressStatusDetails other = (ChangeProgressStatusDetails) obj;
        return Objects.equals(changeId(), other.changeId()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(statusAsString(), other.statusAsString())
                && hasPendingProperties() == other.hasPendingProperties()
                && Objects.equals(pendingProperties(), other.pendingProperties())
                && hasCompletedProperties() == other.hasCompletedProperties()
                && Objects.equals(completedProperties(), other.completedProperties())
                && Objects.equals(totalNumberOfStages(), other.totalNumberOfStages())
                && hasChangeProgressStages() == other.hasChangeProgressStages()
                && Objects.equals(changeProgressStages(), other.changeProgressStages())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(configChangeStatusAsString(), other.configChangeStatusAsString())
                && Objects.equals(initiatedByAsString(), other.initiatedByAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ChangeProgressStatusDetails").add("ChangeId", changeId()).add("StartTime", startTime())
                .add("Status", statusAsString()).add("PendingProperties", hasPendingProperties() ? pendingProperties() : null)
                .add("CompletedProperties", hasCompletedProperties() ? completedProperties() : null)
                .add("TotalNumberOfStages", totalNumberOfStages())
                .add("ChangeProgressStages", hasChangeProgressStages() ? changeProgressStages() : null)
                .add("LastUpdatedTime", lastUpdatedTime()).add("ConfigChangeStatus", configChangeStatusAsString())
                .add("InitiatedBy", initiatedByAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChangeId":
            return Optional.ofNullable(clazz.cast(changeId()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "PendingProperties":
            return Optional.ofNullable(clazz.cast(pendingProperties()));
        case "CompletedProperties":
            return Optional.ofNullable(clazz.cast(completedProperties()));
        case "TotalNumberOfStages":
            return Optional.ofNullable(clazz.cast(totalNumberOfStages()));
        case "ChangeProgressStages":
            return Optional.ofNullable(clazz.cast(changeProgressStages()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "ConfigChangeStatus":
            return Optional.ofNullable(clazz.cast(configChangeStatusAsString()));
        case "InitiatedBy":
            return Optional.ofNullable(clazz.cast(initiatedByAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ChangeId", CHANGE_ID_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PendingProperties", PENDING_PROPERTIES_FIELD);
        map.put("CompletedProperties", COMPLETED_PROPERTIES_FIELD);
        map.put("TotalNumberOfStages", TOTAL_NUMBER_OF_STAGES_FIELD);
        map.put("ChangeProgressStages", CHANGE_PROGRESS_STAGES_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        map.put("ConfigChangeStatus", CONFIG_CHANGE_STATUS_FIELD);
        map.put("InitiatedBy", INITIATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ChangeProgressStatusDetails, T> g) {
        return obj -> g.apply((ChangeProgressStatusDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ChangeProgressStatusDetails> {
        /**
         * <p>
         * The unique change identifier associated with a specific domain configuration change.
         * </p>
         * 
         * @param changeId
         *        The unique change identifier associated with a specific domain configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeId(String changeId);

        /**
         * <p>
         * The time at which the configuration change is made on the domain.
         * </p>
         * 
         * @param startTime
         *        The time at which the configuration change is made on the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The overall status of the domain configuration change.
         * </p>
         * 
         * @param status
         *        The overall status of the domain configuration change.
         * @see OverallChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverallChangeStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The overall status of the domain configuration change.
         * </p>
         * 
         * @param status
         *        The overall status of the domain configuration change.
         * @see OverallChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see OverallChangeStatus
         */
        Builder status(OverallChangeStatus status);

        /**
         * <p>
         * The list of properties in the domain configuration change that are still pending.
         * </p>
         * 
         * @param pendingProperties
         *        The list of properties in the domain configuration change that are still pending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingProperties(Collection<String> pendingProperties);

        /**
         * <p>
         * The list of properties in the domain configuration change that are still pending.
         * </p>
         * 
         * @param pendingProperties
         *        The list of properties in the domain configuration change that are still pending.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pendingProperties(String... pendingProperties);

        /**
         * <p>
         * The list of properties in the domain configuration change that have completed.
         * </p>
         * 
         * @param completedProperties
         *        The list of properties in the domain configuration change that have completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedProperties(Collection<String> completedProperties);

        /**
         * <p>
         * The list of properties in the domain configuration change that have completed.
         * </p>
         * 
         * @param completedProperties
         *        The list of properties in the domain configuration change that have completed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder completedProperties(String... completedProperties);

        /**
         * <p>
         * The total number of stages required for the configuration change.
         * </p>
         * 
         * @param totalNumberOfStages
         *        The total number of stages required for the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder totalNumberOfStages(Integer totalNumberOfStages);

        /**
         * <p>
         * The specific stages that the domain is going through to perform the configuration change.
         * </p>
         * 
         * @param changeProgressStages
         *        The specific stages that the domain is going through to perform the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressStages(Collection<ChangeProgressStage> changeProgressStages);

        /**
         * <p>
         * The specific stages that the domain is going through to perform the configuration change.
         * </p>
         * 
         * @param changeProgressStages
         *        The specific stages that the domain is going through to perform the configuration change.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder changeProgressStages(ChangeProgressStage... changeProgressStages);

        /**
         * <p>
         * The specific stages that the domain is going through to perform the configuration change.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.ChangeProgressStage.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.ChangeProgressStage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.ChangeProgressStage.Builder#build()} is called
         * immediately and its result is passed to {@link #changeProgressStages(List<ChangeProgressStage>)}.
         * 
         * @param changeProgressStages
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.ChangeProgressStage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #changeProgressStages(java.util.Collection<ChangeProgressStage>)
         */
        Builder changeProgressStages(Consumer<ChangeProgressStage.Builder>... changeProgressStages);

        /**
         * <p>
         * The last time that the status of the configuration change was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time that the status of the configuration change was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * The current status of the configuration change.
         * </p>
         * 
         * @param configChangeStatus
         *        The current status of the configuration change.
         * @see ConfigChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigChangeStatus
         */
        Builder configChangeStatus(String configChangeStatus);

        /**
         * <p>
         * The current status of the configuration change.
         * </p>
         * 
         * @param configChangeStatus
         *        The current status of the configuration change.
         * @see ConfigChangeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfigChangeStatus
         */
        Builder configChangeStatus(ConfigChangeStatus configChangeStatus);

        /**
         * <p>
         * The IAM principal who initiated the configuration change.
         * </p>
         * 
         * @param initiatedBy
         *        The IAM principal who initiated the configuration change.
         * @see InitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiatedBy
         */
        Builder initiatedBy(String initiatedBy);

        /**
         * <p>
         * The IAM principal who initiated the configuration change.
         * </p>
         * 
         * @param initiatedBy
         *        The IAM principal who initiated the configuration change.
         * @see InitiatedBy
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InitiatedBy
         */
        Builder initiatedBy(InitiatedBy initiatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String changeId;

        private Instant startTime;

        private String status;

        private List<String> pendingProperties = DefaultSdkAutoConstructList.getInstance();

        private List<String> completedProperties = DefaultSdkAutoConstructList.getInstance();

        private Integer totalNumberOfStages;

        private List<ChangeProgressStage> changeProgressStages = DefaultSdkAutoConstructList.getInstance();

        private Instant lastUpdatedTime;

        private String configChangeStatus;

        private String initiatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(ChangeProgressStatusDetails model) {
            changeId(model.changeId);
            startTime(model.startTime);
            status(model.status);
            pendingProperties(model.pendingProperties);
            completedProperties(model.completedProperties);
            totalNumberOfStages(model.totalNumberOfStages);
            changeProgressStages(model.changeProgressStages);
            lastUpdatedTime(model.lastUpdatedTime);
            configChangeStatus(model.configChangeStatus);
            initiatedBy(model.initiatedBy);
        }

        public final String getChangeId() {
            return changeId;
        }

        public final void setChangeId(String changeId) {
            this.changeId = changeId;
        }

        @Override
        public final Builder changeId(String changeId) {
            this.changeId = changeId;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OverallChangeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Collection<String> getPendingProperties() {
            if (pendingProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return pendingProperties;
        }

        public final void setPendingProperties(Collection<String> pendingProperties) {
            this.pendingProperties = StringListCopier.copy(pendingProperties);
        }

        @Override
        public final Builder pendingProperties(Collection<String> pendingProperties) {
            this.pendingProperties = StringListCopier.copy(pendingProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pendingProperties(String... pendingProperties) {
            pendingProperties(Arrays.asList(pendingProperties));
            return this;
        }

        public final Collection<String> getCompletedProperties() {
            if (completedProperties instanceof SdkAutoConstructList) {
                return null;
            }
            return completedProperties;
        }

        public final void setCompletedProperties(Collection<String> completedProperties) {
            this.completedProperties = StringListCopier.copy(completedProperties);
        }

        @Override
        public final Builder completedProperties(Collection<String> completedProperties) {
            this.completedProperties = StringListCopier.copy(completedProperties);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder completedProperties(String... completedProperties) {
            completedProperties(Arrays.asList(completedProperties));
            return this;
        }

        public final Integer getTotalNumberOfStages() {
            return totalNumberOfStages;
        }

        public final void setTotalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
        }

        @Override
        public final Builder totalNumberOfStages(Integer totalNumberOfStages) {
            this.totalNumberOfStages = totalNumberOfStages;
            return this;
        }

        public final List<ChangeProgressStage.Builder> getChangeProgressStages() {
            List<ChangeProgressStage.Builder> result = ChangeProgressStageListCopier.copyToBuilder(this.changeProgressStages);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChangeProgressStages(Collection<ChangeProgressStage.BuilderImpl> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copyFromBuilder(changeProgressStages);
        }

        @Override
        public final Builder changeProgressStages(Collection<ChangeProgressStage> changeProgressStages) {
            this.changeProgressStages = ChangeProgressStageListCopier.copy(changeProgressStages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(ChangeProgressStage... changeProgressStages) {
            changeProgressStages(Arrays.asList(changeProgressStages));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder changeProgressStages(Consumer<ChangeProgressStage.Builder>... changeProgressStages) {
            changeProgressStages(Stream.of(changeProgressStages).map(c -> ChangeProgressStage.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final String getConfigChangeStatus() {
            return configChangeStatus;
        }

        public final void setConfigChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
        }

        @Override
        public final Builder configChangeStatus(String configChangeStatus) {
            this.configChangeStatus = configChangeStatus;
            return this;
        }

        @Override
        public final Builder configChangeStatus(ConfigChangeStatus configChangeStatus) {
            this.configChangeStatus(configChangeStatus == null ? null : configChangeStatus.toString());
            return this;
        }

        public final String getInitiatedBy() {
            return initiatedBy;
        }

        public final void setInitiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
        }

        @Override
        public final Builder initiatedBy(String initiatedBy) {
            this.initiatedBy = initiatedBy;
            return this;
        }

        @Override
        public final Builder initiatedBy(InitiatedBy initiatedBy) {
            this.initiatedBy(initiatedBy == null ? null : initiatedBy.toString());
            return this;
        }

        @Override
        public ChangeProgressStatusDetails build() {
            return new ChangeProgressStatusDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
