/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApplicationRequest extends OpenSearchRequest implements
        ToCopyableBuilder<CreateApplicationRequest.Builder, CreateApplicationRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateApplicationRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateApplicationRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<DataSource>> DATA_SOURCES_FIELD = SdkField
            .<List<DataSource>> builder(MarshallingType.LIST)
            .memberName("dataSources")
            .getter(getter(CreateApplicationRequest::dataSources))
            .setter(setter(Builder::dataSources))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSources").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DataSource> builder(MarshallingType.SDK_POJO)
                                            .constructor(DataSource::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<IamIdentityCenterOptionsInput> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField
            .<IamIdentityCenterOptionsInput> builder(MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions")
            .getter(getter(CreateApplicationRequest::iamIdentityCenterOptions)).setter(setter(Builder::iamIdentityCenterOptions))
            .constructor(IamIdentityCenterOptionsInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build())
            .build();

    private static final SdkField<List<AppConfig>> APP_CONFIGS_FIELD = SdkField
            .<List<AppConfig>> builder(MarshallingType.LIST)
            .memberName("appConfigs")
            .getter(getter(CreateApplicationRequest::appConfigs))
            .setter(setter(Builder::appConfigs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appConfigs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AppConfig> builder(MarshallingType.SDK_POJO)
                                            .constructor(AppConfig::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Tag>> TAG_LIST_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tagList")
            .getter(getter(CreateApplicationRequest::tagList))
            .setter(setter(Builder::tagList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tagList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            NAME_FIELD, DATA_SOURCES_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, APP_CONFIGS_FIELD, TAG_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String name;

    private final List<DataSource> dataSources;

    private final IamIdentityCenterOptionsInput iamIdentityCenterOptions;

    private final List<AppConfig> appConfigs;

    private final List<Tag> tagList;

    private CreateApplicationRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.name = builder.name;
        this.dataSources = builder.dataSources;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.appConfigs = builder.appConfigs;
        this.tagList = builder.tagList;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The unique name of the OpenSearch application. Names must be unique within an Amazon Web Services Region for each
     * account.
     * </p>
     * 
     * @return The unique name of the OpenSearch application. Names must be unique within an Amazon Web Services Region
     *         for each account.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataSources property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataSources() {
        return dataSources != null && !(dataSources instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data sources to link to the OpenSearch application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataSources} method.
     * </p>
     * 
     * @return The data sources to link to the OpenSearch application.
     */
    public final List<DataSource> dataSources() {
        return dataSources;
    }

    /**
     * <p>
     * Configuration settings for integrating Amazon Web Services IAM Identity Center with the OpenSearch application.
     * </p>
     * 
     * @return Configuration settings for integrating Amazon Web Services IAM Identity Center with the OpenSearch
     *         application.
     */
    public final IamIdentityCenterOptionsInput iamIdentityCenterOptions() {
        return iamIdentityCenterOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the AppConfigs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAppConfigs() {
        return appConfigs != null && !(appConfigs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Configuration settings for the OpenSearch application, including administrative options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAppConfigs} method.
     * </p>
     * 
     * @return Configuration settings for the OpenSearch application, including administrative options.
     */
    public final List<AppConfig> appConfigs() {
        return appConfigs;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagList() {
        return tagList != null && !(tagList instanceof SdkAutoConstructList);
    }

    /**
     * Returns the value of the TagList property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagList} method.
     * </p>
     * 
     * @return The value of the TagList property for this object.
     */
    public final List<Tag> tagList() {
        return tagList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasDataSources() ? dataSources() : null);
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(hasAppConfigs() ? appConfigs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTagList() ? tagList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApplicationRequest)) {
            return false;
        }
        CreateApplicationRequest other = (CreateApplicationRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(name(), other.name())
                && hasDataSources() == other.hasDataSources() && Objects.equals(dataSources(), other.dataSources())
                && Objects.equals(iamIdentityCenterOptions(), other.iamIdentityCenterOptions())
                && hasAppConfigs() == other.hasAppConfigs() && Objects.equals(appConfigs(), other.appConfigs())
                && hasTagList() == other.hasTagList() && Objects.equals(tagList(), other.tagList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApplicationRequest").add("ClientToken", clientToken()).add("Name", name())
                .add("DataSources", hasDataSources() ? dataSources() : null)
                .add("IamIdentityCenterOptions", iamIdentityCenterOptions())
                .add("AppConfigs", hasAppConfigs() ? appConfigs() : null).add("TagList", hasTagList() ? tagList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "dataSources":
            return Optional.ofNullable(clazz.cast(dataSources()));
        case "iamIdentityCenterOptions":
            return Optional.ofNullable(clazz.cast(iamIdentityCenterOptions()));
        case "appConfigs":
            return Optional.ofNullable(clazz.cast(appConfigs()));
        case "tagList":
            return Optional.ofNullable(clazz.cast(tagList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("name", NAME_FIELD);
        map.put("dataSources", DATA_SOURCES_FIELD);
        map.put("iamIdentityCenterOptions", IAM_IDENTITY_CENTER_OPTIONS_FIELD);
        map.put("appConfigs", APP_CONFIGS_FIELD);
        map.put("tagList", TAG_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApplicationRequest, T> g) {
        return obj -> g.apply((CreateApplicationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApplicationRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The unique name of the OpenSearch application. Names must be unique within an Amazon Web Services Region for
         * each account.
         * </p>
         * 
         * @param name
         *        The unique name of the OpenSearch application. Names must be unique within an Amazon Web Services
         *        Region for each account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The data sources to link to the OpenSearch application.
         * </p>
         * 
         * @param dataSources
         *        The data sources to link to the OpenSearch application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(Collection<DataSource> dataSources);

        /**
         * <p>
         * The data sources to link to the OpenSearch application.
         * </p>
         * 
         * @param dataSources
         *        The data sources to link to the OpenSearch application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSources(DataSource... dataSources);

        /**
         * <p>
         * The data sources to link to the OpenSearch application.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.DataSource#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSources(List<DataSource>)}.
         * 
         * @param dataSources
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.DataSource.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSources(java.util.Collection<DataSource>)
         */
        Builder dataSources(Consumer<DataSource.Builder>... dataSources);

        /**
         * <p>
         * Configuration settings for integrating Amazon Web Services IAM Identity Center with the OpenSearch
         * application.
         * </p>
         * 
         * @param iamIdentityCenterOptions
         *        Configuration settings for integrating Amazon Web Services IAM Identity Center with the OpenSearch
         *        application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenterOptions(IamIdentityCenterOptionsInput iamIdentityCenterOptions);

        /**
         * <p>
         * Configuration settings for integrating Amazon Web Services IAM Identity Center with the OpenSearch
         * application.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamIdentityCenterOptionsInput.Builder}
         * avoiding the need to create one manually via {@link IamIdentityCenterOptionsInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamIdentityCenterOptionsInput.Builder#build()} is called
         * immediately and its result is passed to {@link #iamIdentityCenterOptions(IamIdentityCenterOptionsInput)}.
         * 
         * @param iamIdentityCenterOptions
         *        a consumer that will call methods on {@link IamIdentityCenterOptionsInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamIdentityCenterOptions(IamIdentityCenterOptionsInput)
         */
        default Builder iamIdentityCenterOptions(Consumer<IamIdentityCenterOptionsInput.Builder> iamIdentityCenterOptions) {
            return iamIdentityCenterOptions(IamIdentityCenterOptionsInput.builder().applyMutation(iamIdentityCenterOptions)
                    .build());
        }

        /**
         * <p>
         * Configuration settings for the OpenSearch application, including administrative options.
         * </p>
         * 
         * @param appConfigs
         *        Configuration settings for the OpenSearch application, including administrative options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appConfigs(Collection<AppConfig> appConfigs);

        /**
         * <p>
         * Configuration settings for the OpenSearch application, including administrative options.
         * </p>
         * 
         * @param appConfigs
         *        Configuration settings for the OpenSearch application, including administrative options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appConfigs(AppConfig... appConfigs);

        /**
         * <p>
         * Configuration settings for the OpenSearch application, including administrative options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.opensearch.model.AppConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #appConfigs(List<AppConfig>)}.
         * 
         * @param appConfigs
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.AppConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appConfigs(java.util.Collection<AppConfig>)
         */
        Builder appConfigs(Consumer<AppConfig.Builder>... appConfigs);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Collection<Tag> tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * @param tagList
         *        The new value for the TagList property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagList(Tag... tagList);

        /**
         * Sets the value of the TagList property for this object.
         *
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder} avoiding the need to create one manually
         * via {@link software.amazon.awssdk.services.opensearch.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder#build()} is called immediately and its
         * result is passed to {@link #tagList(List<Tag>)}.
         * 
         * @param tagList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagList(java.util.Collection<Tag>)
         */
        Builder tagList(Consumer<Tag.Builder>... tagList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String name;

        private List<DataSource> dataSources = DefaultSdkAutoConstructList.getInstance();

        private IamIdentityCenterOptionsInput iamIdentityCenterOptions;

        private List<AppConfig> appConfigs = DefaultSdkAutoConstructList.getInstance();

        private List<Tag> tagList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApplicationRequest model) {
            super(model);
            clientToken(model.clientToken);
            name(model.name);
            dataSources(model.dataSources);
            iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            appConfigs(model.appConfigs);
            tagList(model.tagList);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<DataSource.Builder> getDataSources() {
            List<DataSource.Builder> result = DataSourcesCopier.copyToBuilder(this.dataSources);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataSources(Collection<DataSource.BuilderImpl> dataSources) {
            this.dataSources = DataSourcesCopier.copyFromBuilder(dataSources);
        }

        @Override
        public final Builder dataSources(Collection<DataSource> dataSources) {
            this.dataSources = DataSourcesCopier.copy(dataSources);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(DataSource... dataSources) {
            dataSources(Arrays.asList(dataSources));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataSources(Consumer<DataSource.Builder>... dataSources) {
            dataSources(Stream.of(dataSources).map(c -> DataSource.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final IamIdentityCenterOptionsInput.Builder getIamIdentityCenterOptions() {
            return iamIdentityCenterOptions != null ? iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(IamIdentityCenterOptionsInput.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(IamIdentityCenterOptionsInput iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final List<AppConfig.Builder> getAppConfigs() {
            List<AppConfig.Builder> result = AppConfigsCopier.copyToBuilder(this.appConfigs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAppConfigs(Collection<AppConfig.BuilderImpl> appConfigs) {
            this.appConfigs = AppConfigsCopier.copyFromBuilder(appConfigs);
        }

        @Override
        public final Builder appConfigs(Collection<AppConfig> appConfigs) {
            this.appConfigs = AppConfigsCopier.copy(appConfigs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(AppConfig... appConfigs) {
            appConfigs(Arrays.asList(appConfigs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder appConfigs(Consumer<AppConfig.Builder>... appConfigs) {
            appConfigs(Stream.of(appConfigs).map(c -> AppConfig.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Tag.Builder> getTagList() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tagList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagList(Collection<Tag.BuilderImpl> tagList) {
            this.tagList = TagListCopier.copyFromBuilder(tagList);
        }

        @Override
        public final Builder tagList(Collection<Tag> tagList) {
            this.tagList = TagListCopier.copy(tagList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Tag... tagList) {
            tagList(Arrays.asList(tagList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagList(Consumer<Tag.Builder>... tagList) {
            tagList(Stream.of(tagList).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApplicationRequest build() {
            return new CreateApplicationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
