/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DeleteVpcEndpointResponse.Builder, DeleteVpcEndpointResponse> {
    private static final SdkField<VpcEndpointSummary> VPC_ENDPOINT_SUMMARY_FIELD = SdkField
            .<VpcEndpointSummary> builder(MarshallingType.SDK_POJO).memberName("VpcEndpointSummary")
            .getter(getter(DeleteVpcEndpointResponse::vpcEndpointSummary)).setter(setter(Builder::vpcEndpointSummary))
            .constructor(VpcEndpointSummary::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpointSummary").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_SUMMARY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcEndpointSummary vpcEndpointSummary;

    private DeleteVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointSummary = builder.vpcEndpointSummary;
    }

    /**
     * <p>
     * Information about the deleted endpoint, including its current status (<code>DELETING</code> or
     * <code>DELETE_FAILED</code>).
     * </p>
     * 
     * @return Information about the deleted endpoint, including its current status (<code>DELETING</code> or
     *         <code>DELETE_FAILED</code>).
     */
    public final VpcEndpointSummary vpcEndpointSummary() {
        return vpcEndpointSummary;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpointSummary());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointResponse)) {
            return false;
        }
        DeleteVpcEndpointResponse other = (DeleteVpcEndpointResponse) obj;
        return Objects.equals(vpcEndpointSummary(), other.vpcEndpointSummary());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcEndpointResponse").add("VpcEndpointSummary", vpcEndpointSummary()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpointSummary":
            return Optional.ofNullable(clazz.cast(vpcEndpointSummary()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpointSummary", VPC_ENDPOINT_SUMMARY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointResponse, T> g) {
        return obj -> g.apply((DeleteVpcEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteVpcEndpointResponse> {
        /**
         * <p>
         * Information about the deleted endpoint, including its current status (<code>DELETING</code> or
         * <code>DELETE_FAILED</code>).
         * </p>
         * 
         * @param vpcEndpointSummary
         *        Information about the deleted endpoint, including its current status (<code>DELETING</code> or
         *        <code>DELETE_FAILED</code>).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointSummary(VpcEndpointSummary vpcEndpointSummary);

        /**
         * <p>
         * Information about the deleted endpoint, including its current status (<code>DELETING</code> or
         * <code>DELETE_FAILED</code>).
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEndpointSummary.Builder} avoiding the
         * need to create one manually via {@link VpcEndpointSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEndpointSummary.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcEndpointSummary(VpcEndpointSummary)}.
         * 
         * @param vpcEndpointSummary
         *        a consumer that will call methods on {@link VpcEndpointSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointSummary(VpcEndpointSummary)
         */
        default Builder vpcEndpointSummary(Consumer<VpcEndpointSummary.Builder> vpcEndpointSummary) {
            return vpcEndpointSummary(VpcEndpointSummary.builder().applyMutation(vpcEndpointSummary).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private VpcEndpointSummary vpcEndpointSummary;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointResponse model) {
            super(model);
            vpcEndpointSummary(model.vpcEndpointSummary);
        }

        public final VpcEndpointSummary.Builder getVpcEndpointSummary() {
            return vpcEndpointSummary != null ? vpcEndpointSummary.toBuilder() : null;
        }

        public final void setVpcEndpointSummary(VpcEndpointSummary.BuilderImpl vpcEndpointSummary) {
            this.vpcEndpointSummary = vpcEndpointSummary != null ? vpcEndpointSummary.build() : null;
        }

        @Override
        public final Builder vpcEndpointSummary(VpcEndpointSummary vpcEndpointSummary) {
            this.vpcEndpointSummary = vpcEndpointSummary;
            return this;
        }

        @Override
        public DeleteVpcEndpointResponse build() {
            return new DeleteVpcEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
