/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the response returned by an <code>DissociatePackage</code> operation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DissociatePackageResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DissociatePackageResponse.Builder, DissociatePackageResponse> {
    private static final SdkField<DomainPackageDetails> DOMAIN_PACKAGE_DETAILS_FIELD = SdkField
            .<DomainPackageDetails> builder(MarshallingType.SDK_POJO).memberName("DomainPackageDetails")
            .getter(getter(DissociatePackageResponse::domainPackageDetails)).setter(setter(Builder::domainPackageDetails))
            .constructor(DomainPackageDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainPackageDetails").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_PACKAGE_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final DomainPackageDetails domainPackageDetails;

    private DissociatePackageResponse(BuilderImpl builder) {
        super(builder);
        this.domainPackageDetails = builder.domainPackageDetails;
    }

    /**
     * <p>
     * Information about a package that has been dissociated from the domain.
     * </p>
     * 
     * @return Information about a package that has been dissociated from the domain.
     */
    public final DomainPackageDetails domainPackageDetails() {
        return domainPackageDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainPackageDetails());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DissociatePackageResponse)) {
            return false;
        }
        DissociatePackageResponse other = (DissociatePackageResponse) obj;
        return Objects.equals(domainPackageDetails(), other.domainPackageDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DissociatePackageResponse").add("DomainPackageDetails", domainPackageDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainPackageDetails":
            return Optional.ofNullable(clazz.cast(domainPackageDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainPackageDetails", DOMAIN_PACKAGE_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DissociatePackageResponse, T> g) {
        return obj -> g.apply((DissociatePackageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DissociatePackageResponse> {
        /**
         * <p>
         * Information about a package that has been dissociated from the domain.
         * </p>
         * 
         * @param domainPackageDetails
         *        Information about a package that has been dissociated from the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainPackageDetails(DomainPackageDetails domainPackageDetails);

        /**
         * <p>
         * Information about a package that has been dissociated from the domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainPackageDetails.Builder} avoiding
         * the need to create one manually via {@link DomainPackageDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainPackageDetails.Builder#build()} is called immediately and
         * its result is passed to {@link #domainPackageDetails(DomainPackageDetails)}.
         * 
         * @param domainPackageDetails
         *        a consumer that will call methods on {@link DomainPackageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainPackageDetails(DomainPackageDetails)
         */
        default Builder domainPackageDetails(Consumer<DomainPackageDetails.Builder> domainPackageDetails) {
            return domainPackageDetails(DomainPackageDetails.builder().applyMutation(domainPackageDetails).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private DomainPackageDetails domainPackageDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(DissociatePackageResponse model) {
            super(model);
            domainPackageDetails(model.domainPackageDetails);
        }

        public final DomainPackageDetails.Builder getDomainPackageDetails() {
            return domainPackageDetails != null ? domainPackageDetails.toBuilder() : null;
        }

        public final void setDomainPackageDetails(DomainPackageDetails.BuilderImpl domainPackageDetails) {
            this.domainPackageDetails = domainPackageDetails != null ? domainPackageDetails.build() : null;
        }

        @Override
        public final Builder domainPackageDetails(DomainPackageDetails domainPackageDetails) {
            this.domainPackageDetails = domainPackageDetails;
            return this;
        }

        @Override
        public DissociatePackageResponse build() {
            return new DissociatePackageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
