/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DissociatePackagesResponse extends OpenSearchResponse implements
        ToCopyableBuilder<DissociatePackagesResponse.Builder, DissociatePackagesResponse> {
    private static final SdkField<List<DomainPackageDetails>> DOMAIN_PACKAGE_DETAILS_LIST_FIELD = SdkField
            .<List<DomainPackageDetails>> builder(MarshallingType.LIST)
            .memberName("DomainPackageDetailsList")
            .getter(getter(DissociatePackagesResponse::domainPackageDetailsList))
            .setter(setter(Builder::domainPackageDetailsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainPackageDetailsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<DomainPackageDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(DomainPackageDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DOMAIN_PACKAGE_DETAILS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<DomainPackageDetails> domainPackageDetailsList;

    private DissociatePackagesResponse(BuilderImpl builder) {
        super(builder);
        this.domainPackageDetailsList = builder.domainPackageDetailsList;
    }

    /**
     * For responses, this returns true if the service returned a value for the DomainPackageDetailsList property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasDomainPackageDetailsList() {
        return domainPackageDetailsList != null && !(domainPackageDetailsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of package details for the packages that were dissociated from the domain.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDomainPackageDetailsList} method.
     * </p>
     * 
     * @return A list of package details for the packages that were dissociated from the domain.
     */
    public final List<DomainPackageDetails> domainPackageDetailsList() {
        return domainPackageDetailsList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasDomainPackageDetailsList() ? domainPackageDetailsList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DissociatePackagesResponse)) {
            return false;
        }
        DissociatePackagesResponse other = (DissociatePackagesResponse) obj;
        return hasDomainPackageDetailsList() == other.hasDomainPackageDetailsList()
                && Objects.equals(domainPackageDetailsList(), other.domainPackageDetailsList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DissociatePackagesResponse")
                .add("DomainPackageDetailsList", hasDomainPackageDetailsList() ? domainPackageDetailsList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainPackageDetailsList":
            return Optional.ofNullable(clazz.cast(domainPackageDetailsList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainPackageDetailsList", DOMAIN_PACKAGE_DETAILS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DissociatePackagesResponse, T> g) {
        return obj -> g.apply((DissociatePackagesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, DissociatePackagesResponse> {
        /**
         * <p>
         * A list of package details for the packages that were dissociated from the domain.
         * </p>
         * 
         * @param domainPackageDetailsList
         *        A list of package details for the packages that were dissociated from the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainPackageDetailsList(Collection<DomainPackageDetails> domainPackageDetailsList);

        /**
         * <p>
         * A list of package details for the packages that were dissociated from the domain.
         * </p>
         * 
         * @param domainPackageDetailsList
         *        A list of package details for the packages that were dissociated from the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainPackageDetailsList(DomainPackageDetails... domainPackageDetailsList);

        /**
         * <p>
         * A list of package details for the packages that were dissociated from the domain.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.DomainPackageDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.DomainPackageDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.DomainPackageDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #domainPackageDetailsList(List<DomainPackageDetails>)}.
         * 
         * @param domainPackageDetailsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.DomainPackageDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainPackageDetailsList(java.util.Collection<DomainPackageDetails>)
         */
        Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder>... domainPackageDetailsList);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private List<DomainPackageDetails> domainPackageDetailsList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DissociatePackagesResponse model) {
            super(model);
            domainPackageDetailsList(model.domainPackageDetailsList);
        }

        public final List<DomainPackageDetails.Builder> getDomainPackageDetailsList() {
            List<DomainPackageDetails.Builder> result = DomainPackageDetailsListCopier
                    .copyToBuilder(this.domainPackageDetailsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainPackageDetailsList(Collection<DomainPackageDetails.BuilderImpl> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copyFromBuilder(domainPackageDetailsList);
        }

        @Override
        public final Builder domainPackageDetailsList(Collection<DomainPackageDetails> domainPackageDetailsList) {
            this.domainPackageDetailsList = DomainPackageDetailsListCopier.copy(domainPackageDetailsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(DomainPackageDetails... domainPackageDetailsList) {
            domainPackageDetailsList(Arrays.asList(domainPackageDetailsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainPackageDetailsList(Consumer<DomainPackageDetails.Builder>... domainPackageDetailsList) {
            domainPackageDetailsList(Stream.of(domainPackageDetailsList)
                    .map(c -> DomainPackageDetails.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DissociatePackagesResponse build() {
            return new DissociatePackagesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
