/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about an OpenSearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainInfo implements SdkPojo, Serializable, ToCopyableBuilder<DomainInfo.Builder, DomainInfo> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DomainName").getter(getter(DomainInfo::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<String> ENGINE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineType").getter(getter(DomainInfo::engineTypeAsString)).setter(setter(Builder::engineType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            ENGINE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String engineType;

    private DomainInfo(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.engineType = builder.engineType;
    }

    /**
     * <p>
     * Name of the domain.
     * </p>
     * 
     * @return Name of the domain.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine, or
     * <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine, or
     *         <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
     * @see EngineType
     */
    public final EngineType engineType() {
        return EngineType.fromValue(engineType);
    }

    /**
     * <p>
     * The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine, or
     * <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #engineType} will
     * return {@link EngineType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #engineTypeAsString}.
     * </p>
     * 
     * @return The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine, or
     *         <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
     * @see EngineType
     */
    public final String engineTypeAsString() {
        return engineType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(engineTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainInfo)) {
            return false;
        }
        DomainInfo other = (DomainInfo) obj;
        return Objects.equals(domainName(), other.domainName())
                && Objects.equals(engineTypeAsString(), other.engineTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainInfo").add("DomainName", domainName()).add("EngineType", engineTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "EngineType":
            return Optional.ofNullable(clazz.cast(engineTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DomainName", DOMAIN_NAME_FIELD);
        map.put("EngineType", ENGINE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DomainInfo, T> g) {
        return obj -> g.apply((DomainInfo) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainInfo> {
        /**
         * <p>
         * Name of the domain.
         * </p>
         * 
         * @param domainName
         *        Name of the domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine, or
         * <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
         * </p>
         * 
         * @param engineType
         *        The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine,
         *        or <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(String engineType);

        /**
         * <p>
         * The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine, or
         * <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
         * </p>
         * 
         * @param engineType
         *        The type of search engine that the domain is running.<code>OpenSearch</code> for an OpenSearch engine,
         *        or <code>Elasticsearch</code> for a legacy Elasticsearch OSS engine.
         * @see EngineType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EngineType
         */
        Builder engineType(EngineType engineType);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String engineType;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainInfo model) {
            domainName(model.domainName);
            engineType(model.engineType);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getEngineType() {
            return engineType;
        }

        public final void setEngineType(String engineType) {
            this.engineType = engineType;
        }

        @Override
        public final Builder engineType(String engineType) {
            this.engineType = engineType;
            return this;
        }

        @Override
        public final Builder engineType(EngineType engineType) {
            this.engineType(engineType == null ? null : engineType.toString());
            return this;
        }

        @Override
        public DomainInfo build() {
            return new DomainInfo(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
