/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The JWT authentication and authorization configuration for an Amazon OpenSearch Service domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JWTOptionsInput implements SdkPojo, Serializable, ToCopyableBuilder<JWTOptionsInput.Builder, JWTOptionsInput> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("Enabled").getter(getter(JWTOptionsInput::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> SUBJECT_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SubjectKey").getter(getter(JWTOptionsInput::subjectKey)).setter(setter(Builder::subjectKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubjectKey").build()).build();

    private static final SdkField<String> ROLES_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RolesKey").getter(getter(JWTOptionsInput::rolesKey)).setter(setter(Builder::rolesKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RolesKey").build()).build();

    private static final SdkField<String> PUBLIC_KEY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PublicKey").getter(getter(JWTOptionsInput::publicKey)).setter(setter(Builder::publicKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicKey").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            SUBJECT_KEY_FIELD, ROLES_KEY_FIELD, PUBLIC_KEY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String subjectKey;

    private final String rolesKey;

    private final String publicKey;

    private JWTOptionsInput(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.subjectKey = builder.subjectKey;
        this.rolesKey = builder.rolesKey;
        this.publicKey = builder.publicKey;
    }

    /**
     * <p>
     * True to enable JWT authentication and authorization for a domain.
     * </p>
     * 
     * @return True to enable JWT authentication and authorization for a domain.
     */
    public final Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Element of the JWT assertion to use for the user name.
     * </p>
     * 
     * @return Element of the JWT assertion to use for the user name.
     */
    public final String subjectKey() {
        return subjectKey;
    }

    /**
     * <p>
     * Element of the JWT assertion to use for roles.
     * </p>
     * 
     * @return Element of the JWT assertion to use for roles.
     */
    public final String rolesKey() {
        return rolesKey;
    }

    /**
     * <p>
     * Element of the JWT assertion used by the cluster to verify JWT signatures.
     * </p>
     * 
     * @return Element of the JWT assertion used by the cluster to verify JWT signatures.
     */
    public final String publicKey() {
        return publicKey;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(subjectKey());
        hashCode = 31 * hashCode + Objects.hashCode(rolesKey());
        hashCode = 31 * hashCode + Objects.hashCode(publicKey());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JWTOptionsInput)) {
            return false;
        }
        JWTOptionsInput other = (JWTOptionsInput) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(subjectKey(), other.subjectKey())
                && Objects.equals(rolesKey(), other.rolesKey()) && Objects.equals(publicKey(), other.publicKey());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JWTOptionsInput").add("Enabled", enabled()).add("SubjectKey", subjectKey())
                .add("RolesKey", rolesKey()).add("PublicKey", publicKey()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "SubjectKey":
            return Optional.ofNullable(clazz.cast(subjectKey()));
        case "RolesKey":
            return Optional.ofNullable(clazz.cast(rolesKey()));
        case "PublicKey":
            return Optional.ofNullable(clazz.cast(publicKey()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Enabled", ENABLED_FIELD);
        map.put("SubjectKey", SUBJECT_KEY_FIELD);
        map.put("RolesKey", ROLES_KEY_FIELD);
        map.put("PublicKey", PUBLIC_KEY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JWTOptionsInput, T> g) {
        return obj -> g.apply((JWTOptionsInput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JWTOptionsInput> {
        /**
         * <p>
         * True to enable JWT authentication and authorization for a domain.
         * </p>
         * 
         * @param enabled
         *        True to enable JWT authentication and authorization for a domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Element of the JWT assertion to use for the user name.
         * </p>
         * 
         * @param subjectKey
         *        Element of the JWT assertion to use for the user name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectKey(String subjectKey);

        /**
         * <p>
         * Element of the JWT assertion to use for roles.
         * </p>
         * 
         * @param rolesKey
         *        Element of the JWT assertion to use for roles.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rolesKey(String rolesKey);

        /**
         * <p>
         * Element of the JWT assertion used by the cluster to verify JWT signatures.
         * </p>
         * 
         * @param publicKey
         *        Element of the JWT assertion used by the cluster to verify JWT signatures.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicKey(String publicKey);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String subjectKey;

        private String rolesKey;

        private String publicKey;

        private BuilderImpl() {
        }

        private BuilderImpl(JWTOptionsInput model) {
            enabled(model.enabled);
            subjectKey(model.subjectKey);
            rolesKey(model.rolesKey);
            publicKey(model.publicKey);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final String getSubjectKey() {
            return subjectKey;
        }

        public final void setSubjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
        }

        @Override
        public final Builder subjectKey(String subjectKey) {
            this.subjectKey = subjectKey;
            return this;
        }

        public final String getRolesKey() {
            return rolesKey;
        }

        public final void setRolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
        }

        @Override
        public final Builder rolesKey(String rolesKey) {
            this.rolesKey = rolesKey;
            return this;
        }

        public final String getPublicKey() {
            return publicKey;
        }

        public final void setPublicKey(String publicKey) {
            this.publicKey = publicKey;
        }

        @Override
        public final Builder publicKey(String publicKey) {
            this.publicKey = publicKey;
            return this;
        }

        @Override
        public JWTOptionsInput build() {
            return new JWTOptionsInput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
