/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration parameters to enable access to the key store required by the package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KeyStoreAccessOption implements SdkPojo, Serializable,
        ToCopyableBuilder<KeyStoreAccessOption.Builder, KeyStoreAccessOption> {
    private static final SdkField<String> KEY_ACCESS_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KeyAccessRoleArn").getter(getter(KeyStoreAccessOption::keyAccessRoleArn))
            .setter(setter(Builder::keyAccessRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyAccessRoleArn").build()).build();

    private static final SdkField<Boolean> KEY_STORE_ACCESS_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("KeyStoreAccessEnabled").getter(getter(KeyStoreAccessOption::keyStoreAccessEnabled))
            .setter(setter(Builder::keyStoreAccessEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KeyStoreAccessEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEY_ACCESS_ROLE_ARN_FIELD,
            KEY_STORE_ACCESS_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String keyAccessRoleArn;

    private final Boolean keyStoreAccessEnabled;

    private KeyStoreAccessOption(BuilderImpl builder) {
        this.keyAccessRoleArn = builder.keyAccessRoleArn;
        this.keyStoreAccessEnabled = builder.keyStoreAccessEnabled;
    }

    /**
     * <p>
     * Role ARN to access the KeyStore Key
     * </p>
     * 
     * @return Role ARN to access the KeyStore Key
     */
    public final String keyAccessRoleArn() {
        return keyAccessRoleArn;
    }

    /**
     * <p>
     * This indicates whether Key Store access is enabled
     * </p>
     * 
     * @return This indicates whether Key Store access is enabled
     */
    public final Boolean keyStoreAccessEnabled() {
        return keyStoreAccessEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(keyAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(keyStoreAccessEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KeyStoreAccessOption)) {
            return false;
        }
        KeyStoreAccessOption other = (KeyStoreAccessOption) obj;
        return Objects.equals(keyAccessRoleArn(), other.keyAccessRoleArn())
                && Objects.equals(keyStoreAccessEnabled(), other.keyStoreAccessEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KeyStoreAccessOption").add("KeyAccessRoleArn", keyAccessRoleArn())
                .add("KeyStoreAccessEnabled", keyStoreAccessEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "KeyAccessRoleArn":
            return Optional.ofNullable(clazz.cast(keyAccessRoleArn()));
        case "KeyStoreAccessEnabled":
            return Optional.ofNullable(clazz.cast(keyStoreAccessEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("KeyAccessRoleArn", KEY_ACCESS_ROLE_ARN_FIELD);
        map.put("KeyStoreAccessEnabled", KEY_STORE_ACCESS_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KeyStoreAccessOption, T> g) {
        return obj -> g.apply((KeyStoreAccessOption) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KeyStoreAccessOption> {
        /**
         * <p>
         * Role ARN to access the KeyStore Key
         * </p>
         * 
         * @param keyAccessRoleArn
         *        Role ARN to access the KeyStore Key
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyAccessRoleArn(String keyAccessRoleArn);

        /**
         * <p>
         * This indicates whether Key Store access is enabled
         * </p>
         * 
         * @param keyStoreAccessEnabled
         *        This indicates whether Key Store access is enabled
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder keyStoreAccessEnabled(Boolean keyStoreAccessEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String keyAccessRoleArn;

        private Boolean keyStoreAccessEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(KeyStoreAccessOption model) {
            keyAccessRoleArn(model.keyAccessRoleArn);
            keyStoreAccessEnabled(model.keyStoreAccessEnabled);
        }

        public final String getKeyAccessRoleArn() {
            return keyAccessRoleArn;
        }

        public final void setKeyAccessRoleArn(String keyAccessRoleArn) {
            this.keyAccessRoleArn = keyAccessRoleArn;
        }

        @Override
        public final Builder keyAccessRoleArn(String keyAccessRoleArn) {
            this.keyAccessRoleArn = keyAccessRoleArn;
            return this;
        }

        public final Boolean getKeyStoreAccessEnabled() {
            return keyStoreAccessEnabled;
        }

        public final void setKeyStoreAccessEnabled(Boolean keyStoreAccessEnabled) {
            this.keyStoreAccessEnabled = keyStoreAccessEnabled;
        }

        @Override
        public final Builder keyStoreAccessEnabled(Boolean keyStoreAccessEnabled) {
            this.keyStoreAccessEnabled = keyStoreAccessEnabled;
            return this;
        }

        @Override
        public KeyStoreAccessOption build() {
            return new KeyStoreAccessOption(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
