/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListInstanceTypeDetailsResponse extends OpenSearchResponse implements
        ToCopyableBuilder<ListInstanceTypeDetailsResponse.Builder, ListInstanceTypeDetailsResponse> {
    private static final SdkField<List<InstanceTypeDetails>> INSTANCE_TYPE_DETAILS_FIELD = SdkField
            .<List<InstanceTypeDetails>> builder(MarshallingType.LIST)
            .memberName("InstanceTypeDetails")
            .getter(getter(ListInstanceTypeDetailsResponse::instanceTypeDetails))
            .setter(setter(Builder::instanceTypeDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceTypeDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InstanceTypeDetails> builder(MarshallingType.SDK_POJO)
                                            .constructor(InstanceTypeDetails::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListInstanceTypeDetailsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_DETAILS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<InstanceTypeDetails> instanceTypeDetails;

    private final String nextToken;

    private ListInstanceTypeDetailsResponse(BuilderImpl builder) {
        super(builder);
        this.instanceTypeDetails = builder.instanceTypeDetails;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the InstanceTypeDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInstanceTypeDetails() {
        return instanceTypeDetails != null && !(instanceTypeDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInstanceTypeDetails} method.
     * </p>
     * 
     * @return Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.
     */
    public final List<InstanceTypeDetails> instanceTypeDetails() {
        return instanceTypeDetails;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Send the request again using the returned token to retrieve the next
     * page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Send the request again using the
     *         returned token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasInstanceTypeDetails() ? instanceTypeDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInstanceTypeDetailsResponse)) {
            return false;
        }
        ListInstanceTypeDetailsResponse other = (ListInstanceTypeDetailsResponse) obj;
        return hasInstanceTypeDetails() == other.hasInstanceTypeDetails()
                && Objects.equals(instanceTypeDetails(), other.instanceTypeDetails())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListInstanceTypeDetailsResponse")
                .add("InstanceTypeDetails", hasInstanceTypeDetails() ? instanceTypeDetails() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceTypeDetails":
            return Optional.ofNullable(clazz.cast(instanceTypeDetails()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("InstanceTypeDetails", INSTANCE_TYPE_DETAILS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInstanceTypeDetailsResponse, T> g) {
        return obj -> g.apply((ListInstanceTypeDetailsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListInstanceTypeDetailsResponse> {
        /**
         * <p>
         * Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.
         * </p>
         * 
         * @param instanceTypeDetails
         *        Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeDetails(Collection<InstanceTypeDetails> instanceTypeDetails);

        /**
         * <p>
         * Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.
         * </p>
         * 
         * @param instanceTypeDetails
         *        Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceTypeDetails(InstanceTypeDetails... instanceTypeDetails);

        /**
         * <p>
         * Lists all supported instance types and features for the given OpenSearch or Elasticsearch version.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceTypeDetails(List<InstanceTypeDetails>)}.
         * 
         * @param instanceTypeDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearch.model.InstanceTypeDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceTypeDetails(java.util.Collection<InstanceTypeDetails>)
         */
        Builder instanceTypeDetails(Consumer<InstanceTypeDetails.Builder>... instanceTypeDetails);

        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Send the request again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Send the request again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private List<InstanceTypeDetails> instanceTypeDetails = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInstanceTypeDetailsResponse model) {
            super(model);
            instanceTypeDetails(model.instanceTypeDetails);
            nextToken(model.nextToken);
        }

        public final List<InstanceTypeDetails.Builder> getInstanceTypeDetails() {
            List<InstanceTypeDetails.Builder> result = InstanceTypeDetailsListCopier.copyToBuilder(this.instanceTypeDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInstanceTypeDetails(Collection<InstanceTypeDetails.BuilderImpl> instanceTypeDetails) {
            this.instanceTypeDetails = InstanceTypeDetailsListCopier.copyFromBuilder(instanceTypeDetails);
        }

        @Override
        public final Builder instanceTypeDetails(Collection<InstanceTypeDetails> instanceTypeDetails) {
            this.instanceTypeDetails = InstanceTypeDetailsListCopier.copy(instanceTypeDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeDetails(InstanceTypeDetails... instanceTypeDetails) {
            instanceTypeDetails(Arrays.asList(instanceTypeDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypeDetails(Consumer<InstanceTypeDetails.Builder>... instanceTypeDetails) {
            instanceTypeDetails(Stream.of(instanceTypeDetails).map(c -> InstanceTypeDetails.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInstanceTypeDetailsResponse build() {
            return new ListInstanceTypeDetailsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
