/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for parameters representing the state of the natural language query generation feature on the specified
 * domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NaturalLanguageQueryGenerationOptionsOutput implements SdkPojo, Serializable,
        ToCopyableBuilder<NaturalLanguageQueryGenerationOptionsOutput.Builder, NaturalLanguageQueryGenerationOptionsOutput> {
    private static final SdkField<String> DESIRED_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DesiredState").getter(getter(NaturalLanguageQueryGenerationOptionsOutput::desiredStateAsString))
            .setter(setter(Builder::desiredState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredState").build()).build();

    private static final SdkField<String> CURRENT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("CurrentState").getter(getter(NaturalLanguageQueryGenerationOptionsOutput::currentStateAsString))
            .setter(setter(Builder::currentState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CurrentState").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_STATE_FIELD,
            CURRENT_STATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String desiredState;

    private final String currentState;

    private NaturalLanguageQueryGenerationOptionsOutput(BuilderImpl builder) {
        this.desiredState = builder.desiredState;
        this.currentState = builder.currentState;
    }

    /**
     * <p>
     * The desired state of the natural language query generation feature. Valid values are ENABLED and DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link NaturalLanguageQueryGenerationDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The desired state of the natural language query generation feature. Valid values are ENABLED and
     *         DISABLED.
     * @see NaturalLanguageQueryGenerationDesiredState
     */
    public final NaturalLanguageQueryGenerationDesiredState desiredState() {
        return NaturalLanguageQueryGenerationDesiredState.fromValue(desiredState);
    }

    /**
     * <p>
     * The desired state of the natural language query generation feature. Valid values are ENABLED and DISABLED.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #desiredState} will
     * return {@link NaturalLanguageQueryGenerationDesiredState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #desiredStateAsString}.
     * </p>
     * 
     * @return The desired state of the natural language query generation feature. Valid values are ENABLED and
     *         DISABLED.
     * @see NaturalLanguageQueryGenerationDesiredState
     */
    public final String desiredStateAsString() {
        return desiredState;
    }

    /**
     * <p>
     * The current state of the natural language query generation feature, indicating completion, in progress, or
     * failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link NaturalLanguageQueryGenerationCurrentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #currentStateAsString}.
     * </p>
     * 
     * @return The current state of the natural language query generation feature, indicating completion, in progress,
     *         or failure.
     * @see NaturalLanguageQueryGenerationCurrentState
     */
    public final NaturalLanguageQueryGenerationCurrentState currentState() {
        return NaturalLanguageQueryGenerationCurrentState.fromValue(currentState);
    }

    /**
     * <p>
     * The current state of the natural language query generation feature, indicating completion, in progress, or
     * failure.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #currentState} will
     * return {@link NaturalLanguageQueryGenerationCurrentState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #currentStateAsString}.
     * </p>
     * 
     * @return The current state of the natural language query generation feature, indicating completion, in progress,
     *         or failure.
     * @see NaturalLanguageQueryGenerationCurrentState
     */
    public final String currentStateAsString() {
        return currentState;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(currentStateAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NaturalLanguageQueryGenerationOptionsOutput)) {
            return false;
        }
        NaturalLanguageQueryGenerationOptionsOutput other = (NaturalLanguageQueryGenerationOptionsOutput) obj;
        return Objects.equals(desiredStateAsString(), other.desiredStateAsString())
                && Objects.equals(currentStateAsString(), other.currentStateAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NaturalLanguageQueryGenerationOptionsOutput").add("DesiredState", desiredStateAsString())
                .add("CurrentState", currentStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredState":
            return Optional.ofNullable(clazz.cast(desiredStateAsString()));
        case "CurrentState":
            return Optional.ofNullable(clazz.cast(currentStateAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DesiredState", DESIRED_STATE_FIELD);
        map.put("CurrentState", CURRENT_STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<NaturalLanguageQueryGenerationOptionsOutput, T> g) {
        return obj -> g.apply((NaturalLanguageQueryGenerationOptionsOutput) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NaturalLanguageQueryGenerationOptionsOutput> {
        /**
         * <p>
         * The desired state of the natural language query generation feature. Valid values are ENABLED and DISABLED.
         * </p>
         * 
         * @param desiredState
         *        The desired state of the natural language query generation feature. Valid values are ENABLED and
         *        DISABLED.
         * @see NaturalLanguageQueryGenerationDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NaturalLanguageQueryGenerationDesiredState
         */
        Builder desiredState(String desiredState);

        /**
         * <p>
         * The desired state of the natural language query generation feature. Valid values are ENABLED and DISABLED.
         * </p>
         * 
         * @param desiredState
         *        The desired state of the natural language query generation feature. Valid values are ENABLED and
         *        DISABLED.
         * @see NaturalLanguageQueryGenerationDesiredState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NaturalLanguageQueryGenerationDesiredState
         */
        Builder desiredState(NaturalLanguageQueryGenerationDesiredState desiredState);

        /**
         * <p>
         * The current state of the natural language query generation feature, indicating completion, in progress, or
         * failure.
         * </p>
         * 
         * @param currentState
         *        The current state of the natural language query generation feature, indicating completion, in
         *        progress, or failure.
         * @see NaturalLanguageQueryGenerationCurrentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NaturalLanguageQueryGenerationCurrentState
         */
        Builder currentState(String currentState);

        /**
         * <p>
         * The current state of the natural language query generation feature, indicating completion, in progress, or
         * failure.
         * </p>
         * 
         * @param currentState
         *        The current state of the natural language query generation feature, indicating completion, in
         *        progress, or failure.
         * @see NaturalLanguageQueryGenerationCurrentState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see NaturalLanguageQueryGenerationCurrentState
         */
        Builder currentState(NaturalLanguageQueryGenerationCurrentState currentState);
    }

    static final class BuilderImpl implements Builder {
        private String desiredState;

        private String currentState;

        private BuilderImpl() {
        }

        private BuilderImpl(NaturalLanguageQueryGenerationOptionsOutput model) {
            desiredState(model.desiredState);
            currentState(model.currentState);
        }

        public final String getDesiredState() {
            return desiredState;
        }

        public final void setDesiredState(String desiredState) {
            this.desiredState = desiredState;
        }

        @Override
        public final Builder desiredState(String desiredState) {
            this.desiredState = desiredState;
            return this;
        }

        @Override
        public final Builder desiredState(NaturalLanguageQueryGenerationDesiredState desiredState) {
            this.desiredState(desiredState == null ? null : desiredState.toString());
            return this;
        }

        public final String getCurrentState() {
            return currentState;
        }

        public final void setCurrentState(String currentState) {
            this.currentState = currentState;
        }

        @Override
        public final Builder currentState(String currentState) {
            this.currentState = currentState;
            return this;
        }

        @Override
        public final Builder currentState(NaturalLanguageQueryGenerationCurrentState currentState) {
            this.currentState(currentState == null ? null : currentState.toString());
            return this;
        }

        @Override
        public NaturalLanguageQueryGenerationOptionsOutput build() {
            return new NaturalLanguageQueryGenerationOptionsOutput(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
