/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Basic information about a package.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageDetails implements SdkPojo, Serializable, ToCopyableBuilder<PackageDetails.Builder, PackageDetails> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(PackageDetails::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()).build();

    private static final SdkField<String> PACKAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageName").getter(getter(PackageDetails::packageName)).setter(setter(Builder::packageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageName").build()).build();

    private static final SdkField<String> PACKAGE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageType").getter(getter(PackageDetails::packageTypeAsString)).setter(setter(Builder::packageType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageType").build()).build();

    private static final SdkField<String> PACKAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageDescription").getter(getter(PackageDetails::packageDescription))
            .setter(setter(Builder::packageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageDescription").build())
            .build();

    private static final SdkField<String> PACKAGE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageStatus").getter(getter(PackageDetails::packageStatusAsString))
            .setter(setter(Builder::packageStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageStatus").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedAt").getter(getter(PackageDetails::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedAt").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedAt").getter(getter(PackageDetails::lastUpdatedAt)).setter(setter(Builder::lastUpdatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedAt").build()).build();

    private static final SdkField<String> AVAILABLE_PACKAGE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailablePackageVersion").getter(getter(PackageDetails::availablePackageVersion))
            .setter(setter(Builder::availablePackageVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePackageVersion").build())
            .build();

    private static final SdkField<ErrorDetails> ERROR_DETAILS_FIELD = SdkField.<ErrorDetails> builder(MarshallingType.SDK_POJO)
            .memberName("ErrorDetails").getter(getter(PackageDetails::errorDetails)).setter(setter(Builder::errorDetails))
            .constructor(ErrorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ErrorDetails").build()).build();

    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EngineVersion").getter(getter(PackageDetails::engineVersion)).setter(setter(Builder::engineVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()).build();

    private static final SdkField<PluginProperties> AVAILABLE_PLUGIN_PROPERTIES_FIELD = SdkField
            .<PluginProperties> builder(MarshallingType.SDK_POJO).memberName("AvailablePluginProperties")
            .getter(getter(PackageDetails::availablePluginProperties)).setter(setter(Builder::availablePluginProperties))
            .constructor(PluginProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePluginProperties").build())
            .build();

    private static final SdkField<PackageConfiguration> AVAILABLE_PACKAGE_CONFIGURATION_FIELD = SdkField
            .<PackageConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("AvailablePackageConfiguration")
            .getter(getter(PackageDetails::availablePackageConfiguration))
            .setter(setter(Builder::availablePackageConfiguration))
            .constructor(PackageConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailablePackageConfiguration")
                    .build()).build();

    private static final SdkField<List<String>> ALLOW_LISTED_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowListedUserList")
            .getter(getter(PackageDetails::allowListedUserList))
            .setter(setter(Builder::allowListedUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowListedUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PACKAGE_OWNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageOwner").getter(getter(PackageDetails::packageOwner)).setter(setter(Builder::packageOwner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageOwner").build()).build();

    private static final SdkField<PackageVendingOptions> PACKAGE_VENDING_OPTIONS_FIELD = SdkField
            .<PackageVendingOptions> builder(MarshallingType.SDK_POJO).memberName("PackageVendingOptions")
            .getter(getter(PackageDetails::packageVendingOptions)).setter(setter(Builder::packageVendingOptions))
            .constructor(PackageVendingOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageVendingOptions").build())
            .build();

    private static final SdkField<PackageEncryptionOptions> PACKAGE_ENCRYPTION_OPTIONS_FIELD = SdkField
            .<PackageEncryptionOptions> builder(MarshallingType.SDK_POJO).memberName("PackageEncryptionOptions")
            .getter(getter(PackageDetails::packageEncryptionOptions)).setter(setter(Builder::packageEncryptionOptions))
            .constructor(PackageEncryptionOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageEncryptionOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            PACKAGE_NAME_FIELD, PACKAGE_TYPE_FIELD, PACKAGE_DESCRIPTION_FIELD, PACKAGE_STATUS_FIELD, CREATED_AT_FIELD,
            LAST_UPDATED_AT_FIELD, AVAILABLE_PACKAGE_VERSION_FIELD, ERROR_DETAILS_FIELD, ENGINE_VERSION_FIELD,
            AVAILABLE_PLUGIN_PROPERTIES_FIELD, AVAILABLE_PACKAGE_CONFIGURATION_FIELD, ALLOW_LISTED_USER_LIST_FIELD,
            PACKAGE_OWNER_FIELD, PACKAGE_VENDING_OPTIONS_FIELD, PACKAGE_ENCRYPTION_OPTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String packageID;

    private final String packageName;

    private final String packageType;

    private final String packageDescription;

    private final String packageStatus;

    private final Instant createdAt;

    private final Instant lastUpdatedAt;

    private final String availablePackageVersion;

    private final ErrorDetails errorDetails;

    private final String engineVersion;

    private final PluginProperties availablePluginProperties;

    private final PackageConfiguration availablePackageConfiguration;

    private final List<String> allowListedUserList;

    private final String packageOwner;

    private final PackageVendingOptions packageVendingOptions;

    private final PackageEncryptionOptions packageEncryptionOptions;

    private PackageDetails(BuilderImpl builder) {
        this.packageID = builder.packageID;
        this.packageName = builder.packageName;
        this.packageType = builder.packageType;
        this.packageDescription = builder.packageDescription;
        this.packageStatus = builder.packageStatus;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.availablePackageVersion = builder.availablePackageVersion;
        this.errorDetails = builder.errorDetails;
        this.engineVersion = builder.engineVersion;
        this.availablePluginProperties = builder.availablePluginProperties;
        this.availablePackageConfiguration = builder.availablePackageConfiguration;
        this.allowListedUserList = builder.allowListedUserList;
        this.packageOwner = builder.packageOwner;
        this.packageVendingOptions = builder.packageVendingOptions;
        this.packageEncryptionOptions = builder.packageEncryptionOptions;
    }

    /**
     * <p>
     * The unique identifier of the package.
     * </p>
     * 
     * @return The unique identifier of the package.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * <p>
     * The user-specified name of the package.
     * </p>
     * 
     * @return The user-specified name of the package.
     */
    public final String packageName() {
        return packageName;
    }

    /**
     * <p>
     * The type of package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of package.
     * @see PackageType
     */
    public final PackageType packageType() {
        return PackageType.fromValue(packageType);
    }

    /**
     * <p>
     * The type of package.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageType} will
     * return {@link PackageType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageTypeAsString}.
     * </p>
     * 
     * @return The type of package.
     * @see PackageType
     */
    public final String packageTypeAsString() {
        return packageType;
    }

    /**
     * <p>
     * User-specified description of the package.
     * </p>
     * 
     * @return User-specified description of the package.
     */
    public final String packageDescription() {
        return packageDescription;
    }

    /**
     * <p>
     * The current status of the package. The available options are <code>AVAILABLE</code>, <code>COPYING</code>,
     * <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>, <code>DELETING</code>, and
     * <code>DELETE_FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageStatus}
     * will return {@link PackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageStatusAsString}.
     * </p>
     * 
     * @return The current status of the package. The available options are <code>AVAILABLE</code>, <code>COPYING</code>
     *         , <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>, <code>DELETING</code>
     *         , and <code>DELETE_FAILED</code>.
     * @see PackageStatus
     */
    public final PackageStatus packageStatus() {
        return PackageStatus.fromValue(packageStatus);
    }

    /**
     * <p>
     * The current status of the package. The available options are <code>AVAILABLE</code>, <code>COPYING</code>,
     * <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>, <code>DELETING</code>, and
     * <code>DELETE_FAILED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #packageStatus}
     * will return {@link PackageStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #packageStatusAsString}.
     * </p>
     * 
     * @return The current status of the package. The available options are <code>AVAILABLE</code>, <code>COPYING</code>
     *         , <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>, <code>DELETING</code>
     *         , and <code>DELETE_FAILED</code>.
     * @see PackageStatus
     */
    public final String packageStatusAsString() {
        return packageStatus;
    }

    /**
     * <p>
     * The timestamp when the package was created.
     * </p>
     * 
     * @return The timestamp when the package was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * Date and time when the package was last updated.
     * </p>
     * 
     * @return Date and time when the package was last updated.
     */
    public final Instant lastUpdatedAt() {
        return lastUpdatedAt;
    }

    /**
     * <p>
     * The package version.
     * </p>
     * 
     * @return The package version.
     */
    public final String availablePackageVersion() {
        return availablePackageVersion;
    }

    /**
     * <p>
     * Additional information if the package is in an error state. Null otherwise.
     * </p>
     * 
     * @return Additional information if the package is in an error state. Null otherwise.
     */
    public final ErrorDetails errorDetails() {
        return errorDetails;
    }

    /**
     * <p>
     * Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the latest
     * version of OpenSearch.
     * </p>
     * 
     * @return Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to
     *         the latest version of OpenSearch.
     */
    public final String engineVersion() {
        return engineVersion;
    }

    /**
     * <p>
     * If the package is a <code>ZIP-PLUGIN</code> package, additional information about plugin properties.
     * </p>
     * 
     * @return If the package is a <code>ZIP-PLUGIN</code> package, additional information about plugin properties.
     */
    public final PluginProperties availablePluginProperties() {
        return availablePluginProperties;
    }

    /**
     * <p>
     * This represents the available configuration parameters for the package.
     * </p>
     * 
     * @return This represents the available configuration parameters for the package.
     */
    public final PackageConfiguration availablePackageConfiguration() {
        return availablePackageConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowListedUserList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowListedUserList() {
        return allowListedUserList != null && !(allowListedUserList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of users who are allowed to view and associate the package. This field is only visible to the owner of a
     * package.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowListedUserList} method.
     * </p>
     * 
     * @return A list of users who are allowed to view and associate the package. This field is only visible to the
     *         owner of a package.
     */
    public final List<String> allowListedUserList() {
        return allowListedUserList;
    }

    /**
     * <p>
     * The owner of the package who is allowed to create and update a package and add users to the package scope.
     * </p>
     * 
     * @return The owner of the package who is allowed to create and update a package and add users to the package
     *         scope.
     */
    public final String packageOwner() {
        return packageOwner;
    }

    /**
     * <p>
     * Package Vending Options for a package.
     * </p>
     * 
     * @return Package Vending Options for a package.
     */
    public final PackageVendingOptions packageVendingOptions() {
        return packageVendingOptions;
    }

    /**
     * <p>
     * Encryption options for a package.
     * </p>
     * 
     * @return Encryption options for a package.
     */
    public final PackageEncryptionOptions packageEncryptionOptions() {
        return packageEncryptionOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(packageName());
        hashCode = 31 * hashCode + Objects.hashCode(packageTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(packageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(packageStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(availablePackageVersion());
        hashCode = 31 * hashCode + Objects.hashCode(errorDetails());
        hashCode = 31 * hashCode + Objects.hashCode(engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(availablePluginProperties());
        hashCode = 31 * hashCode + Objects.hashCode(availablePackageConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowListedUserList() ? allowListedUserList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(packageOwner());
        hashCode = 31 * hashCode + Objects.hashCode(packageVendingOptions());
        hashCode = 31 * hashCode + Objects.hashCode(packageEncryptionOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageDetails)) {
            return false;
        }
        PackageDetails other = (PackageDetails) obj;
        return Objects.equals(packageID(), other.packageID()) && Objects.equals(packageName(), other.packageName())
                && Objects.equals(packageTypeAsString(), other.packageTypeAsString())
                && Objects.equals(packageDescription(), other.packageDescription())
                && Objects.equals(packageStatusAsString(), other.packageStatusAsString())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(lastUpdatedAt(), other.lastUpdatedAt())
                && Objects.equals(availablePackageVersion(), other.availablePackageVersion())
                && Objects.equals(errorDetails(), other.errorDetails()) && Objects.equals(engineVersion(), other.engineVersion())
                && Objects.equals(availablePluginProperties(), other.availablePluginProperties())
                && Objects.equals(availablePackageConfiguration(), other.availablePackageConfiguration())
                && hasAllowListedUserList() == other.hasAllowListedUserList()
                && Objects.equals(allowListedUserList(), other.allowListedUserList())
                && Objects.equals(packageOwner(), other.packageOwner())
                && Objects.equals(packageVendingOptions(), other.packageVendingOptions())
                && Objects.equals(packageEncryptionOptions(), other.packageEncryptionOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageDetails").add("PackageID", packageID()).add("PackageName", packageName())
                .add("PackageType", packageTypeAsString()).add("PackageDescription", packageDescription())
                .add("PackageStatus", packageStatusAsString()).add("CreatedAt", createdAt())
                .add("LastUpdatedAt", lastUpdatedAt()).add("AvailablePackageVersion", availablePackageVersion())
                .add("ErrorDetails", errorDetails()).add("EngineVersion", engineVersion())
                .add("AvailablePluginProperties", availablePluginProperties())
                .add("AvailablePackageConfiguration", availablePackageConfiguration())
                .add("AllowListedUserList", hasAllowListedUserList() ? allowListedUserList() : null)
                .add("PackageOwner", packageOwner()).add("PackageVendingOptions", packageVendingOptions())
                .add("PackageEncryptionOptions", packageEncryptionOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "PackageName":
            return Optional.ofNullable(clazz.cast(packageName()));
        case "PackageType":
            return Optional.ofNullable(clazz.cast(packageTypeAsString()));
        case "PackageDescription":
            return Optional.ofNullable(clazz.cast(packageDescription()));
        case "PackageStatus":
            return Optional.ofNullable(clazz.cast(packageStatusAsString()));
        case "CreatedAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "LastUpdatedAt":
            return Optional.ofNullable(clazz.cast(lastUpdatedAt()));
        case "AvailablePackageVersion":
            return Optional.ofNullable(clazz.cast(availablePackageVersion()));
        case "ErrorDetails":
            return Optional.ofNullable(clazz.cast(errorDetails()));
        case "EngineVersion":
            return Optional.ofNullable(clazz.cast(engineVersion()));
        case "AvailablePluginProperties":
            return Optional.ofNullable(clazz.cast(availablePluginProperties()));
        case "AvailablePackageConfiguration":
            return Optional.ofNullable(clazz.cast(availablePackageConfiguration()));
        case "AllowListedUserList":
            return Optional.ofNullable(clazz.cast(allowListedUserList()));
        case "PackageOwner":
            return Optional.ofNullable(clazz.cast(packageOwner()));
        case "PackageVendingOptions":
            return Optional.ofNullable(clazz.cast(packageVendingOptions()));
        case "PackageEncryptionOptions":
            return Optional.ofNullable(clazz.cast(packageEncryptionOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageID", PACKAGE_ID_FIELD);
        map.put("PackageName", PACKAGE_NAME_FIELD);
        map.put("PackageType", PACKAGE_TYPE_FIELD);
        map.put("PackageDescription", PACKAGE_DESCRIPTION_FIELD);
        map.put("PackageStatus", PACKAGE_STATUS_FIELD);
        map.put("CreatedAt", CREATED_AT_FIELD);
        map.put("LastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("AvailablePackageVersion", AVAILABLE_PACKAGE_VERSION_FIELD);
        map.put("ErrorDetails", ERROR_DETAILS_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("AvailablePluginProperties", AVAILABLE_PLUGIN_PROPERTIES_FIELD);
        map.put("AvailablePackageConfiguration", AVAILABLE_PACKAGE_CONFIGURATION_FIELD);
        map.put("AllowListedUserList", ALLOW_LISTED_USER_LIST_FIELD);
        map.put("PackageOwner", PACKAGE_OWNER_FIELD);
        map.put("PackageVendingOptions", PACKAGE_VENDING_OPTIONS_FIELD);
        map.put("PackageEncryptionOptions", PACKAGE_ENCRYPTION_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageDetails, T> g) {
        return obj -> g.apply((PackageDetails) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageDetails> {
        /**
         * <p>
         * The unique identifier of the package.
         * </p>
         * 
         * @param packageID
         *        The unique identifier of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * <p>
         * The user-specified name of the package.
         * </p>
         * 
         * @param packageName
         *        The user-specified name of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageName(String packageName);

        /**
         * <p>
         * The type of package.
         * </p>
         * 
         * @param packageType
         *        The type of package.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(String packageType);

        /**
         * <p>
         * The type of package.
         * </p>
         * 
         * @param packageType
         *        The type of package.
         * @see PackageType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageType
         */
        Builder packageType(PackageType packageType);

        /**
         * <p>
         * User-specified description of the package.
         * </p>
         * 
         * @param packageDescription
         *        User-specified description of the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageDescription(String packageDescription);

        /**
         * <p>
         * The current status of the package. The available options are <code>AVAILABLE</code>, <code>COPYING</code>,
         * <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>, <code>DELETING</code>, and
         * <code>DELETE_FAILED</code>.
         * </p>
         * 
         * @param packageStatus
         *        The current status of the package. The available options are <code>AVAILABLE</code>,
         *        <code>COPYING</code>, <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>
         *        , <code>DELETING</code>, and <code>DELETE_FAILED</code>.
         * @see PackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageStatus
         */
        Builder packageStatus(String packageStatus);

        /**
         * <p>
         * The current status of the package. The available options are <code>AVAILABLE</code>, <code>COPYING</code>,
         * <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>, <code>DELETING</code>, and
         * <code>DELETE_FAILED</code>.
         * </p>
         * 
         * @param packageStatus
         *        The current status of the package. The available options are <code>AVAILABLE</code>,
         *        <code>COPYING</code>, <code>COPY_FAILED</code>, <code>VALIDATNG</code>, <code>VALIDATION_FAILED</code>
         *        , <code>DELETING</code>, and <code>DELETE_FAILED</code>.
         * @see PackageStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageStatus
         */
        Builder packageStatus(PackageStatus packageStatus);

        /**
         * <p>
         * The timestamp when the package was created.
         * </p>
         * 
         * @param createdAt
         *        The timestamp when the package was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * Date and time when the package was last updated.
         * </p>
         * 
         * @param lastUpdatedAt
         *        Date and time when the package was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedAt(Instant lastUpdatedAt);

        /**
         * <p>
         * The package version.
         * </p>
         * 
         * @param availablePackageVersion
         *        The package version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePackageVersion(String availablePackageVersion);

        /**
         * <p>
         * Additional information if the package is in an error state. Null otherwise.
         * </p>
         * 
         * @param errorDetails
         *        Additional information if the package is in an error state. Null otherwise.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorDetails(ErrorDetails errorDetails);

        /**
         * <p>
         * Additional information if the package is in an error state. Null otherwise.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetails.Builder} avoiding the need
         * to create one manually via {@link ErrorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #errorDetails(ErrorDetails)}.
         * 
         * @param errorDetails
         *        a consumer that will call methods on {@link ErrorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errorDetails(ErrorDetails)
         */
        default Builder errorDetails(Consumer<ErrorDetails.Builder> errorDetails) {
            return errorDetails(ErrorDetails.builder().applyMutation(errorDetails).build());
        }

        /**
         * <p>
         * Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to the
         * latest version of OpenSearch.
         * </p>
         * 
         * @param engineVersion
         *        Version of OpenSearch or Elasticsearch, in the format Elasticsearch_X.Y or OpenSearch_X.Y. Defaults to
         *        the latest version of OpenSearch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder engineVersion(String engineVersion);

        /**
         * <p>
         * If the package is a <code>ZIP-PLUGIN</code> package, additional information about plugin properties.
         * </p>
         * 
         * @param availablePluginProperties
         *        If the package is a <code>ZIP-PLUGIN</code> package, additional information about plugin properties.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePluginProperties(PluginProperties availablePluginProperties);

        /**
         * <p>
         * If the package is a <code>ZIP-PLUGIN</code> package, additional information about plugin properties.
         * </p>
         * This is a convenience method that creates an instance of the {@link PluginProperties.Builder} avoiding the
         * need to create one manually via {@link PluginProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PluginProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #availablePluginProperties(PluginProperties)}.
         * 
         * @param availablePluginProperties
         *        a consumer that will call methods on {@link PluginProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availablePluginProperties(PluginProperties)
         */
        default Builder availablePluginProperties(Consumer<PluginProperties.Builder> availablePluginProperties) {
            return availablePluginProperties(PluginProperties.builder().applyMutation(availablePluginProperties).build());
        }

        /**
         * <p>
         * This represents the available configuration parameters for the package.
         * </p>
         * 
         * @param availablePackageConfiguration
         *        This represents the available configuration parameters for the package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availablePackageConfiguration(PackageConfiguration availablePackageConfiguration);

        /**
         * <p>
         * This represents the available configuration parameters for the package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageConfiguration.Builder} avoiding
         * the need to create one manually via {@link PackageConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageConfiguration.Builder#build()} is called immediately and
         * its result is passed to {@link #availablePackageConfiguration(PackageConfiguration)}.
         * 
         * @param availablePackageConfiguration
         *        a consumer that will call methods on {@link PackageConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #availablePackageConfiguration(PackageConfiguration)
         */
        default Builder availablePackageConfiguration(Consumer<PackageConfiguration.Builder> availablePackageConfiguration) {
            return availablePackageConfiguration(PackageConfiguration.builder().applyMutation(availablePackageConfiguration)
                    .build());
        }

        /**
         * <p>
         * A list of users who are allowed to view and associate the package. This field is only visible to the owner of
         * a package.
         * </p>
         * 
         * @param allowListedUserList
         *        A list of users who are allowed to view and associate the package. This field is only visible to the
         *        owner of a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowListedUserList(Collection<String> allowListedUserList);

        /**
         * <p>
         * A list of users who are allowed to view and associate the package. This field is only visible to the owner of
         * a package.
         * </p>
         * 
         * @param allowListedUserList
         *        A list of users who are allowed to view and associate the package. This field is only visible to the
         *        owner of a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowListedUserList(String... allowListedUserList);

        /**
         * <p>
         * The owner of the package who is allowed to create and update a package and add users to the package scope.
         * </p>
         * 
         * @param packageOwner
         *        The owner of the package who is allowed to create and update a package and add users to the package
         *        scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageOwner(String packageOwner);

        /**
         * <p>
         * Package Vending Options for a package.
         * </p>
         * 
         * @param packageVendingOptions
         *        Package Vending Options for a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageVendingOptions(PackageVendingOptions packageVendingOptions);

        /**
         * <p>
         * Package Vending Options for a package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageVendingOptions.Builder} avoiding
         * the need to create one manually via {@link PackageVendingOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageVendingOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #packageVendingOptions(PackageVendingOptions)}.
         * 
         * @param packageVendingOptions
         *        a consumer that will call methods on {@link PackageVendingOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageVendingOptions(PackageVendingOptions)
         */
        default Builder packageVendingOptions(Consumer<PackageVendingOptions.Builder> packageVendingOptions) {
            return packageVendingOptions(PackageVendingOptions.builder().applyMutation(packageVendingOptions).build());
        }

        /**
         * <p>
         * Encryption options for a package.
         * </p>
         * 
         * @param packageEncryptionOptions
         *        Encryption options for a package.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions);

        /**
         * <p>
         * Encryption options for a package.
         * </p>
         * This is a convenience method that creates an instance of the {@link PackageEncryptionOptions.Builder}
         * avoiding the need to create one manually via {@link PackageEncryptionOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PackageEncryptionOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #packageEncryptionOptions(PackageEncryptionOptions)}.
         * 
         * @param packageEncryptionOptions
         *        a consumer that will call methods on {@link PackageEncryptionOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #packageEncryptionOptions(PackageEncryptionOptions)
         */
        default Builder packageEncryptionOptions(Consumer<PackageEncryptionOptions.Builder> packageEncryptionOptions) {
            return packageEncryptionOptions(PackageEncryptionOptions.builder().applyMutation(packageEncryptionOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String packageID;

        private String packageName;

        private String packageType;

        private String packageDescription;

        private String packageStatus;

        private Instant createdAt;

        private Instant lastUpdatedAt;

        private String availablePackageVersion;

        private ErrorDetails errorDetails;

        private String engineVersion;

        private PluginProperties availablePluginProperties;

        private PackageConfiguration availablePackageConfiguration;

        private List<String> allowListedUserList = DefaultSdkAutoConstructList.getInstance();

        private String packageOwner;

        private PackageVendingOptions packageVendingOptions;

        private PackageEncryptionOptions packageEncryptionOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageDetails model) {
            packageID(model.packageID);
            packageName(model.packageName);
            packageType(model.packageType);
            packageDescription(model.packageDescription);
            packageStatus(model.packageStatus);
            createdAt(model.createdAt);
            lastUpdatedAt(model.lastUpdatedAt);
            availablePackageVersion(model.availablePackageVersion);
            errorDetails(model.errorDetails);
            engineVersion(model.engineVersion);
            availablePluginProperties(model.availablePluginProperties);
            availablePackageConfiguration(model.availablePackageConfiguration);
            allowListedUserList(model.allowListedUserList);
            packageOwner(model.packageOwner);
            packageVendingOptions(model.packageVendingOptions);
            packageEncryptionOptions(model.packageEncryptionOptions);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getPackageName() {
            return packageName;
        }

        public final void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public final Builder packageName(String packageName) {
            this.packageName = packageName;
            return this;
        }

        public final String getPackageType() {
            return packageType;
        }

        public final void setPackageType(String packageType) {
            this.packageType = packageType;
        }

        @Override
        public final Builder packageType(String packageType) {
            this.packageType = packageType;
            return this;
        }

        @Override
        public final Builder packageType(PackageType packageType) {
            this.packageType(packageType == null ? null : packageType.toString());
            return this;
        }

        public final String getPackageDescription() {
            return packageDescription;
        }

        public final void setPackageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
        }

        @Override
        public final Builder packageDescription(String packageDescription) {
            this.packageDescription = packageDescription;
            return this;
        }

        public final String getPackageStatus() {
            return packageStatus;
        }

        public final void setPackageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
        }

        @Override
        public final Builder packageStatus(String packageStatus) {
            this.packageStatus = packageStatus;
            return this;
        }

        @Override
        public final Builder packageStatus(PackageStatus packageStatus) {
            this.packageStatus(packageStatus == null ? null : packageStatus.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getAvailablePackageVersion() {
            return availablePackageVersion;
        }

        public final void setAvailablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
        }

        @Override
        public final Builder availablePackageVersion(String availablePackageVersion) {
            this.availablePackageVersion = availablePackageVersion;
            return this;
        }

        public final ErrorDetails.Builder getErrorDetails() {
            return errorDetails != null ? errorDetails.toBuilder() : null;
        }

        public final void setErrorDetails(ErrorDetails.BuilderImpl errorDetails) {
            this.errorDetails = errorDetails != null ? errorDetails.build() : null;
        }

        @Override
        public final Builder errorDetails(ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        public final String getEngineVersion() {
            return engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final PluginProperties.Builder getAvailablePluginProperties() {
            return availablePluginProperties != null ? availablePluginProperties.toBuilder() : null;
        }

        public final void setAvailablePluginProperties(PluginProperties.BuilderImpl availablePluginProperties) {
            this.availablePluginProperties = availablePluginProperties != null ? availablePluginProperties.build() : null;
        }

        @Override
        public final Builder availablePluginProperties(PluginProperties availablePluginProperties) {
            this.availablePluginProperties = availablePluginProperties;
            return this;
        }

        public final PackageConfiguration.Builder getAvailablePackageConfiguration() {
            return availablePackageConfiguration != null ? availablePackageConfiguration.toBuilder() : null;
        }

        public final void setAvailablePackageConfiguration(PackageConfiguration.BuilderImpl availablePackageConfiguration) {
            this.availablePackageConfiguration = availablePackageConfiguration != null ? availablePackageConfiguration.build()
                    : null;
        }

        @Override
        public final Builder availablePackageConfiguration(PackageConfiguration availablePackageConfiguration) {
            this.availablePackageConfiguration = availablePackageConfiguration;
            return this;
        }

        public final Collection<String> getAllowListedUserList() {
            if (allowListedUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return allowListedUserList;
        }

        public final void setAllowListedUserList(Collection<String> allowListedUserList) {
            this.allowListedUserList = PackageUserListCopier.copy(allowListedUserList);
        }

        @Override
        public final Builder allowListedUserList(Collection<String> allowListedUserList) {
            this.allowListedUserList = PackageUserListCopier.copy(allowListedUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowListedUserList(String... allowListedUserList) {
            allowListedUserList(Arrays.asList(allowListedUserList));
            return this;
        }

        public final String getPackageOwner() {
            return packageOwner;
        }

        public final void setPackageOwner(String packageOwner) {
            this.packageOwner = packageOwner;
        }

        @Override
        public final Builder packageOwner(String packageOwner) {
            this.packageOwner = packageOwner;
            return this;
        }

        public final PackageVendingOptions.Builder getPackageVendingOptions() {
            return packageVendingOptions != null ? packageVendingOptions.toBuilder() : null;
        }

        public final void setPackageVendingOptions(PackageVendingOptions.BuilderImpl packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions != null ? packageVendingOptions.build() : null;
        }

        @Override
        public final Builder packageVendingOptions(PackageVendingOptions packageVendingOptions) {
            this.packageVendingOptions = packageVendingOptions;
            return this;
        }

        public final PackageEncryptionOptions.Builder getPackageEncryptionOptions() {
            return packageEncryptionOptions != null ? packageEncryptionOptions.toBuilder() : null;
        }

        public final void setPackageEncryptionOptions(PackageEncryptionOptions.BuilderImpl packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions != null ? packageEncryptionOptions.build() : null;
        }

        @Override
        public final Builder packageEncryptionOptions(PackageEncryptionOptions packageEncryptionOptions) {
            this.packageEncryptionOptions = packageEncryptionOptions;
            return this;
        }

        @Override
        public PackageDetails build() {
            return new PackageDetails(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
