/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration options for determining whether a package can be made available for use by other users.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PackageVendingOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PackageVendingOptions.Builder, PackageVendingOptions> {
    private static final SdkField<Boolean> VENDING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("VendingEnabled").getter(getter(PackageVendingOptions::vendingEnabled))
            .setter(setter(Builder::vendingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VendingEnabled").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VENDING_ENABLED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean vendingEnabled;

    private PackageVendingOptions(BuilderImpl builder) {
        this.vendingEnabled = builder.vendingEnabled;
    }

    /**
     * <p>
     * Indicates whether the package vending feature is enabled, allowing the package to be used by other users.
     * </p>
     * 
     * @return Indicates whether the package vending feature is enabled, allowing the package to be used by other users.
     */
    public final Boolean vendingEnabled() {
        return vendingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vendingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PackageVendingOptions)) {
            return false;
        }
        PackageVendingOptions other = (PackageVendingOptions) obj;
        return Objects.equals(vendingEnabled(), other.vendingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PackageVendingOptions").add("VendingEnabled", vendingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VendingEnabled":
            return Optional.ofNullable(clazz.cast(vendingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VendingEnabled", VENDING_ENABLED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PackageVendingOptions, T> g) {
        return obj -> g.apply((PackageVendingOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PackageVendingOptions> {
        /**
         * <p>
         * Indicates whether the package vending feature is enabled, allowing the package to be used by other users.
         * </p>
         * 
         * @param vendingEnabled
         *        Indicates whether the package vending feature is enabled, allowing the package to be used by other
         *        users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vendingEnabled(Boolean vendingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private Boolean vendingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(PackageVendingOptions model) {
            vendingEnabled(model.vendingEnabled);
        }

        public final Boolean getVendingEnabled() {
            return vendingEnabled;
        }

        public final void setVendingEnabled(Boolean vendingEnabled) {
            this.vendingEnabled = vendingEnabled;
        }

        @Override
        public final Builder vendingEnabled(Boolean vendingEnabled) {
            this.vendingEnabled = vendingEnabled;
            return this;
        }

        @Override
        public PackageVendingOptions build() {
            return new PackageVendingOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
