/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Basic information about the plugin.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PluginProperties implements SdkPojo, Serializable,
        ToCopyableBuilder<PluginProperties.Builder, PluginProperties> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(PluginProperties::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(PluginProperties::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Version")
            .getter(getter(PluginProperties::version)).setter(setter(Builder::version))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> CLASS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ClassName").getter(getter(PluginProperties::className)).setter(setter(Builder::className))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClassName").build()).build();

    private static final SdkField<Long> UNCOMPRESSED_SIZE_IN_BYTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("UncompressedSizeInBytes").getter(getter(PluginProperties::uncompressedSizeInBytes))
            .setter(setter(Builder::uncompressedSizeInBytes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UncompressedSizeInBytes").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            VERSION_FIELD, CLASS_NAME_FIELD, UNCOMPRESSED_SIZE_IN_BYTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final String version;

    private final String className;

    private final Long uncompressedSizeInBytes;

    private PluginProperties(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.version = builder.version;
        this.className = builder.className;
        this.uncompressedSizeInBytes = builder.uncompressedSizeInBytes;
    }

    /**
     * <p>
     * The name of the plugin.
     * </p>
     * 
     * @return The name of the plugin.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The description of the plugin.
     * </p>
     * 
     * @return The description of the plugin.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The version of the plugin.
     * </p>
     * 
     * @return The version of the plugin.
     */
    public final String version() {
        return version;
    }

    /**
     * <p>
     * The name of the class to load.
     * </p>
     * 
     * @return The name of the class to load.
     */
    public final String className() {
        return className;
    }

    /**
     * <p>
     * The uncompressed size of the plugin.
     * </p>
     * 
     * @return The uncompressed size of the plugin.
     */
    public final Long uncompressedSizeInBytes() {
        return uncompressedSizeInBytes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(className());
        hashCode = 31 * hashCode + Objects.hashCode(uncompressedSizeInBytes());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PluginProperties)) {
            return false;
        }
        PluginProperties other = (PluginProperties) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(version(), other.version()) && Objects.equals(className(), other.className())
                && Objects.equals(uncompressedSizeInBytes(), other.uncompressedSizeInBytes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PluginProperties").add("Name", name()).add("Description", description())
                .add("Version", version()).add("ClassName", className())
                .add("UncompressedSizeInBytes", uncompressedSizeInBytes()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "ClassName":
            return Optional.ofNullable(clazz.cast(className()));
        case "UncompressedSizeInBytes":
            return Optional.ofNullable(clazz.cast(uncompressedSizeInBytes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Version", VERSION_FIELD);
        map.put("ClassName", CLASS_NAME_FIELD);
        map.put("UncompressedSizeInBytes", UNCOMPRESSED_SIZE_IN_BYTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PluginProperties, T> g) {
        return obj -> g.apply((PluginProperties) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PluginProperties> {
        /**
         * <p>
         * The name of the plugin.
         * </p>
         * 
         * @param name
         *        The name of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The description of the plugin.
         * </p>
         * 
         * @param description
         *        The description of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The version of the plugin.
         * </p>
         * 
         * @param version
         *        The version of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(String version);

        /**
         * <p>
         * The name of the class to load.
         * </p>
         * 
         * @param className
         *        The name of the class to load.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder className(String className);

        /**
         * <p>
         * The uncompressed size of the plugin.
         * </p>
         * 
         * @param uncompressedSizeInBytes
         *        The uncompressed size of the plugin.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uncompressedSizeInBytes(Long uncompressedSizeInBytes);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private String version;

        private String className;

        private Long uncompressedSizeInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(PluginProperties model) {
            name(model.name);
            description(model.description);
            version(model.version);
            className(model.className);
            uncompressedSizeInBytes(model.uncompressedSizeInBytes);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVersion() {
            return version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getClassName() {
            return className;
        }

        public final void setClassName(String className) {
            this.className = className;
        }

        @Override
        public final Builder className(String className) {
            this.className = className;
            return this;
        }

        public final Long getUncompressedSizeInBytes() {
            return uncompressedSizeInBytes;
        }

        public final void setUncompressedSizeInBytes(Long uncompressedSizeInBytes) {
            this.uncompressedSizeInBytes = uncompressedSizeInBytes;
        }

        @Override
        public final Builder uncompressedSizeInBytes(Long uncompressedSizeInBytes) {
            this.uncompressedSizeInBytes = uncompressedSizeInBytes;
            return this;
        }

        @Override
        public PluginProperties build() {
            return new PluginProperties(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
