/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdatePackageScopeRequest extends OpenSearchRequest implements
        ToCopyableBuilder<UpdatePackageScopeRequest.Builder, UpdatePackageScopeRequest> {
    private static final SdkField<String> PACKAGE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PackageID").getter(getter(UpdatePackageScopeRequest::packageID)).setter(setter(Builder::packageID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageID").build()).build();

    private static final SdkField<String> OPERATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Operation").getter(getter(UpdatePackageScopeRequest::operationAsString))
            .setter(setter(Builder::operation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Operation").build()).build();

    private static final SdkField<List<String>> PACKAGE_USER_LIST_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("PackageUserList")
            .getter(getter(UpdatePackageScopeRequest::packageUserList))
            .setter(setter(Builder::packageUserList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PackageUserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PACKAGE_ID_FIELD,
            OPERATION_FIELD, PACKAGE_USER_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String packageID;

    private final String operation;

    private final List<String> packageUserList;

    private UpdatePackageScopeRequest(BuilderImpl builder) {
        super(builder);
        this.packageID = builder.packageID;
        this.operation = builder.operation;
        this.packageUserList = builder.packageUserList;
    }

    /**
     * <p>
     * ID of the package whose scope is being updated.
     * </p>
     * 
     * @return ID of the package whose scope is being updated.
     */
    public final String packageID() {
        return packageID;
    }

    /**
     * <p>
     * The operation to perform on the package scope (e.g., add/remove/override users).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link PackageScopeOperationEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return The operation to perform on the package scope (e.g., add/remove/override users).
     * @see PackageScopeOperationEnum
     */
    public final PackageScopeOperationEnum operation() {
        return PackageScopeOperationEnum.fromValue(operation);
    }

    /**
     * <p>
     * The operation to perform on the package scope (e.g., add/remove/override users).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #operation} will
     * return {@link PackageScopeOperationEnum#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #operationAsString}.
     * </p>
     * 
     * @return The operation to perform on the package scope (e.g., add/remove/override users).
     * @see PackageScopeOperationEnum
     */
    public final String operationAsString() {
        return operation;
    }

    /**
     * For responses, this returns true if the service returned a value for the PackageUserList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPackageUserList() {
        return packageUserList != null && !(packageUserList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of users to be added or removed from the package scope.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPackageUserList} method.
     * </p>
     * 
     * @return List of users to be added or removed from the package scope.
     */
    public final List<String> packageUserList() {
        return packageUserList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(packageID());
        hashCode = 31 * hashCode + Objects.hashCode(operationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasPackageUserList() ? packageUserList() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePackageScopeRequest)) {
            return false;
        }
        UpdatePackageScopeRequest other = (UpdatePackageScopeRequest) obj;
        return Objects.equals(packageID(), other.packageID()) && Objects.equals(operationAsString(), other.operationAsString())
                && hasPackageUserList() == other.hasPackageUserList()
                && Objects.equals(packageUserList(), other.packageUserList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdatePackageScopeRequest").add("PackageID", packageID()).add("Operation", operationAsString())
                .add("PackageUserList", hasPackageUserList() ? packageUserList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PackageID":
            return Optional.ofNullable(clazz.cast(packageID()));
        case "Operation":
            return Optional.ofNullable(clazz.cast(operationAsString()));
        case "PackageUserList":
            return Optional.ofNullable(clazz.cast(packageUserList()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PackageID", PACKAGE_ID_FIELD);
        map.put("Operation", OPERATION_FIELD);
        map.put("PackageUserList", PACKAGE_USER_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePackageScopeRequest, T> g) {
        return obj -> g.apply((UpdatePackageScopeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdatePackageScopeRequest> {
        /**
         * <p>
         * ID of the package whose scope is being updated.
         * </p>
         * 
         * @param packageID
         *        ID of the package whose scope is being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageID(String packageID);

        /**
         * <p>
         * The operation to perform on the package scope (e.g., add/remove/override users).
         * </p>
         * 
         * @param operation
         *        The operation to perform on the package scope (e.g., add/remove/override users).
         * @see PackageScopeOperationEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageScopeOperationEnum
         */
        Builder operation(String operation);

        /**
         * <p>
         * The operation to perform on the package scope (e.g., add/remove/override users).
         * </p>
         * 
         * @param operation
         *        The operation to perform on the package scope (e.g., add/remove/override users).
         * @see PackageScopeOperationEnum
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PackageScopeOperationEnum
         */
        Builder operation(PackageScopeOperationEnum operation);

        /**
         * <p>
         * List of users to be added or removed from the package scope.
         * </p>
         * 
         * @param packageUserList
         *        List of users to be added or removed from the package scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageUserList(Collection<String> packageUserList);

        /**
         * <p>
         * List of users to be added or removed from the package scope.
         * </p>
         * 
         * @param packageUserList
         *        List of users to be added or removed from the package scope.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder packageUserList(String... packageUserList);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchRequest.BuilderImpl implements Builder {
        private String packageID;

        private String operation;

        private List<String> packageUserList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePackageScopeRequest model) {
            super(model);
            packageID(model.packageID);
            operation(model.operation);
            packageUserList(model.packageUserList);
        }

        public final String getPackageID() {
            return packageID;
        }

        public final void setPackageID(String packageID) {
            this.packageID = packageID;
        }

        @Override
        public final Builder packageID(String packageID) {
            this.packageID = packageID;
            return this;
        }

        public final String getOperation() {
            return operation;
        }

        public final void setOperation(String operation) {
            this.operation = operation;
        }

        @Override
        public final Builder operation(String operation) {
            this.operation = operation;
            return this;
        }

        @Override
        public final Builder operation(PackageScopeOperationEnum operation) {
            this.operation(operation == null ? null : operation.toString());
            return this;
        }

        public final Collection<String> getPackageUserList() {
            if (packageUserList instanceof SdkAutoConstructList) {
                return null;
            }
            return packageUserList;
        }

        public final void setPackageUserList(Collection<String> packageUserList) {
            this.packageUserList = PackageUserListCopier.copy(packageUserList);
        }

        @Override
        public final Builder packageUserList(Collection<String> packageUserList) {
            this.packageUserList = PackageUserListCopier.copy(packageUserList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder packageUserList(String... packageUserList) {
            packageUserList(Arrays.asList(packageUserList));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePackageScopeRequest build() {
            return new UpdatePackageScopeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
