/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateVpcEndpointResponse extends OpenSearchResponse implements
        ToCopyableBuilder<UpdateVpcEndpointResponse.Builder, UpdateVpcEndpointResponse> {
    private static final SdkField<VpcEndpoint> VPC_ENDPOINT_FIELD = SdkField.<VpcEndpoint> builder(MarshallingType.SDK_POJO)
            .memberName("VpcEndpoint").getter(getter(UpdateVpcEndpointResponse::vpcEndpoint))
            .setter(setter(Builder::vpcEndpoint)).constructor(VpcEndpoint::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final VpcEndpoint vpcEndpoint;

    private UpdateVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpoint = builder.vpcEndpoint;
    }

    /**
     * <p>
     * The endpoint to be updated.
     * </p>
     * 
     * @return The endpoint to be updated.
     */
    public final VpcEndpoint vpcEndpoint() {
        return vpcEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(vpcEndpoint());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateVpcEndpointResponse)) {
            return false;
        }
        UpdateVpcEndpointResponse other = (UpdateVpcEndpointResponse) obj;
        return Objects.equals(vpcEndpoint(), other.vpcEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateVpcEndpointResponse").add("VpcEndpoint", vpcEndpoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "VpcEndpoint":
            return Optional.ofNullable(clazz.cast(vpcEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("VpcEndpoint", VPC_ENDPOINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateVpcEndpointResponse, T> g) {
        return obj -> g.apply((UpdateVpcEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateVpcEndpointResponse> {
        /**
         * <p>
         * The endpoint to be updated.
         * </p>
         * 
         * @param vpcEndpoint
         *        The endpoint to be updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpoint(VpcEndpoint vpcEndpoint);

        /**
         * <p>
         * The endpoint to be updated.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcEndpoint.Builder} avoiding the need to
         * create one manually via {@link VpcEndpoint#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcEndpoint.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcEndpoint(VpcEndpoint)}.
         * 
         * @param vpcEndpoint
         *        a consumer that will call methods on {@link VpcEndpoint.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpoint(VpcEndpoint)
         */
        default Builder vpcEndpoint(Consumer<VpcEndpoint.Builder> vpcEndpoint) {
            return vpcEndpoint(VpcEndpoint.builder().applyMutation(vpcEndpoint).build());
        }
    }

    static final class BuilderImpl extends OpenSearchResponse.BuilderImpl implements Builder {
        private VpcEndpoint vpcEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateVpcEndpointResponse model) {
            super(model);
            vpcEndpoint(model.vpcEndpoint);
        }

        public final VpcEndpoint.Builder getVpcEndpoint() {
            return vpcEndpoint != null ? vpcEndpoint.toBuilder() : null;
        }

        public final void setVpcEndpoint(VpcEndpoint.BuilderImpl vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint != null ? vpcEndpoint.build() : null;
        }

        @Override
        public final Builder vpcEndpoint(VpcEndpoint vpcEndpoint) {
            this.vpcEndpoint = vpcEndpoint;
            return this;
        }

        @Override
        public UpdateVpcEndpointResponse build() {
            return new UpdateVpcEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
