/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a single step of an upgrade or upgrade eligibility check workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpgradeStepItem implements SdkPojo, Serializable, ToCopyableBuilder<UpgradeStepItem.Builder, UpgradeStepItem> {
    private static final SdkField<String> UPGRADE_STEP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpgradeStep").getter(getter(UpgradeStepItem::upgradeStepAsString)).setter(setter(Builder::upgradeStep))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStep").build()).build();

    private static final SdkField<String> UPGRADE_STEP_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpgradeStepStatus").getter(getter(UpgradeStepItem::upgradeStepStatusAsString))
            .setter(setter(Builder::upgradeStepStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpgradeStepStatus").build()).build();

    private static final SdkField<List<String>> ISSUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Issues")
            .getter(getter(UpgradeStepItem::issues))
            .setter(setter(Builder::issues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Issues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Double> PROGRESS_PERCENT_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("ProgressPercent").getter(getter(UpgradeStepItem::progressPercent))
            .setter(setter(Builder::progressPercent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProgressPercent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(UPGRADE_STEP_FIELD,
            UPGRADE_STEP_STATUS_FIELD, ISSUES_FIELD, PROGRESS_PERCENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String upgradeStep;

    private final String upgradeStepStatus;

    private final List<String> issues;

    private final Double progressPercent;

    private UpgradeStepItem(BuilderImpl builder) {
        this.upgradeStep = builder.upgradeStep;
        this.upgradeStepStatus = builder.upgradeStepStatus;
        this.issues = builder.issues;
        this.progressPercent = builder.progressPercent;
    }

    /**
     * <p>
     * One of three steps that an upgrade or upgrade eligibility check goes through:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PreUpgradeCheck
     * </p>
     * </li>
     * <li>
     * <p>
     * Snapshot
     * </p>
     * </li>
     * <li>
     * <p>
     * Upgrade
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upgradeStep} will
     * return {@link UpgradeStep#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upgradeStepAsString}.
     * </p>
     * 
     * @return One of three steps that an upgrade or upgrade eligibility check goes through: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PreUpgradeCheck
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Snapshot
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Upgrade
     *         </p>
     *         </li>
     * @see UpgradeStep
     */
    public final UpgradeStep upgradeStep() {
        return UpgradeStep.fromValue(upgradeStep);
    }

    /**
     * <p>
     * One of three steps that an upgrade or upgrade eligibility check goes through:
     * </p>
     * <ul>
     * <li>
     * <p>
     * PreUpgradeCheck
     * </p>
     * </li>
     * <li>
     * <p>
     * Snapshot
     * </p>
     * </li>
     * <li>
     * <p>
     * Upgrade
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upgradeStep} will
     * return {@link UpgradeStep#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upgradeStepAsString}.
     * </p>
     * 
     * @return One of three steps that an upgrade or upgrade eligibility check goes through: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         PreUpgradeCheck
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Snapshot
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Upgrade
     *         </p>
     *         </li>
     * @see UpgradeStep
     */
    public final String upgradeStepAsString() {
        return upgradeStep;
    }

    /**
     * <p>
     * The current status of the upgrade. The status can take one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Progress
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded with Issues
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upgradeStepStatus}
     * will return {@link UpgradeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upgradeStepStatusAsString}.
     * </p>
     * 
     * @return The current status of the upgrade. The status can take one of the following values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Progress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded with Issues
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed
     *         </p>
     *         </li>
     * @see UpgradeStatus
     */
    public final UpgradeStatus upgradeStepStatus() {
        return UpgradeStatus.fromValue(upgradeStepStatus);
    }

    /**
     * <p>
     * The current status of the upgrade. The status can take one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * In Progress
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded
     * </p>
     * </li>
     * <li>
     * <p>
     * Succeeded with Issues
     * </p>
     * </li>
     * <li>
     * <p>
     * Failed
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upgradeStepStatus}
     * will return {@link UpgradeStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #upgradeStepStatusAsString}.
     * </p>
     * 
     * @return The current status of the upgrade. The status can take one of the following values: </p>
     *         <ul>
     *         <li>
     *         <p>
     *         In Progress
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Succeeded with Issues
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         Failed
     *         </p>
     *         </li>
     * @see UpgradeStatus
     */
    public final String upgradeStepStatusAsString() {
        return upgradeStepStatus;
    }

    /**
     * For responses, this returns true if the service returned a value for the Issues property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIssues() {
        return issues != null && !(issues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of strings containing detailed information about the errors encountered in a particular step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIssues} method.
     * </p>
     * 
     * @return A list of strings containing detailed information about the errors encountered in a particular step.
     */
    public final List<String> issues() {
        return issues;
    }

    /**
     * <p>
     * The floating point value representing the progress percentage of a particular step.
     * </p>
     * 
     * @return The floating point value representing the progress percentage of a particular step.
     */
    public final Double progressPercent() {
        return progressPercent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(upgradeStepAsString());
        hashCode = 31 * hashCode + Objects.hashCode(upgradeStepStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasIssues() ? issues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(progressPercent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpgradeStepItem)) {
            return false;
        }
        UpgradeStepItem other = (UpgradeStepItem) obj;
        return Objects.equals(upgradeStepAsString(), other.upgradeStepAsString())
                && Objects.equals(upgradeStepStatusAsString(), other.upgradeStepStatusAsString())
                && hasIssues() == other.hasIssues() && Objects.equals(issues(), other.issues())
                && Objects.equals(progressPercent(), other.progressPercent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpgradeStepItem").add("UpgradeStep", upgradeStepAsString())
                .add("UpgradeStepStatus", upgradeStepStatusAsString()).add("Issues", hasIssues() ? issues() : null)
                .add("ProgressPercent", progressPercent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UpgradeStep":
            return Optional.ofNullable(clazz.cast(upgradeStepAsString()));
        case "UpgradeStepStatus":
            return Optional.ofNullable(clazz.cast(upgradeStepStatusAsString()));
        case "Issues":
            return Optional.ofNullable(clazz.cast(issues()));
        case "ProgressPercent":
            return Optional.ofNullable(clazz.cast(progressPercent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UpgradeStep", UPGRADE_STEP_FIELD);
        map.put("UpgradeStepStatus", UPGRADE_STEP_STATUS_FIELD);
        map.put("Issues", ISSUES_FIELD);
        map.put("ProgressPercent", PROGRESS_PERCENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpgradeStepItem, T> g) {
        return obj -> g.apply((UpgradeStepItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpgradeStepItem> {
        /**
         * <p>
         * One of three steps that an upgrade or upgrade eligibility check goes through:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PreUpgradeCheck
         * </p>
         * </li>
         * <li>
         * <p>
         * Snapshot
         * </p>
         * </li>
         * <li>
         * <p>
         * Upgrade
         * </p>
         * </li>
         * </ul>
         * 
         * @param upgradeStep
         *        One of three steps that an upgrade or upgrade eligibility check goes through: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PreUpgradeCheck
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Snapshot
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Upgrade
         *        </p>
         *        </li>
         * @see UpgradeStep
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStep
         */
        Builder upgradeStep(String upgradeStep);

        /**
         * <p>
         * One of three steps that an upgrade or upgrade eligibility check goes through:
         * </p>
         * <ul>
         * <li>
         * <p>
         * PreUpgradeCheck
         * </p>
         * </li>
         * <li>
         * <p>
         * Snapshot
         * </p>
         * </li>
         * <li>
         * <p>
         * Upgrade
         * </p>
         * </li>
         * </ul>
         * 
         * @param upgradeStep
         *        One of three steps that an upgrade or upgrade eligibility check goes through: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        PreUpgradeCheck
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Snapshot
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Upgrade
         *        </p>
         *        </li>
         * @see UpgradeStep
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStep
         */
        Builder upgradeStep(UpgradeStep upgradeStep);

        /**
         * <p>
         * The current status of the upgrade. The status can take one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Progress
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded with Issues
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param upgradeStepStatus
         *        The current status of the upgrade. The status can take one of the following values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Progress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded with Issues
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed
         *        </p>
         *        </li>
         * @see UpgradeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStatus
         */
        Builder upgradeStepStatus(String upgradeStepStatus);

        /**
         * <p>
         * The current status of the upgrade. The status can take one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * In Progress
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded
         * </p>
         * </li>
         * <li>
         * <p>
         * Succeeded with Issues
         * </p>
         * </li>
         * <li>
         * <p>
         * Failed
         * </p>
         * </li>
         * </ul>
         * 
         * @param upgradeStepStatus
         *        The current status of the upgrade. The status can take one of the following values: </p>
         *        <ul>
         *        <li>
         *        <p>
         *        In Progress
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Succeeded with Issues
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        Failed
         *        </p>
         *        </li>
         * @see UpgradeStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpgradeStatus
         */
        Builder upgradeStepStatus(UpgradeStatus upgradeStepStatus);

        /**
         * <p>
         * A list of strings containing detailed information about the errors encountered in a particular step.
         * </p>
         * 
         * @param issues
         *        A list of strings containing detailed information about the errors encountered in a particular step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(Collection<String> issues);

        /**
         * <p>
         * A list of strings containing detailed information about the errors encountered in a particular step.
         * </p>
         * 
         * @param issues
         *        A list of strings containing detailed information about the errors encountered in a particular step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issues(String... issues);

        /**
         * <p>
         * The floating point value representing the progress percentage of a particular step.
         * </p>
         * 
         * @param progressPercent
         *        The floating point value representing the progress percentage of a particular step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder progressPercent(Double progressPercent);
    }

    static final class BuilderImpl implements Builder {
        private String upgradeStep;

        private String upgradeStepStatus;

        private List<String> issues = DefaultSdkAutoConstructList.getInstance();

        private Double progressPercent;

        private BuilderImpl() {
        }

        private BuilderImpl(UpgradeStepItem model) {
            upgradeStep(model.upgradeStep);
            upgradeStepStatus(model.upgradeStepStatus);
            issues(model.issues);
            progressPercent(model.progressPercent);
        }

        public final String getUpgradeStep() {
            return upgradeStep;
        }

        public final void setUpgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
        }

        @Override
        public final Builder upgradeStep(String upgradeStep) {
            this.upgradeStep = upgradeStep;
            return this;
        }

        @Override
        public final Builder upgradeStep(UpgradeStep upgradeStep) {
            this.upgradeStep(upgradeStep == null ? null : upgradeStep.toString());
            return this;
        }

        public final String getUpgradeStepStatus() {
            return upgradeStepStatus;
        }

        public final void setUpgradeStepStatus(String upgradeStepStatus) {
            this.upgradeStepStatus = upgradeStepStatus;
        }

        @Override
        public final Builder upgradeStepStatus(String upgradeStepStatus) {
            this.upgradeStepStatus = upgradeStepStatus;
            return this;
        }

        @Override
        public final Builder upgradeStepStatus(UpgradeStatus upgradeStepStatus) {
            this.upgradeStepStatus(upgradeStepStatus == null ? null : upgradeStepStatus.toString());
            return this;
        }

        public final Collection<String> getIssues() {
            if (issues instanceof SdkAutoConstructList) {
                return null;
            }
            return issues;
        }

        public final void setIssues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
        }

        @Override
        public final Builder issues(Collection<String> issues) {
            this.issues = IssuesCopier.copy(issues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder issues(String... issues) {
            issues(Arrays.asList(issues));
            return this;
        }

        public final Double getProgressPercent() {
            return progressPercent;
        }

        public final void setProgressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
        }

        @Override
        public final Builder progressPercent(Double progressPercent) {
            this.progressPercent = progressPercent;
            return this;
        }

        @Override
        public UpgradeStepItem build() {
            return new UpgradeStepItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
