/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error information for an OpenSearch Serverless request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class EffectiveLifecyclePolicyErrorDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<EffectiveLifecyclePolicyErrorDetail.Builder, EffectiveLifecyclePolicyErrorDetail> {
    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(EffectiveLifecyclePolicyErrorDetail::errorCode))
            .setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(EffectiveLifecyclePolicyErrorDetail::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> RESOURCE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resource").getter(getter(EffectiveLifecyclePolicyErrorDetail::resource))
            .setter(setter(Builder::resource))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resource").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(EffectiveLifecyclePolicyErrorDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_CODE_FIELD,
            ERROR_MESSAGE_FIELD, RESOURCE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String errorCode;

    private final String errorMessage;

    private final String resource;

    private final String type;

    private EffectiveLifecyclePolicyErrorDetail(BuilderImpl builder) {
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.resource = builder.resource;
        this.type = builder.type;
    }

    /**
     * <p>
     * The error code for the request.
     * </p>
     * 
     * @return The error code for the request.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * A description of the error. For example, <code>The specified Index resource is not found</code>.
     * </p>
     * 
     * @return A description of the error. For example, <code>The specified Index resource is not found</code>.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The name of OpenSearch Serverless index resource.
     * </p>
     * 
     * @return The name of OpenSearch Serverless index resource.
     */
    public final String resource() {
        return resource;
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final LifecyclePolicyType type() {
        return LifecyclePolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of lifecycle policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link LifecyclePolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of lifecycle policy.
     * @see LifecyclePolicyType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(resource());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EffectiveLifecyclePolicyErrorDetail)) {
            return false;
        }
        EffectiveLifecyclePolicyErrorDetail other = (EffectiveLifecyclePolicyErrorDetail) obj;
        return Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(resource(), other.resource()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EffectiveLifecyclePolicyErrorDetail").add("ErrorCode", errorCode())
                .add("ErrorMessage", errorMessage()).add("Resource", resource()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "resource":
            return Optional.ofNullable(clazz.cast(resource()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EffectiveLifecyclePolicyErrorDetail, T> g) {
        return obj -> g.apply((EffectiveLifecyclePolicyErrorDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, EffectiveLifecyclePolicyErrorDetail> {
        /**
         * <p>
         * The error code for the request.
         * </p>
         * 
         * @param errorCode
         *        The error code for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * A description of the error. For example, <code>The specified Index resource is not found</code>.
         * </p>
         * 
         * @param errorMessage
         *        A description of the error. For example, <code>The specified Index resource is not found</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The name of OpenSearch Serverless index resource.
         * </p>
         * 
         * @param resource
         *        The name of OpenSearch Serverless index resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resource(String resource);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of lifecycle policy.
         * </p>
         * 
         * @param type
         *        The type of lifecycle policy.
         * @see LifecyclePolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyType
         */
        Builder type(LifecyclePolicyType type);
    }

    static final class BuilderImpl implements Builder {
        private String errorCode;

        private String errorMessage;

        private String resource;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(EffectiveLifecyclePolicyErrorDetail model) {
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            resource(model.resource);
            type(model.type);
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getResource() {
            return resource;
        }

        public final void setResource(String resource) {
            this.resource = resource;
        }

        @Override
        public final Builder resource(String resource) {
            this.resource = resource;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(LifecyclePolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public EffectiveLifecyclePolicyErrorDetail build() {
            return new EffectiveLifecyclePolicyErrorDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
