/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics for an OpenSearch Serverless lifecycle policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyStats implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyStats.Builder, LifecyclePolicyStats> {
    private static final SdkField<Long> RETENTION_POLICY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("RetentionPolicyCount").getter(getter(LifecyclePolicyStats::retentionPolicyCount))
            .setter(setter(Builder::retentionPolicyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RetentionPolicyCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETENTION_POLICY_COUNT_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long retentionPolicyCount;

    private LifecyclePolicyStats(BuilderImpl builder) {
        this.retentionPolicyCount = builder.retentionPolicyCount;
    }

    /**
     * <p>
     * The number of retention lifecycle policies in the current account.
     * </p>
     * 
     * @return The number of retention lifecycle policies in the current account.
     */
    public final Long retentionPolicyCount() {
        return retentionPolicyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(retentionPolicyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyStats)) {
            return false;
        }
        LifecyclePolicyStats other = (LifecyclePolicyStats) obj;
        return Objects.equals(retentionPolicyCount(), other.retentionPolicyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LifecyclePolicyStats").add("RetentionPolicyCount", retentionPolicyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RetentionPolicyCount":
            return Optional.ofNullable(clazz.cast(retentionPolicyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyStats, T> g) {
        return obj -> g.apply((LifecyclePolicyStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyStats> {
        /**
         * <p>
         * The number of retention lifecycle policies in the current account.
         * </p>
         * 
         * @param retentionPolicyCount
         *        The number of retention lifecycle policies in the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retentionPolicyCount(Long retentionPolicyCount);
    }

    static final class BuilderImpl implements Builder {
        private Long retentionPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyStats model) {
            retentionPolicyCount(model.retentionPolicyCount);
        }

        public final Long getRetentionPolicyCount() {
            return retentionPolicyCount;
        }

        public final void setRetentionPolicyCount(Long retentionPolicyCount) {
            this.retentionPolicyCount = retentionPolicyCount;
        }

        @Override
        public final Builder retentionPolicyCount(Long retentionPolicyCount) {
            this.retentionPolicyCount = retentionPolicyCount;
            return this;
        }

        @Override
        public LifecyclePolicyStats build() {
            return new LifecyclePolicyStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
