/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.opensearchserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesPublisher;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsPublisher;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesPublisher;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsPublisher;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesPublisher;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsPublisher;

/**
 * Service client for accessing OpenSearch Service Serverless asynchronously. This can be created using the static
 * {@link #builder()} method.The asynchronous client performs non-blocking I/O when configured with any
 * {@code SdkAsyncHttpClient} supported in the SDK. However, full non-blocking is not guaranteed as the async client may
 * perform blocking calls in some cases such as credentials retrieval and endpoint discovery as part of the async API
 * call.
 *
 * <p>
 * Use the Amazon OpenSearch Serverless API to create, configure, and manage OpenSearch Serverless collections and
 * security policies.
 * </p>
 * <p>
 * OpenSearch Serverless is an on-demand, pre-provisioned serverless configuration for Amazon OpenSearch Service.
 * OpenSearch Serverless removes the operational complexities of provisioning, configuring, and tuning your OpenSearch
 * clusters. It enables you to easily search and analyze petabytes of data without having to worry about the underlying
 * infrastructure and data management.
 * </p>
 * <p>
 * To learn more about OpenSearch Serverless, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html">What is Amazon
 * OpenSearch Serverless?</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OpenSearchServerlessAsyncClient extends AwsClient {
    String SERVICE_NAME = "aoss";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "aoss";

    /**
     * <p>
     * Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards
     * endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param batchGetCollectionRequest
     * @return A Java Future containing the result of the BatchGetCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCollectionResponse> batchGetCollection(BatchGetCollectionRequest batchGetCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns attributes for one or more collections, including the collection endpoint and the OpenSearch Dashboards
     * endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetCollectionRequest#builder()}
     * </p>
     *
     * @param batchGetCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetCollectionResponse> batchGetCollection(
            Consumer<BatchGetCollectionRequest.Builder> batchGetCollectionRequest) {
        return batchGetCollection(BatchGetCollectionRequest.builder().applyMutation(batchGetCollectionRequest).build());
    }

    /**
     * <p>
     * Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     *
     * @param batchGetEffectiveLifecyclePolicyRequest
     * @return A Java Future containing the result of the BatchGetEffectiveLifecyclePolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetEffectiveLifecyclePolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetEffectiveLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetEffectiveLifecyclePolicyResponse> batchGetEffectiveLifecyclePolicy(
            BatchGetEffectiveLifecyclePolicyRequest batchGetEffectiveLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetEffectiveLifecyclePolicyRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetEffectiveLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param batchGetEffectiveLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetEffectiveLifecyclePolicy operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetEffectiveLifecyclePolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetEffectiveLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetEffectiveLifecyclePolicyResponse> batchGetEffectiveLifecyclePolicy(
            Consumer<BatchGetEffectiveLifecyclePolicyRequest.Builder> batchGetEffectiveLifecyclePolicyRequest) {
        return batchGetEffectiveLifecyclePolicy(BatchGetEffectiveLifecyclePolicyRequest.builder()
                .applyMutation(batchGetEffectiveLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     *
     * @param batchGetLifecyclePolicyRequest
     * @return A Java Future containing the result of the BatchGetLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetLifecyclePolicyResponse> batchGetLifecyclePolicy(
            BatchGetLifecyclePolicyRequest batchGetLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetLifecyclePolicyRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param batchGetLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetLifecyclePolicyResponse> batchGetLifecyclePolicy(
            Consumer<BatchGetLifecyclePolicyRequest.Builder> batchGetLifecyclePolicyRequest) {
        return batchGetLifecyclePolicy(BatchGetLifecyclePolicyRequest.builder().applyMutation(batchGetLifecyclePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param batchGetVpcEndpointRequest
     * @return A Java Future containing the result of the BatchGetVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetVpcEndpointResponse> batchGetVpcEndpoint(
            BatchGetVpcEndpointRequest batchGetVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetVpcEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetVpcEndpointRequest#builder()}
     * </p>
     *
     * @param batchGetVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the BatchGetVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.BatchGetVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetVpcEndpointResponse> batchGetVpcEndpoint(
            Consumer<BatchGetVpcEndpointRequest.Builder> batchGetVpcEndpointRequest) {
        return batchGetVpcEndpoint(BatchGetVpcEndpointRequest.builder().applyMutation(batchGetVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the
     * resources within them, and allow a user to access that data irrespective of the access mechanism or network
     * source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param createAccessPolicyRequest
     * @return A Java Future containing the result of the CreateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessPolicyResponse> createAccessPolicy(CreateAccessPolicyRequest createAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the
     * resources within them, and allow a user to access that data irrespective of the access mechanism or network
     * source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param createAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateAccessPolicyResponse> createAccessPolicy(
            Consumer<CreateAccessPolicyRequest.Builder> createAccessPolicyRequest) {
        return createAccessPolicy(CreateAccessPolicyRequest.builder().applyMutation(createAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param createCollectionRequest
     * @return A Java Future containing the result of the CreateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OcuLimitExceededException Thrown when the collection you're attempting to create results in a number
     *         of search or indexing OCUs that exceeds the account limit.</li>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCollectionResponse> createCollection(CreateCollectionRequest createCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCollectionRequest#builder()}
     * </p>
     *
     * @param createCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>OcuLimitExceededException Thrown when the collection you're attempting to create results in a number
     *         of search or indexing OCUs that exceeds the account limit.</li>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateCollectionResponse> createCollection(
            Consumer<CreateCollectionRequest.Builder> createCollectionRequest) {
        return createCollection(CreateCollectionRequest.builder().applyMutation(createCollectionRequest).build());
    }

    /**
     * <p>
     * Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of
     * days or hours to retain the data on an OpenSearch Serverless index. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create"
     * >Creating data lifecycle policies</a>.
     * </p>
     *
     * @param createLifecyclePolicyRequest
     * @return A Java Future containing the result of the CreateLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLifecyclePolicyResponse> createLifecyclePolicy(
            CreateLifecyclePolicyRequest createLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of
     * days or hours to retain the data on an OpenSearch Serverless index. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create"
     * >Creating data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param createLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLifecyclePolicyResponse> createLifecyclePolicy(
            Consumer<CreateLifecyclePolicyRequest.Builder> createLifecyclePolicyRequest) {
        return createLifecyclePolicy(CreateLifecyclePolicyRequest.builder().applyMutation(createLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Specifies a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param createSecurityConfigRequest
     * @return A Java Future containing the result of the CreateSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityConfigResponse> createSecurityConfig(
            CreateSecurityConfigRequest createSecurityConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityConfigRequest#builder()}
     * </p>
     *
     * @param createSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityConfigResponse> createSecurityConfig(
            Consumer<CreateSecurityConfigRequest.Builder> createSecurityConfigRequest) {
        return createSecurityConfig(CreateSecurityConfigRequest.builder().applyMutation(createSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide
     * access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints.
     * They also allow you to secure a collection with a KMS encryption key. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param createSecurityPolicyRequest
     * @return A Java Future containing the result of the CreateSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityPolicyResponse> createSecurityPolicy(
            CreateSecurityPolicyRequest createSecurityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide
     * access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints.
     * They also allow you to secure a collection with a KMS encryption key. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param createSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateSecurityPolicyResponse> createSecurityPolicy(
            Consumer<CreateSecurityPolicyRequest.Builder> createSecurityPolicyRequest) {
        return createSecurityPolicy(CreateSecurityPolicyRequest.builder().applyMutation(createSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param createVpcEndpointRequest
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateVpcEndpointResponse> createVpcEndpoint(
            Consumer<CreateVpcEndpointRequest.Builder> createVpcEndpointRequest) {
        return createVpcEndpoint(CreateVpcEndpointRequest.builder().applyMutation(createVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param deleteAccessPolicyRequest
     * @return A Java Future containing the result of the DeleteAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessPolicyResponse> deleteAccessPolicy(DeleteAccessPolicyRequest deleteAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteAccessPolicyResponse> deleteAccessPolicy(
            Consumer<DeleteAccessPolicyRequest.Builder> deleteAccessPolicyRequest) {
        return deleteAccessPolicy(DeleteAccessPolicyRequest.builder().applyMutation(deleteAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param deleteCollectionRequest
     * @return A Java Future containing the result of the DeleteCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCollectionResponse> deleteCollection(DeleteCollectionRequest deleteCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCollectionRequest#builder()}
     * </p>
     *
     * @param deleteCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteCollectionResponse> deleteCollection(
            Consumer<DeleteCollectionRequest.Builder> deleteCollectionRequest) {
        return deleteCollection(DeleteCollectionRequest.builder().applyMutation(deleteCollectionRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless lifecycle policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete"
     * >Deleting data lifecycle policies</a>.
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     * @return A Java Future containing the result of the DeleteLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLifecyclePolicyResponse> deleteLifecyclePolicy(
            DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless lifecycle policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete"
     * >Deleting data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLifecyclePolicyResponse> deleteLifecyclePolicy(
            Consumer<DeleteLifecyclePolicyRequest.Builder> deleteLifecyclePolicyRequest) {
        return deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.builder().applyMutation(deleteLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param deleteSecurityConfigRequest
     * @return A Java Future containing the result of the DeleteSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityConfigResponse> deleteSecurityConfig(
            DeleteSecurityConfigRequest deleteSecurityConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityConfigRequest#builder()}
     * </p>
     *
     * @param deleteSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityConfigResponse> deleteSecurityConfig(
            Consumer<DeleteSecurityConfigRequest.Builder> deleteSecurityConfigRequest) {
        return deleteSecurityConfig(DeleteSecurityConfigRequest.builder().applyMutation(deleteSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless security policy.
     * </p>
     *
     * @param deleteSecurityPolicyRequest
     * @return A Java Future containing the result of the DeleteSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityPolicyResponse> deleteSecurityPolicy(
            DeleteSecurityPolicyRequest deleteSecurityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless security policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param deleteSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteSecurityPolicyResponse> deleteSecurityPolicy(
            Consumer<DeleteSecurityPolicyRequest.Builder> deleteSecurityPolicyRequest) {
        return deleteSecurityPolicy(DeleteSecurityPolicyRequest.builder().applyMutation(deleteSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param deleteVpcEndpointRequest
     * @return A Java Future containing the result of the DeleteVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointResponse> deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVpcEndpointRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.DeleteVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteVpcEndpointResponse> deleteVpcEndpoint(
            Consumer<DeleteVpcEndpointRequest.Builder> deleteVpcEndpointRequest) {
        return deleteVpcEndpoint(DeleteVpcEndpointRequest.builder().applyMutation(deleteVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Returns an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param getAccessPolicyRequest
     * @return A Java Future containing the result of the GetAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessPolicyResponse> getAccessPolicy(GetAccessPolicyRequest getAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccessPolicyRequest#builder()}
     * </p>
     *
     * @param getAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccessPolicyResponse> getAccessPolicy(
            Consumer<GetAccessPolicyRequest.Builder> getAccessPolicyRequest) {
        return getAccessPolicy(GetAccessPolicyRequest.builder().applyMutation(getAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Returns account-level settings related to OpenSearch Serverless.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns account-level settings related to OpenSearch Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAccountSettingsResponse> getAccountSettings(
            Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest) {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and
     * security policies.
     * </p>
     *
     * @param getPoliciesStatsRequest
     * @return A Java Future containing the result of the GetPoliciesStats operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetPoliciesStats
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetPoliciesStats"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPoliciesStatsResponse> getPoliciesStats(GetPoliciesStatsRequest getPoliciesStatsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and
     * security policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPoliciesStatsRequest.Builder} avoiding the need
     * to create one manually via {@link GetPoliciesStatsRequest#builder()}
     * </p>
     *
     * @param getPoliciesStatsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetPoliciesStats operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetPoliciesStats
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetPoliciesStats"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetPoliciesStatsResponse> getPoliciesStats(
            Consumer<GetPoliciesStatsRequest.Builder> getPoliciesStatsRequest) {
        return getPoliciesStats(GetPoliciesStatsRequest.builder().applyMutation(getPoliciesStatsRequest).build());
    }

    /**
     * <p>
     * Returns information about an OpenSearch Serverless security configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param getSecurityConfigRequest
     * @return A Java Future containing the result of the GetSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSecurityConfigResponse> getSecurityConfig(GetSecurityConfigRequest getSecurityConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an OpenSearch Serverless security configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigRequest.Builder} avoiding the need
     * to create one manually via {@link GetSecurityConfigRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSecurityConfigResponse> getSecurityConfig(
            Consumer<GetSecurityConfigRequest.Builder> getSecurityConfigRequest) {
        return getSecurityConfig(GetSecurityConfigRequest.builder().applyMutation(getSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param getSecurityPolicyRequest
     * @return A Java Future containing the result of the GetSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSecurityPolicyResponse> getSecurityPolicy(GetSecurityPolicyRequest getSecurityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param getSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.GetSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetSecurityPolicyResponse> getSecurityPolicy(
            Consumer<GetSecurityPolicyRequest.Builder> getSecurityPolicyRequest) {
        return getSecurityPolicy(GetSecurityPolicyRequest.builder().applyMutation(getSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of OpenSearch Serverless access policies.
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return A Java Future containing the result of the ListAccessPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPoliciesResponse> listAccessPolicies(ListAccessPoliciesRequest listAccessPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of OpenSearch Serverless access policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAccessPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAccessPoliciesResponse> listAccessPolicies(
            Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest) {
        return listAccessPolicies(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesPublisher listAccessPoliciesPaginator(ListAccessPoliciesRequest listAccessPoliciesRequest) {
        return new ListAccessPoliciesPublisher(this, listAccessPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesPublisher publisher = client.listAccessPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesPublisher listAccessPoliciesPaginator(
            Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest) {
        return listAccessPoliciesPaginator(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all OpenSearch Serverless collections. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <note>
     * <p>
     * Make sure to include an empty request body {} if you don't include any collection filters in the request.
     * </p>
     * </note>
     *
     * @param listCollectionsRequest
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollectionsResponse> listCollections(ListCollectionsRequest listCollectionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all OpenSearch Serverless collections. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <note>
     * <p>
     * Make sure to include an empty request body {} if you don't include any collection filters in the request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCollectionsRequest#builder()}
     * </p>
     *
     * @param listCollectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListCollections operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListCollectionsResponse> listCollections(
            Consumer<ListCollectionsRequest.Builder> listCollectionsRequest) {
        return listCollections(ListCollectionsRequest.builder().applyMutation(listCollectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollectionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectionsPublisher listCollectionsPaginator(ListCollectionsRequest listCollectionsRequest) {
        return new ListCollectionsPublisher(this, listCollectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsPublisher publisher = client.listCollectionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCollectionsRequest#builder()}
     * </p>
     *
     * @param listCollectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectionsPublisher listCollectionsPaginator(Consumer<ListCollectionsRequest.Builder> listCollectionsRequest) {
        return listCollectionsPaginator(ListCollectionsRequest.builder().applyMutation(listCollectionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     * @return A Java Future containing the result of the ListLifecyclePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLifecyclePoliciesResponse> listLifecyclePolicies(
            ListLifecyclePoliciesRequest listLifecyclePoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLifecyclePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListLifecyclePoliciesRequest#builder()}
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListLifecyclePolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListLifecyclePoliciesResponse> listLifecyclePolicies(
            Consumer<ListLifecyclePoliciesRequest.Builder> listLifecyclePoliciesRequest) {
        return listLifecyclePolicies(ListLifecyclePoliciesRequest.builder().applyMutation(listLifecyclePoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesPublisher publisher = client.listLifecyclePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesPublisher publisher = client.listLifecyclePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLifecyclePoliciesPublisher listLifecyclePoliciesPaginator(
            ListLifecyclePoliciesRequest listLifecyclePoliciesRequest) {
        return new ListLifecyclePoliciesPublisher(this, listLifecyclePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesPublisher publisher = client.listLifecyclePoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesPublisher publisher = client.listLifecyclePoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLifecyclePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListLifecyclePoliciesRequest#builder()}
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLifecyclePoliciesPublisher listLifecyclePoliciesPaginator(
            Consumer<ListLifecyclePoliciesRequest.Builder> listLifecyclePoliciesRequest) {
        return listLifecyclePoliciesPaginator(ListLifecyclePoliciesRequest.builder().applyMutation(listLifecyclePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param listSecurityConfigsRequest
     * @return A Java Future containing the result of the ListSecurityConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSecurityConfigsResponse> listSecurityConfigs(
            ListSecurityConfigsRequest listSecurityConfigsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityConfigsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSecurityConfigs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSecurityConfigsResponse> listSecurityConfigs(
            Consumer<ListSecurityConfigsRequest.Builder> listSecurityConfigsRequest) {
        return listSecurityConfigs(ListSecurityConfigsRequest.builder().applyMutation(listSecurityConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsPublisher publisher = client.listSecurityConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsPublisher publisher = client.listSecurityConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityConfigsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigsPublisher listSecurityConfigsPaginator(ListSecurityConfigsRequest listSecurityConfigsRequest) {
        return new ListSecurityConfigsPublisher(this, listSecurityConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsPublisher publisher = client.listSecurityConfigsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsPublisher publisher = client.listSecurityConfigsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityConfigsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigsPublisher listSecurityConfigsPaginator(
            Consumer<ListSecurityConfigsRequest.Builder> listSecurityConfigsRequest) {
        return listSecurityConfigsPaginator(ListSecurityConfigsRequest.builder().applyMutation(listSecurityConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security policies.
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return A Java Future containing the result of the ListSecurityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSecurityPoliciesResponse> listSecurityPolicies(
            ListSecurityPoliciesRequest listSecurityPoliciesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListSecurityPolicies operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListSecurityPoliciesResponse> listSecurityPolicies(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) {
        return listSecurityPolicies(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityPoliciesPublisher listSecurityPoliciesPaginator(ListSecurityPoliciesRequest listSecurityPoliciesRequest) {
        return new ListSecurityPoliciesPublisher(this, listSecurityPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesPublisher publisher = client.listSecurityPoliciesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityPoliciesPublisher listSecurityPoliciesPaginator(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) {
        return listSecurityPoliciesPaginator(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the tags for an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the tags for an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param listVpcEndpointsRequest
     * @return A Java Future containing the result of the ListVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVpcEndpointsResponse> listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListVpcEndpoints operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListVpcEndpointsResponse> listVpcEndpoints(
            Consumer<ListVpcEndpointsRequest.Builder> listVpcEndpointsRequest) {
        return listVpcEndpoints(ListVpcEndpointsRequest.builder().applyMutation(listVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsPublisher publisher = client.listVpcEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsPublisher publisher = client.listVpcEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVpcEndpointsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointsPublisher listVpcEndpointsPaginator(ListVpcEndpointsRequest listVpcEndpointsRequest) {
        return new ListVpcEndpointsPublisher(this, listVpcEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsPublisher publisher = client.listVpcEndpointsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsPublisher publisher = client.listVpcEndpointsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointsPublisher listVpcEndpointsPaginator(Consumer<ListVpcEndpointsRequest.Builder> listVpcEndpointsRequest) {
        return listVpcEndpointsPaginator(ListVpcEndpointsRequest.builder().applyMutation(listVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Associates tags with an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates tags with an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateAccessPolicyRequest
     * @return A Java Future containing the result of the UpdateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessPolicyResponse> updateAccessPolicy(UpdateAccessPolicyRequest updateAccessPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param updateAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAccessPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccessPolicyResponse> updateAccessPolicy(
            Consumer<UpdateAccessPolicyRequest.Builder> updateAccessPolicyRequest) {
        return updateAccessPolicy(UpdateAccessPolicyRequest.builder().applyMutation(updateAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html">Managing
     * capacity limits for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateAccountSettingsRequest
     * @return A Java Future containing the result of the UpdateAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(
            UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html">Managing
     * capacity limits for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccountSettingsRequest#builder()}
     * </p>
     *
     * @param updateAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(
            Consumer<UpdateAccountSettingsRequest.Builder> updateAccountSettingsRequest) {
        return updateAccountSettings(UpdateAccountSettingsRequest.builder().applyMutation(updateAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless collection.
     * </p>
     *
     * @param updateCollectionRequest
     * @return A Java Future containing the result of the UpdateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCollectionResponse> updateCollection(UpdateCollectionRequest updateCollectionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCollectionRequest#builder()}
     * </p>
     *
     * @param updateCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateCollection operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateCollectionResponse> updateCollection(
            Consumer<UpdateCollectionRequest.Builder> updateCollectionRequest) {
        return updateCollection(UpdateCollectionRequest.builder().applyMutation(updateCollectionRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update"
     * >Updating data lifecycle policies</a>.
     * </p>
     *
     * @param updateLifecyclePolicyRequest
     * @return A Java Future containing the result of the UpdateLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLifecyclePolicyResponse> updateLifecyclePolicy(
            UpdateLifecyclePolicyRequest updateLifecyclePolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update"
     * >Updating data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param updateLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateLifecyclePolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLifecyclePolicyResponse> updateLifecyclePolicy(
            Consumer<UpdateLifecyclePolicyRequest.Builder> updateLifecyclePolicyRequest) {
        return updateLifecyclePolicy(UpdateLifecyclePolicyRequest.builder().applyMutation(updateLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Updates a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateSecurityConfigRequest
     * @return A Java Future containing the result of the UpdateSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSecurityConfigResponse> updateSecurityConfig(
            UpdateSecurityConfigRequest updateSecurityConfigRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSecurityConfigRequest#builder()}
     * </p>
     *
     * @param updateSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSecurityConfig operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSecurityConfigResponse> updateSecurityConfig(
            Consumer<UpdateSecurityConfigRequest.Builder> updateSecurityConfigRequest) {
        return updateSecurityConfig(UpdateSecurityConfigRequest.builder().applyMutation(updateSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateSecurityPolicyRequest
     * @return A Java Future containing the result of the UpdateSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSecurityPolicyResponse> updateSecurityPolicy(
            UpdateSecurityPolicyRequest updateSecurityPolicyRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param updateSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSecurityPolicy operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ResourceNotFoundException Thrown when accessing or deleting a resource that does not exist.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>ServiceQuotaExceededException Thrown when you attempt to create more resources than the service
     *         allows based on service quotas.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSecurityPolicyResponse> updateSecurityPolicy(
            Consumer<UpdateSecurityPolicyRequest.Builder> updateSecurityPolicyRequest) {
        return updateSecurityPolicy(UpdateSecurityPolicyRequest.builder().applyMutation(updateSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param updateVpcEndpointRequest
     * @return A Java Future containing the result of the UpdateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVpcEndpointResponse> updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param updateVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateVpcEndpoint operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions. The exception returned is wrapped with CompletionException, so you need to invoke
     *         {@link Throwable#getCause} to retrieve the underlying exception.
     *         <ul>
     *         <li>InternalServerException Thrown when an error internal to the service occurs while processing a
     *         request.</li>
     *         <li>ConflictException When creating a resource, thrown when a resource with the same name already exists
     *         or is being created. When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED
     *         state.</li>
     *         <li>ValidationException Thrown when the HTTP request contains invalid input or is missing required input.
     *         </li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>OpenSearchServerlessException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample OpenSearchServerlessAsyncClient.UpdateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateVpcEndpointResponse> updateVpcEndpoint(
            Consumer<UpdateVpcEndpointRequest.Builder> updateVpcEndpointRequest) {
        return updateVpcEndpoint(UpdateVpcEndpointRequest.builder().applyMutation(updateVpcEndpointRequest).build());
    }

    @Override
    default OpenSearchServerlessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link OpenSearchServerlessAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OpenSearchServerlessAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OpenSearchServerlessAsyncClient}.
     */
    static OpenSearchServerlessAsyncClientBuilder builder() {
        return new DefaultOpenSearchServerlessAsyncClientBuilder();
    }
}
