/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteVpcEndpointResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<DeleteVpcEndpointResponse.Builder, DeleteVpcEndpointResponse> {
    private static final SdkField<DeleteVpcEndpointDetail> DELETE_VPC_ENDPOINT_DETAIL_FIELD = SdkField
            .<DeleteVpcEndpointDetail> builder(MarshallingType.SDK_POJO).memberName("deleteVpcEndpointDetail")
            .getter(getter(DeleteVpcEndpointResponse::deleteVpcEndpointDetail)).setter(setter(Builder::deleteVpcEndpointDetail))
            .constructor(DeleteVpcEndpointDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deleteVpcEndpointDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(DELETE_VPC_ENDPOINT_DETAIL_FIELD));

    private final DeleteVpcEndpointDetail deleteVpcEndpointDetail;

    private DeleteVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.deleteVpcEndpointDetail = builder.deleteVpcEndpointDetail;
    }

    /**
     * <p>
     * Details about the deleted endpoint.
     * </p>
     * 
     * @return Details about the deleted endpoint.
     */
    public final DeleteVpcEndpointDetail deleteVpcEndpointDetail() {
        return deleteVpcEndpointDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(deleteVpcEndpointDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteVpcEndpointResponse)) {
            return false;
        }
        DeleteVpcEndpointResponse other = (DeleteVpcEndpointResponse) obj;
        return Objects.equals(deleteVpcEndpointDetail(), other.deleteVpcEndpointDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteVpcEndpointResponse").add("DeleteVpcEndpointDetail", deleteVpcEndpointDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "deleteVpcEndpointDetail":
            return Optional.ofNullable(clazz.cast(deleteVpcEndpointDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteVpcEndpointResponse, T> g) {
        return obj -> g.apply((DeleteVpcEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DeleteVpcEndpointResponse> {
        /**
         * <p>
         * Details about the deleted endpoint.
         * </p>
         * 
         * @param deleteVpcEndpointDetail
         *        Details about the deleted endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deleteVpcEndpointDetail(DeleteVpcEndpointDetail deleteVpcEndpointDetail);

        /**
         * <p>
         * Details about the deleted endpoint.
         * </p>
         * This is a convenience method that creates an instance of the {@link DeleteVpcEndpointDetail.Builder} avoiding
         * the need to create one manually via {@link DeleteVpcEndpointDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DeleteVpcEndpointDetail.Builder#build()} is called immediately
         * and its result is passed to {@link #deleteVpcEndpointDetail(DeleteVpcEndpointDetail)}.
         * 
         * @param deleteVpcEndpointDetail
         *        a consumer that will call methods on {@link DeleteVpcEndpointDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #deleteVpcEndpointDetail(DeleteVpcEndpointDetail)
         */
        default Builder deleteVpcEndpointDetail(Consumer<DeleteVpcEndpointDetail.Builder> deleteVpcEndpointDetail) {
            return deleteVpcEndpointDetail(DeleteVpcEndpointDetail.builder().applyMutation(deleteVpcEndpointDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private DeleteVpcEndpointDetail deleteVpcEndpointDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteVpcEndpointResponse model) {
            super(model);
            deleteVpcEndpointDetail(model.deleteVpcEndpointDetail);
        }

        public final DeleteVpcEndpointDetail.Builder getDeleteVpcEndpointDetail() {
            return deleteVpcEndpointDetail != null ? deleteVpcEndpointDetail.toBuilder() : null;
        }

        public final void setDeleteVpcEndpointDetail(DeleteVpcEndpointDetail.BuilderImpl deleteVpcEndpointDetail) {
            this.deleteVpcEndpointDetail = deleteVpcEndpointDetail != null ? deleteVpcEndpointDetail.build() : null;
        }

        @Override
        public final Builder deleteVpcEndpointDetail(DeleteVpcEndpointDetail deleteVpcEndpointDetail) {
            this.deleteVpcEndpointDetail = deleteVpcEndpointDetail;
            return this;
        }

        @Override
        public DeleteVpcEndpointResponse build() {
            return new DeleteVpcEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
