/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.opensearchserverless.model.AccessPolicyStats;
import software.amazon.awssdk.services.opensearchserverless.model.LifecyclePolicyStats;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessResponse;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigStats;
import software.amazon.awssdk.services.opensearchserverless.model.SecurityPolicyStats;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetPoliciesStatsResponse
extends OpenSearchServerlessResponse
implements ToCopyableBuilder<Builder, GetPoliciesStatsResponse> {
    private static final SdkField<AccessPolicyStats> ACCESS_POLICY_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("AccessPolicyStats").getter(GetPoliciesStatsResponse.getter(GetPoliciesStatsResponse::accessPolicyStats)).setter(GetPoliciesStatsResponse.setter(Builder::accessPolicyStats)).constructor(AccessPolicyStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessPolicyStats").build()}).build();
    private static final SdkField<LifecyclePolicyStats> LIFECYCLE_POLICY_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LifecyclePolicyStats").getter(GetPoliciesStatsResponse.getter(GetPoliciesStatsResponse::lifecyclePolicyStats)).setter(GetPoliciesStatsResponse.setter(Builder::lifecyclePolicyStats)).constructor(LifecyclePolicyStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LifecyclePolicyStats").build()}).build();
    private static final SdkField<SecurityConfigStats> SECURITY_CONFIG_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityConfigStats").getter(GetPoliciesStatsResponse.getter(GetPoliciesStatsResponse::securityConfigStats)).setter(GetPoliciesStatsResponse.setter(Builder::securityConfigStats)).constructor(SecurityConfigStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfigStats").build()}).build();
    private static final SdkField<SecurityPolicyStats> SECURITY_POLICY_STATS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SecurityPolicyStats").getter(GetPoliciesStatsResponse.getter(GetPoliciesStatsResponse::securityPolicyStats)).setter(GetPoliciesStatsResponse.setter(Builder::securityPolicyStats)).constructor(SecurityPolicyStats::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityPolicyStats").build()}).build();
    private static final SdkField<Long> TOTAL_POLICY_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("TotalPolicyCount").getter(GetPoliciesStatsResponse.getter(GetPoliciesStatsResponse::totalPolicyCount)).setter(GetPoliciesStatsResponse.setter(Builder::totalPolicyCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TotalPolicyCount").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_POLICY_STATS_FIELD, LIFECYCLE_POLICY_STATS_FIELD, SECURITY_CONFIG_STATS_FIELD, SECURITY_POLICY_STATS_FIELD, TOTAL_POLICY_COUNT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetPoliciesStatsResponse.memberNameToFieldInitializer();
    private final AccessPolicyStats accessPolicyStats;
    private final LifecyclePolicyStats lifecyclePolicyStats;
    private final SecurityConfigStats securityConfigStats;
    private final SecurityPolicyStats securityPolicyStats;
    private final Long totalPolicyCount;

    private GetPoliciesStatsResponse(BuilderImpl builder) {
        super(builder);
        this.accessPolicyStats = builder.accessPolicyStats;
        this.lifecyclePolicyStats = builder.lifecyclePolicyStats;
        this.securityConfigStats = builder.securityConfigStats;
        this.securityPolicyStats = builder.securityPolicyStats;
        this.totalPolicyCount = builder.totalPolicyCount;
    }

    public final AccessPolicyStats accessPolicyStats() {
        return this.accessPolicyStats;
    }

    public final LifecyclePolicyStats lifecyclePolicyStats() {
        return this.lifecyclePolicyStats;
    }

    public final SecurityConfigStats securityConfigStats() {
        return this.securityConfigStats;
    }

    public final SecurityPolicyStats securityPolicyStats() {
        return this.securityPolicyStats;
    }

    public final Long totalPolicyCount() {
        return this.totalPolicyCount;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessPolicyStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfigStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityPolicyStats());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalPolicyCount());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetPoliciesStatsResponse)) {
            return false;
        }
        GetPoliciesStatsResponse other = (GetPoliciesStatsResponse)((Object)obj);
        return Objects.equals(this.accessPolicyStats(), other.accessPolicyStats()) && Objects.equals(this.lifecyclePolicyStats(), other.lifecyclePolicyStats()) && Objects.equals(this.securityConfigStats(), other.securityConfigStats()) && Objects.equals(this.securityPolicyStats(), other.securityPolicyStats()) && Objects.equals(this.totalPolicyCount(), other.totalPolicyCount());
    }

    public final String toString() {
        return ToString.builder((String)"GetPoliciesStatsResponse").add("AccessPolicyStats", (Object)this.accessPolicyStats()).add("LifecyclePolicyStats", (Object)this.lifecyclePolicyStats()).add("SecurityConfigStats", (Object)this.securityConfigStats()).add("SecurityPolicyStats", (Object)this.securityPolicyStats()).add("TotalPolicyCount", (Object)this.totalPolicyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessPolicyStats": {
                return Optional.ofNullable(clazz.cast(this.accessPolicyStats()));
            }
            case "LifecyclePolicyStats": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyStats()));
            }
            case "SecurityConfigStats": {
                return Optional.ofNullable(clazz.cast(this.securityConfigStats()));
            }
            case "SecurityPolicyStats": {
                return Optional.ofNullable(clazz.cast(this.securityPolicyStats()));
            }
            case "TotalPolicyCount": {
                return Optional.ofNullable(clazz.cast(this.totalPolicyCount()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccessPolicyStats", ACCESS_POLICY_STATS_FIELD);
        map.put("LifecyclePolicyStats", LIFECYCLE_POLICY_STATS_FIELD);
        map.put("SecurityConfigStats", SECURITY_CONFIG_STATS_FIELD);
        map.put("SecurityPolicyStats", SECURITY_POLICY_STATS_FIELD);
        map.put("TotalPolicyCount", TOTAL_POLICY_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetPoliciesStatsResponse, T> g) {
        return obj -> g.apply((GetPoliciesStatsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessResponse.BuilderImpl
    implements Builder {
        private AccessPolicyStats accessPolicyStats;
        private LifecyclePolicyStats lifecyclePolicyStats;
        private SecurityConfigStats securityConfigStats;
        private SecurityPolicyStats securityPolicyStats;
        private Long totalPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(GetPoliciesStatsResponse model) {
            super(model);
            this.accessPolicyStats(model.accessPolicyStats);
            this.lifecyclePolicyStats(model.lifecyclePolicyStats);
            this.securityConfigStats(model.securityConfigStats);
            this.securityPolicyStats(model.securityPolicyStats);
            this.totalPolicyCount(model.totalPolicyCount);
        }

        public final AccessPolicyStats.Builder getAccessPolicyStats() {
            return this.accessPolicyStats != null ? this.accessPolicyStats.toBuilder() : null;
        }

        public final void setAccessPolicyStats(AccessPolicyStats.BuilderImpl accessPolicyStats) {
            this.accessPolicyStats = accessPolicyStats != null ? accessPolicyStats.build() : null;
        }

        @Override
        public final Builder accessPolicyStats(AccessPolicyStats accessPolicyStats) {
            this.accessPolicyStats = accessPolicyStats;
            return this;
        }

        public final LifecyclePolicyStats.Builder getLifecyclePolicyStats() {
            return this.lifecyclePolicyStats != null ? this.lifecyclePolicyStats.toBuilder() : null;
        }

        public final void setLifecyclePolicyStats(LifecyclePolicyStats.BuilderImpl lifecyclePolicyStats) {
            this.lifecyclePolicyStats = lifecyclePolicyStats != null ? lifecyclePolicyStats.build() : null;
        }

        @Override
        public final Builder lifecyclePolicyStats(LifecyclePolicyStats lifecyclePolicyStats) {
            this.lifecyclePolicyStats = lifecyclePolicyStats;
            return this;
        }

        public final SecurityConfigStats.Builder getSecurityConfigStats() {
            return this.securityConfigStats != null ? this.securityConfigStats.toBuilder() : null;
        }

        public final void setSecurityConfigStats(SecurityConfigStats.BuilderImpl securityConfigStats) {
            this.securityConfigStats = securityConfigStats != null ? securityConfigStats.build() : null;
        }

        @Override
        public final Builder securityConfigStats(SecurityConfigStats securityConfigStats) {
            this.securityConfigStats = securityConfigStats;
            return this;
        }

        public final SecurityPolicyStats.Builder getSecurityPolicyStats() {
            return this.securityPolicyStats != null ? this.securityPolicyStats.toBuilder() : null;
        }

        public final void setSecurityPolicyStats(SecurityPolicyStats.BuilderImpl securityPolicyStats) {
            this.securityPolicyStats = securityPolicyStats != null ? securityPolicyStats.build() : null;
        }

        @Override
        public final Builder securityPolicyStats(SecurityPolicyStats securityPolicyStats) {
            this.securityPolicyStats = securityPolicyStats;
            return this;
        }

        public final Long getTotalPolicyCount() {
            return this.totalPolicyCount;
        }

        public final void setTotalPolicyCount(Long totalPolicyCount) {
            this.totalPolicyCount = totalPolicyCount;
        }

        @Override
        public final Builder totalPolicyCount(Long totalPolicyCount) {
            this.totalPolicyCount = totalPolicyCount;
            return this;
        }

        @Override
        public GetPoliciesStatsResponse build() {
            return new GetPoliciesStatsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetPoliciesStatsResponse> {
        public Builder accessPolicyStats(AccessPolicyStats var1);

        default public Builder accessPolicyStats(Consumer<AccessPolicyStats.Builder> accessPolicyStats) {
            return this.accessPolicyStats((AccessPolicyStats)((AccessPolicyStats.Builder)AccessPolicyStats.builder().applyMutation(accessPolicyStats)).build());
        }

        public Builder lifecyclePolicyStats(LifecyclePolicyStats var1);

        default public Builder lifecyclePolicyStats(Consumer<LifecyclePolicyStats.Builder> lifecyclePolicyStats) {
            return this.lifecyclePolicyStats((LifecyclePolicyStats)((LifecyclePolicyStats.Builder)LifecyclePolicyStats.builder().applyMutation(lifecyclePolicyStats)).build());
        }

        public Builder securityConfigStats(SecurityConfigStats var1);

        default public Builder securityConfigStats(Consumer<SecurityConfigStats.Builder> securityConfigStats) {
            return this.securityConfigStats((SecurityConfigStats)((SecurityConfigStats.Builder)SecurityConfigStats.builder().applyMutation(securityConfigStats)).build());
        }

        public Builder securityPolicyStats(SecurityPolicyStats var1);

        default public Builder securityPolicyStats(Consumer<SecurityPolicyStats.Builder> securityPolicyStats) {
            return this.securityPolicyStats((SecurityPolicyStats)((SecurityPolicyStats.Builder)SecurityPolicyStats.builder().applyMutation(securityPolicyStats)).build());
        }

        public Builder totalPolicyCount(Long var1);
    }
}

