/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * OpenSearch Serverless-related information for the current account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettingsDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<AccountSettingsDetail.Builder, AccountSettingsDetail> {
    private static final SdkField<CapacityLimits> CAPACITY_LIMITS_FIELD = SdkField
            .<CapacityLimits> builder(MarshallingType.SDK_POJO).memberName("capacityLimits")
            .getter(getter(AccountSettingsDetail::capacityLimits)).setter(setter(Builder::capacityLimits))
            .constructor(CapacityLimits::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityLimits").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CAPACITY_LIMITS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CapacityLimits capacityLimits;

    private AccountSettingsDetail(BuilderImpl builder) {
        this.capacityLimits = builder.capacityLimits;
    }

    /**
     * Returns the value of the CapacityLimits property for this object.
     * 
     * @return The value of the CapacityLimits property for this object.
     */
    public final CapacityLimits capacityLimits() {
        return capacityLimits;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(capacityLimits());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettingsDetail)) {
            return false;
        }
        AccountSettingsDetail other = (AccountSettingsDetail) obj;
        return Objects.equals(capacityLimits(), other.capacityLimits());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSettingsDetail").add("CapacityLimits", capacityLimits()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "capacityLimits":
            return Optional.ofNullable(clazz.cast(capacityLimits()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("capacityLimits", CAPACITY_LIMITS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccountSettingsDetail, T> g) {
        return obj -> g.apply((AccountSettingsDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettingsDetail> {
        /**
         * Sets the value of the CapacityLimits property for this object.
         *
         * @param capacityLimits
         *        The new value for the CapacityLimits property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capacityLimits(CapacityLimits capacityLimits);

        /**
         * Sets the value of the CapacityLimits property for this object.
         *
         * This is a convenience method that creates an instance of the {@link CapacityLimits.Builder} avoiding the need
         * to create one manually via {@link CapacityLimits#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CapacityLimits.Builder#build()} is called immediately and its
         * result is passed to {@link #capacityLimits(CapacityLimits)}.
         * 
         * @param capacityLimits
         *        a consumer that will call methods on {@link CapacityLimits.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capacityLimits(CapacityLimits)
         */
        default Builder capacityLimits(Consumer<CapacityLimits.Builder> capacityLimits) {
            return capacityLimits(CapacityLimits.builder().applyMutation(capacityLimits).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CapacityLimits capacityLimits;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettingsDetail model) {
            capacityLimits(model.capacityLimits);
        }

        public final CapacityLimits.Builder getCapacityLimits() {
            return capacityLimits != null ? capacityLimits.toBuilder() : null;
        }

        public final void setCapacityLimits(CapacityLimits.BuilderImpl capacityLimits) {
            this.capacityLimits = capacityLimits != null ? capacityLimits.build() : null;
        }

        @Override
        public final Builder capacityLimits(CapacityLimits capacityLimits) {
            this.capacityLimits = capacityLimits;
            return this;
        }

        @Override
        public AccountSettingsDetail build() {
            return new AccountSettingsDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
