/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetCollectionResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<BatchGetCollectionResponse.Builder, BatchGetCollectionResponse> {
    private static final SdkField<List<CollectionDetail>> COLLECTION_DETAILS_FIELD = SdkField
            .<List<CollectionDetail>> builder(MarshallingType.LIST)
            .memberName("collectionDetails")
            .getter(getter(BatchGetCollectionResponse::collectionDetails))
            .setter(setter(Builder::collectionDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollectionDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollectionDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<CollectionErrorDetail>> COLLECTION_ERROR_DETAILS_FIELD = SdkField
            .<List<CollectionErrorDetail>> builder(MarshallingType.LIST)
            .memberName("collectionErrorDetails")
            .getter(getter(BatchGetCollectionResponse::collectionErrorDetails))
            .setter(setter(Builder::collectionErrorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("collectionErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CollectionErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(CollectionErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLLECTION_DETAILS_FIELD,
            COLLECTION_ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CollectionDetail> collectionDetails;

    private final List<CollectionErrorDetail> collectionErrorDetails;

    private BatchGetCollectionResponse(BuilderImpl builder) {
        super(builder);
        this.collectionDetails = builder.collectionDetails;
        this.collectionErrorDetails = builder.collectionErrorDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollectionDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCollectionDetails() {
        return collectionDetails != null && !(collectionDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about each collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollectionDetails} method.
     * </p>
     * 
     * @return Details about each collection.
     */
    public final List<CollectionDetail> collectionDetails() {
        return collectionDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the CollectionErrorDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasCollectionErrorDetails() {
        return collectionErrorDetails != null && !(collectionErrorDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error information for the request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCollectionErrorDetails} method.
     * </p>
     * 
     * @return Error information for the request.
     */
    public final List<CollectionErrorDetail> collectionErrorDetails() {
        return collectionErrorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCollectionDetails() ? collectionDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCollectionErrorDetails() ? collectionErrorDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetCollectionResponse)) {
            return false;
        }
        BatchGetCollectionResponse other = (BatchGetCollectionResponse) obj;
        return hasCollectionDetails() == other.hasCollectionDetails()
                && Objects.equals(collectionDetails(), other.collectionDetails())
                && hasCollectionErrorDetails() == other.hasCollectionErrorDetails()
                && Objects.equals(collectionErrorDetails(), other.collectionErrorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetCollectionResponse")
                .add("CollectionDetails", hasCollectionDetails() ? collectionDetails() : null)
                .add("CollectionErrorDetails", hasCollectionErrorDetails() ? collectionErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "collectionDetails":
            return Optional.ofNullable(clazz.cast(collectionDetails()));
        case "collectionErrorDetails":
            return Optional.ofNullable(clazz.cast(collectionErrorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("collectionDetails", COLLECTION_DETAILS_FIELD);
        map.put("collectionErrorDetails", COLLECTION_ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetCollectionResponse, T> g) {
        return obj -> g.apply((BatchGetCollectionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetCollectionResponse> {
        /**
         * <p>
         * Details about each collection.
         * </p>
         * 
         * @param collectionDetails
         *        Details about each collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionDetails(Collection<CollectionDetail> collectionDetails);

        /**
         * <p>
         * Details about each collection.
         * </p>
         * 
         * @param collectionDetails
         *        Details about each collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionDetails(CollectionDetail... collectionDetails);

        /**
         * <p>
         * Details about each collection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail.Builder#build()} is called
         * immediately and its result is passed to {@link #collectionDetails(List<CollectionDetail>)}.
         * 
         * @param collectionDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectionDetails(java.util.Collection<CollectionDetail>)
         */
        Builder collectionDetails(Consumer<CollectionDetail.Builder>... collectionDetails);

        /**
         * <p>
         * Error information for the request.
         * </p>
         * 
         * @param collectionErrorDetails
         *        Error information for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionErrorDetails(Collection<CollectionErrorDetail> collectionErrorDetails);

        /**
         * <p>
         * Error information for the request.
         * </p>
         * 
         * @param collectionErrorDetails
         *        Error information for the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder collectionErrorDetails(CollectionErrorDetail... collectionErrorDetails);

        /**
         * <p>
         * Error information for the request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail.Builder#build()} is
         * called immediately and its result is passed to {@link #collectionErrorDetails(List<CollectionErrorDetail>)}.
         * 
         * @param collectionErrorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.CollectionErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #collectionErrorDetails(java.util.Collection<CollectionErrorDetail>)
         */
        Builder collectionErrorDetails(Consumer<CollectionErrorDetail.Builder>... collectionErrorDetails);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private List<CollectionDetail> collectionDetails = DefaultSdkAutoConstructList.getInstance();

        private List<CollectionErrorDetail> collectionErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetCollectionResponse model) {
            super(model);
            collectionDetails(model.collectionDetails);
            collectionErrorDetails(model.collectionErrorDetails);
        }

        public final List<CollectionDetail.Builder> getCollectionDetails() {
            List<CollectionDetail.Builder> result = CollectionDetailsCopier.copyToBuilder(this.collectionDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectionDetails(Collection<CollectionDetail.BuilderImpl> collectionDetails) {
            this.collectionDetails = CollectionDetailsCopier.copyFromBuilder(collectionDetails);
        }

        @Override
        public final Builder collectionDetails(Collection<CollectionDetail> collectionDetails) {
            this.collectionDetails = CollectionDetailsCopier.copy(collectionDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionDetails(CollectionDetail... collectionDetails) {
            collectionDetails(Arrays.asList(collectionDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionDetails(Consumer<CollectionDetail.Builder>... collectionDetails) {
            collectionDetails(Stream.of(collectionDetails).map(c -> CollectionDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<CollectionErrorDetail.Builder> getCollectionErrorDetails() {
            List<CollectionErrorDetail.Builder> result = CollectionErrorDetailsCopier.copyToBuilder(this.collectionErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCollectionErrorDetails(Collection<CollectionErrorDetail.BuilderImpl> collectionErrorDetails) {
            this.collectionErrorDetails = CollectionErrorDetailsCopier.copyFromBuilder(collectionErrorDetails);
        }

        @Override
        public final Builder collectionErrorDetails(Collection<CollectionErrorDetail> collectionErrorDetails) {
            this.collectionErrorDetails = CollectionErrorDetailsCopier.copy(collectionErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionErrorDetails(CollectionErrorDetail... collectionErrorDetails) {
            collectionErrorDetails(Arrays.asList(collectionErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder collectionErrorDetails(Consumer<CollectionErrorDetail.Builder>... collectionErrorDetails) {
            collectionErrorDetails(Stream.of(collectionErrorDetails)
                    .map(c -> CollectionErrorDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetCollectionResponse build() {
            return new BatchGetCollectionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
