/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetEffectiveLifecyclePolicyResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<BatchGetEffectiveLifecyclePolicyResponse.Builder, BatchGetEffectiveLifecyclePolicyResponse> {
    private static final SdkField<List<EffectiveLifecyclePolicyDetail>> EFFECTIVE_LIFECYCLE_POLICY_DETAILS_FIELD = SdkField
            .<List<EffectiveLifecyclePolicyDetail>> builder(MarshallingType.LIST)
            .memberName("effectiveLifecyclePolicyDetails")
            .getter(getter(BatchGetEffectiveLifecyclePolicyResponse::effectiveLifecyclePolicyDetails))
            .setter(setter(Builder::effectiveLifecyclePolicyDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("effectiveLifecyclePolicyDetails")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EffectiveLifecyclePolicyDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(EffectiveLifecyclePolicyDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<EffectiveLifecyclePolicyErrorDetail>> EFFECTIVE_LIFECYCLE_POLICY_ERROR_DETAILS_FIELD = SdkField
            .<List<EffectiveLifecyclePolicyErrorDetail>> builder(MarshallingType.LIST)
            .memberName("effectiveLifecyclePolicyErrorDetails")
            .getter(getter(BatchGetEffectiveLifecyclePolicyResponse::effectiveLifecyclePolicyErrorDetails))
            .setter(setter(Builder::effectiveLifecyclePolicyErrorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("effectiveLifecyclePolicyErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<EffectiveLifecyclePolicyErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(EffectiveLifecyclePolicyErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EFFECTIVE_LIFECYCLE_POLICY_DETAILS_FIELD, EFFECTIVE_LIFECYCLE_POLICY_ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails;

    private final List<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails;

    private BatchGetEffectiveLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.effectiveLifecyclePolicyDetails = builder.effectiveLifecyclePolicyDetails;
        this.effectiveLifecyclePolicyErrorDetails = builder.effectiveLifecyclePolicyErrorDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectiveLifecyclePolicyDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEffectiveLifecyclePolicyDetails() {
        return effectiveLifecyclePolicyDetails != null && !(effectiveLifecyclePolicyDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of lifecycle policies applied to the OpenSearch Serverless indexes.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectiveLifecyclePolicyDetails}
     * method.
     * </p>
     * 
     * @return A list of lifecycle policies applied to the OpenSearch Serverless indexes.
     */
    public final List<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails() {
        return effectiveLifecyclePolicyDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the EffectiveLifecyclePolicyErrorDetails
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasEffectiveLifecyclePolicyErrorDetails() {
        return effectiveLifecyclePolicyErrorDetails != null
                && !(effectiveLifecyclePolicyErrorDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resources for which retrieval failed.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasEffectiveLifecyclePolicyErrorDetails}
     * method.
     * </p>
     * 
     * @return A list of resources for which retrieval failed.
     */
    public final List<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails() {
        return effectiveLifecyclePolicyErrorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEffectiveLifecyclePolicyDetails() ? effectiveLifecyclePolicyDetails() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasEffectiveLifecyclePolicyErrorDetails() ? effectiveLifecyclePolicyErrorDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetEffectiveLifecyclePolicyResponse)) {
            return false;
        }
        BatchGetEffectiveLifecyclePolicyResponse other = (BatchGetEffectiveLifecyclePolicyResponse) obj;
        return hasEffectiveLifecyclePolicyDetails() == other.hasEffectiveLifecyclePolicyDetails()
                && Objects.equals(effectiveLifecyclePolicyDetails(), other.effectiveLifecyclePolicyDetails())
                && hasEffectiveLifecyclePolicyErrorDetails() == other.hasEffectiveLifecyclePolicyErrorDetails()
                && Objects.equals(effectiveLifecyclePolicyErrorDetails(), other.effectiveLifecyclePolicyErrorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("BatchGetEffectiveLifecyclePolicyResponse")
                .add("EffectiveLifecyclePolicyDetails",
                        hasEffectiveLifecyclePolicyDetails() ? effectiveLifecyclePolicyDetails() : null)
                .add("EffectiveLifecyclePolicyErrorDetails",
                        hasEffectiveLifecyclePolicyErrorDetails() ? effectiveLifecyclePolicyErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "effectiveLifecyclePolicyDetails":
            return Optional.ofNullable(clazz.cast(effectiveLifecyclePolicyDetails()));
        case "effectiveLifecyclePolicyErrorDetails":
            return Optional.ofNullable(clazz.cast(effectiveLifecyclePolicyErrorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("effectiveLifecyclePolicyDetails", EFFECTIVE_LIFECYCLE_POLICY_DETAILS_FIELD);
        map.put("effectiveLifecyclePolicyErrorDetails", EFFECTIVE_LIFECYCLE_POLICY_ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetEffectiveLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((BatchGetEffectiveLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetEffectiveLifecyclePolicyResponse> {
        /**
         * <p>
         * A list of lifecycle policies applied to the OpenSearch Serverless indexes.
         * </p>
         * 
         * @param effectiveLifecyclePolicyDetails
         *        A list of lifecycle policies applied to the OpenSearch Serverless indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveLifecyclePolicyDetails(Collection<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails);

        /**
         * <p>
         * A list of lifecycle policies applied to the OpenSearch Serverless indexes.
         * </p>
         * 
         * @param effectiveLifecyclePolicyDetails
         *        A list of lifecycle policies applied to the OpenSearch Serverless indexes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveLifecyclePolicyDetails(EffectiveLifecyclePolicyDetail... effectiveLifecyclePolicyDetails);

        /**
         * <p>
         * A list of lifecycle policies applied to the OpenSearch Serverless indexes.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #effectiveLifecyclePolicyDetails(List<EffectiveLifecyclePolicyDetail>)}.
         * 
         * @param effectiveLifecyclePolicyDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #effectiveLifecyclePolicyDetails(java.util.Collection<EffectiveLifecyclePolicyDetail>)
         */
        Builder effectiveLifecyclePolicyDetails(
                Consumer<EffectiveLifecyclePolicyDetail.Builder>... effectiveLifecyclePolicyDetails);

        /**
         * <p>
         * A list of resources for which retrieval failed.
         * </p>
         * 
         * @param effectiveLifecyclePolicyErrorDetails
         *        A list of resources for which retrieval failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveLifecyclePolicyErrorDetails(
                Collection<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails);

        /**
         * <p>
         * A list of resources for which retrieval failed.
         * </p>
         * 
         * @param effectiveLifecyclePolicyErrorDetails
         *        A list of resources for which retrieval failed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder effectiveLifecyclePolicyErrorDetails(EffectiveLifecyclePolicyErrorDetail... effectiveLifecyclePolicyErrorDetails);

        /**
         * <p>
         * A list of resources for which retrieval failed.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.Builder}
         * avoiding the need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.Builder#build()}
         * is called immediately and its result is passed to {@link
         * #effectiveLifecyclePolicyErrorDetails(List<EffectiveLifecyclePolicyErrorDetail>)}.
         * 
         * @param effectiveLifecyclePolicyErrorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.EffectiveLifecyclePolicyErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #effectiveLifecyclePolicyErrorDetails(java.util.Collection<EffectiveLifecyclePolicyErrorDetail>)
         */
        Builder effectiveLifecyclePolicyErrorDetails(
                Consumer<EffectiveLifecyclePolicyErrorDetail.Builder>... effectiveLifecyclePolicyErrorDetails);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private List<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails = DefaultSdkAutoConstructList.getInstance();

        private List<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails = DefaultSdkAutoConstructList
                .getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetEffectiveLifecyclePolicyResponse model) {
            super(model);
            effectiveLifecyclePolicyDetails(model.effectiveLifecyclePolicyDetails);
            effectiveLifecyclePolicyErrorDetails(model.effectiveLifecyclePolicyErrorDetails);
        }

        public final List<EffectiveLifecyclePolicyDetail.Builder> getEffectiveLifecyclePolicyDetails() {
            List<EffectiveLifecyclePolicyDetail.Builder> result = EffectiveLifecyclePolicyDetailsCopier
                    .copyToBuilder(this.effectiveLifecyclePolicyDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectiveLifecyclePolicyDetails(
                Collection<EffectiveLifecyclePolicyDetail.BuilderImpl> effectiveLifecyclePolicyDetails) {
            this.effectiveLifecyclePolicyDetails = EffectiveLifecyclePolicyDetailsCopier
                    .copyFromBuilder(effectiveLifecyclePolicyDetails);
        }

        @Override
        public final Builder effectiveLifecyclePolicyDetails(
                Collection<EffectiveLifecyclePolicyDetail> effectiveLifecyclePolicyDetails) {
            this.effectiveLifecyclePolicyDetails = EffectiveLifecyclePolicyDetailsCopier.copy(effectiveLifecyclePolicyDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyDetails(EffectiveLifecyclePolicyDetail... effectiveLifecyclePolicyDetails) {
            effectiveLifecyclePolicyDetails(Arrays.asList(effectiveLifecyclePolicyDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyDetails(
                Consumer<EffectiveLifecyclePolicyDetail.Builder>... effectiveLifecyclePolicyDetails) {
            effectiveLifecyclePolicyDetails(Stream.of(effectiveLifecyclePolicyDetails)
                    .map(c -> EffectiveLifecyclePolicyDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EffectiveLifecyclePolicyErrorDetail.Builder> getEffectiveLifecyclePolicyErrorDetails() {
            List<EffectiveLifecyclePolicyErrorDetail.Builder> result = EffectiveLifecyclePolicyErrorDetailsCopier
                    .copyToBuilder(this.effectiveLifecyclePolicyErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEffectiveLifecyclePolicyErrorDetails(
                Collection<EffectiveLifecyclePolicyErrorDetail.BuilderImpl> effectiveLifecyclePolicyErrorDetails) {
            this.effectiveLifecyclePolicyErrorDetails = EffectiveLifecyclePolicyErrorDetailsCopier
                    .copyFromBuilder(effectiveLifecyclePolicyErrorDetails);
        }

        @Override
        public final Builder effectiveLifecyclePolicyErrorDetails(
                Collection<EffectiveLifecyclePolicyErrorDetail> effectiveLifecyclePolicyErrorDetails) {
            this.effectiveLifecyclePolicyErrorDetails = EffectiveLifecyclePolicyErrorDetailsCopier
                    .copy(effectiveLifecyclePolicyErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyErrorDetails(
                EffectiveLifecyclePolicyErrorDetail... effectiveLifecyclePolicyErrorDetails) {
            effectiveLifecyclePolicyErrorDetails(Arrays.asList(effectiveLifecyclePolicyErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder effectiveLifecyclePolicyErrorDetails(
                Consumer<EffectiveLifecyclePolicyErrorDetail.Builder>... effectiveLifecyclePolicyErrorDetails) {
            effectiveLifecyclePolicyErrorDetails(Stream.of(effectiveLifecyclePolicyErrorDetails)
                    .map(c -> EffectiveLifecyclePolicyErrorDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetEffectiveLifecyclePolicyResponse build() {
            return new BatchGetEffectiveLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
