/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetVpcEndpointResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<BatchGetVpcEndpointResponse.Builder, BatchGetVpcEndpointResponse> {
    private static final SdkField<List<VpcEndpointDetail>> VPC_ENDPOINT_DETAILS_FIELD = SdkField
            .<List<VpcEndpointDetail>> builder(MarshallingType.LIST)
            .memberName("vpcEndpointDetails")
            .getter(getter(BatchGetVpcEndpointResponse::vpcEndpointDetails))
            .setter(setter(Builder::vpcEndpointDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcEndpointDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpointDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<VpcEndpointErrorDetail>> VPC_ENDPOINT_ERROR_DETAILS_FIELD = SdkField
            .<List<VpcEndpointErrorDetail>> builder(MarshallingType.LIST)
            .memberName("vpcEndpointErrorDetails")
            .getter(getter(BatchGetVpcEndpointResponse::vpcEndpointErrorDetails))
            .setter(setter(Builder::vpcEndpointErrorDetails))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointErrorDetails").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcEndpointErrorDetail> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpointErrorDetail::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VPC_ENDPOINT_DETAILS_FIELD,
            VPC_ENDPOINT_ERROR_DETAILS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<VpcEndpointDetail> vpcEndpointDetails;

    private final List<VpcEndpointErrorDetail> vpcEndpointErrorDetails;

    private BatchGetVpcEndpointResponse(BuilderImpl builder) {
        super(builder);
        this.vpcEndpointDetails = builder.vpcEndpointDetails;
        this.vpcEndpointErrorDetails = builder.vpcEndpointErrorDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpointDetails property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcEndpointDetails() {
        return vpcEndpointDetails != null && !(vpcEndpointDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the specified VPC endpoint.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpointDetails} method.
     * </p>
     * 
     * @return Details about the specified VPC endpoint.
     */
    public final List<VpcEndpointDetail> vpcEndpointDetails() {
        return vpcEndpointDetails;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpointErrorDetails property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasVpcEndpointErrorDetails() {
        return vpcEndpointErrorDetails != null && !(vpcEndpointErrorDetails instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Error information for a failed request.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpointErrorDetails} method.
     * </p>
     * 
     * @return Error information for a failed request.
     */
    public final List<VpcEndpointErrorDetail> vpcEndpointErrorDetails() {
        return vpcEndpointErrorDetails;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpointDetails() ? vpcEndpointDetails() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpointErrorDetails() ? vpcEndpointErrorDetails() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetVpcEndpointResponse)) {
            return false;
        }
        BatchGetVpcEndpointResponse other = (BatchGetVpcEndpointResponse) obj;
        return hasVpcEndpointDetails() == other.hasVpcEndpointDetails()
                && Objects.equals(vpcEndpointDetails(), other.vpcEndpointDetails())
                && hasVpcEndpointErrorDetails() == other.hasVpcEndpointErrorDetails()
                && Objects.equals(vpcEndpointErrorDetails(), other.vpcEndpointErrorDetails());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetVpcEndpointResponse")
                .add("VpcEndpointDetails", hasVpcEndpointDetails() ? vpcEndpointDetails() : null)
                .add("VpcEndpointErrorDetails", hasVpcEndpointErrorDetails() ? vpcEndpointErrorDetails() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vpcEndpointDetails":
            return Optional.ofNullable(clazz.cast(vpcEndpointDetails()));
        case "vpcEndpointErrorDetails":
            return Optional.ofNullable(clazz.cast(vpcEndpointErrorDetails()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vpcEndpointDetails", VPC_ENDPOINT_DETAILS_FIELD);
        map.put("vpcEndpointErrorDetails", VPC_ENDPOINT_ERROR_DETAILS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetVpcEndpointResponse, T> g) {
        return obj -> g.apply((BatchGetVpcEndpointResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchGetVpcEndpointResponse> {
        /**
         * <p>
         * Details about the specified VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointDetails
         *        Details about the specified VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointDetails(Collection<VpcEndpointDetail> vpcEndpointDetails);

        /**
         * <p>
         * Details about the specified VPC endpoint.
         * </p>
         * 
         * @param vpcEndpointDetails
         *        Details about the specified VPC endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointDetails(VpcEndpointDetail... vpcEndpointDetails);

        /**
         * <p>
         * Details about the specified VPC endpoint.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail.Builder#build()} is
         * called immediately and its result is passed to {@link #vpcEndpointDetails(List<VpcEndpointDetail>)}.
         * 
         * @param vpcEndpointDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointDetails(java.util.Collection<VpcEndpointDetail>)
         */
        Builder vpcEndpointDetails(Consumer<VpcEndpointDetail.Builder>... vpcEndpointDetails);

        /**
         * <p>
         * Error information for a failed request.
         * </p>
         * 
         * @param vpcEndpointErrorDetails
         *        Error information for a failed request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointErrorDetails(Collection<VpcEndpointErrorDetail> vpcEndpointErrorDetails);

        /**
         * <p>
         * Error information for a failed request.
         * </p>
         * 
         * @param vpcEndpointErrorDetails
         *        Error information for a failed request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointErrorDetails(VpcEndpointErrorDetail... vpcEndpointErrorDetails);

        /**
         * <p>
         * Error information for a failed request.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail.Builder#build()} is
         * called immediately and its result is passed to {@link #vpcEndpointErrorDetails(List<VpcEndpointErrorDetail>)}.
         * 
         * @param vpcEndpointErrorDetails
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointErrorDetails(java.util.Collection<VpcEndpointErrorDetail>)
         */
        Builder vpcEndpointErrorDetails(Consumer<VpcEndpointErrorDetail.Builder>... vpcEndpointErrorDetails);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private List<VpcEndpointDetail> vpcEndpointDetails = DefaultSdkAutoConstructList.getInstance();

        private List<VpcEndpointErrorDetail> vpcEndpointErrorDetails = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetVpcEndpointResponse model) {
            super(model);
            vpcEndpointDetails(model.vpcEndpointDetails);
            vpcEndpointErrorDetails(model.vpcEndpointErrorDetails);
        }

        public final List<VpcEndpointDetail.Builder> getVpcEndpointDetails() {
            List<VpcEndpointDetail.Builder> result = VpcEndpointDetailsCopier.copyToBuilder(this.vpcEndpointDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointDetails(Collection<VpcEndpointDetail.BuilderImpl> vpcEndpointDetails) {
            this.vpcEndpointDetails = VpcEndpointDetailsCopier.copyFromBuilder(vpcEndpointDetails);
        }

        @Override
        public final Builder vpcEndpointDetails(Collection<VpcEndpointDetail> vpcEndpointDetails) {
            this.vpcEndpointDetails = VpcEndpointDetailsCopier.copy(vpcEndpointDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointDetails(VpcEndpointDetail... vpcEndpointDetails) {
            vpcEndpointDetails(Arrays.asList(vpcEndpointDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointDetails(Consumer<VpcEndpointDetail.Builder>... vpcEndpointDetails) {
            vpcEndpointDetails(Stream.of(vpcEndpointDetails).map(c -> VpcEndpointDetail.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<VpcEndpointErrorDetail.Builder> getVpcEndpointErrorDetails() {
            List<VpcEndpointErrorDetail.Builder> result = VpcEndpointErrorDetailsCopier
                    .copyToBuilder(this.vpcEndpointErrorDetails);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointErrorDetails(Collection<VpcEndpointErrorDetail.BuilderImpl> vpcEndpointErrorDetails) {
            this.vpcEndpointErrorDetails = VpcEndpointErrorDetailsCopier.copyFromBuilder(vpcEndpointErrorDetails);
        }

        @Override
        public final Builder vpcEndpointErrorDetails(Collection<VpcEndpointErrorDetail> vpcEndpointErrorDetails) {
            this.vpcEndpointErrorDetails = VpcEndpointErrorDetailsCopier.copy(vpcEndpointErrorDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrorDetails(VpcEndpointErrorDetail... vpcEndpointErrorDetails) {
            vpcEndpointErrorDetails(Arrays.asList(vpcEndpointErrorDetails));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointErrorDetails(Consumer<VpcEndpointErrorDetail.Builder>... vpcEndpointErrorDetails) {
            vpcEndpointErrorDetails(Stream.of(vpcEndpointErrorDetails)
                    .map(c -> VpcEndpointErrorDetail.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetVpcEndpointResponse build() {
            return new BatchGetVpcEndpointResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
