/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateCollectionRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<CreateCollectionRequest.Builder, CreateCollectionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateCollectionRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateCollectionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateCollectionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STANDBY_REPLICAS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("standbyReplicas").getter(getter(CreateCollectionRequest::standbyReplicasAsString))
            .setter(setter(Builder::standbyReplicas))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standbyReplicas").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("tags")
            .getter(getter(CreateCollectionRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateCollectionRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DESCRIPTION_FIELD, NAME_FIELD, STANDBY_REPLICAS_FIELD, TAGS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String description;

    private final String name;

    private final String standbyReplicas;

    private final List<Tag> tags;

    private final String type;

    private CreateCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.name = builder.name;
        this.standbyReplicas = builder.standbyReplicas;
        this.tags = builder.tags;
        this.type = builder.type;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * Description of the collection.
     * </p>
     * 
     * @return Description of the collection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Name of the collection.
     * </p>
     * 
     * @return Name of the collection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Indicates whether standby replicas should be used for a collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standbyReplicas}
     * will return {@link StandbyReplicas#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standbyReplicasAsString}.
     * </p>
     * 
     * @return Indicates whether standby replicas should be used for a collection.
     * @see StandbyReplicas
     */
    public final StandbyReplicas standbyReplicas() {
        return StandbyReplicas.fromValue(standbyReplicas);
    }

    /**
     * <p>
     * Indicates whether standby replicas should be used for a collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #standbyReplicas}
     * will return {@link StandbyReplicas#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #standbyReplicasAsString}.
     * </p>
     * 
     * @return Indicates whether standby replicas should be used for a collection.
     * @see StandbyReplicas
     */
    public final String standbyReplicasAsString() {
        return standbyReplicas;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * The type of collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of collection.
     * @see CollectionType
     */
    public final CollectionType type() {
        return CollectionType.fromValue(type);
    }

    /**
     * <p>
     * The type of collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of collection.
     * @see CollectionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(standbyReplicasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionRequest)) {
            return false;
        }
        CreateCollectionRequest other = (CreateCollectionRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(description(), other.description())
                && Objects.equals(name(), other.name())
                && Objects.equals(standbyReplicasAsString(), other.standbyReplicasAsString()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateCollectionRequest").add("ClientToken", clientToken()).add("Description", description())
                .add("Name", name()).add("StandbyReplicas", standbyReplicasAsString()).add("Tags", hasTags() ? tags() : null)
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "standbyReplicas":
            return Optional.ofNullable(clazz.cast(standbyReplicasAsString()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("name", NAME_FIELD);
        map.put("standbyReplicas", STANDBY_REPLICAS_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCollectionRequest, T> g) {
        return obj -> g.apply((CreateCollectionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateCollectionRequest> {
        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * Description of the collection.
         * </p>
         * 
         * @param description
         *        Description of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Name of the collection.
         * </p>
         * 
         * @param name
         *        Name of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Indicates whether standby replicas should be used for a collection.
         * </p>
         * 
         * @param standbyReplicas
         *        Indicates whether standby replicas should be used for a collection.
         * @see StandbyReplicas
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandbyReplicas
         */
        Builder standbyReplicas(String standbyReplicas);

        /**
         * <p>
         * Indicates whether standby replicas should be used for a collection.
         * </p>
         * 
         * @param standbyReplicas
         *        Indicates whether standby replicas should be used for a collection.
         * @see StandbyReplicas
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StandbyReplicas
         */
        Builder standbyReplicas(StandbyReplicas standbyReplicas);

        /**
         * <p>
         * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.
         * </p>
         * 
         * @param tags
         *        An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.
         * </p>
         * 
         * @param tags
         *        An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * An arbitrary set of tags (key–value pairs) to associate with the OpenSearch Serverless collection.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.Tag.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.opensearchserverless.model.Tag#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.Tag.Builder#build()} is called immediately
         * and its result is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.Tag.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(java.util.Collection<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * The type of collection.
         * </p>
         * 
         * @param type
         *        The type of collection.
         * @see CollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of collection.
         * </p>
         * 
         * @param type
         *        The type of collection.
         * @see CollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionType
         */
        Builder type(CollectionType type);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String description;

        private String name;

        private String standbyReplicas;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionRequest model) {
            super(model);
            clientToken(model.clientToken);
            description(model.description);
            name(model.name);
            standbyReplicas(model.standbyReplicas);
            tags(model.tags);
            type(model.type);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStandbyReplicas() {
            return standbyReplicas;
        }

        public final void setStandbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
        }

        @Override
        public final Builder standbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
            return this;
        }

        @Override
        public final Builder standbyReplicas(StandbyReplicas standbyReplicas) {
            this.standbyReplicas(standbyReplicas == null ? null : standbyReplicas.toString());
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CollectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCollectionRequest build() {
            return new CreateCollectionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
