/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLifecyclePolicyResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<CreateLifecyclePolicyResponse.Builder, CreateLifecyclePolicyResponse> {
    private static final SdkField<LifecyclePolicyDetail> LIFECYCLE_POLICY_DETAIL_FIELD = SdkField
            .<LifecyclePolicyDetail> builder(MarshallingType.SDK_POJO).memberName("lifecyclePolicyDetail")
            .getter(getter(CreateLifecyclePolicyResponse::lifecyclePolicyDetail)).setter(setter(Builder::lifecyclePolicyDetail))
            .constructor(LifecyclePolicyDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(LIFECYCLE_POLICY_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LifecyclePolicyDetail lifecyclePolicyDetail;

    private CreateLifecyclePolicyResponse(BuilderImpl builder) {
        super(builder);
        this.lifecyclePolicyDetail = builder.lifecyclePolicyDetail;
    }

    /**
     * <p>
     * Details about the created lifecycle policy.
     * </p>
     * 
     * @return Details about the created lifecycle policy.
     */
    public final LifecyclePolicyDetail lifecyclePolicyDetail() {
        return lifecyclePolicyDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(lifecyclePolicyDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLifecyclePolicyResponse)) {
            return false;
        }
        CreateLifecyclePolicyResponse other = (CreateLifecyclePolicyResponse) obj;
        return Objects.equals(lifecyclePolicyDetail(), other.lifecyclePolicyDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLifecyclePolicyResponse").add("LifecyclePolicyDetail", lifecyclePolicyDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "lifecyclePolicyDetail":
            return Optional.ofNullable(clazz.cast(lifecyclePolicyDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("lifecyclePolicyDetail", LIFECYCLE_POLICY_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLifecyclePolicyResponse, T> g) {
        return obj -> g.apply((CreateLifecyclePolicyResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateLifecyclePolicyResponse> {
        /**
         * <p>
         * Details about the created lifecycle policy.
         * </p>
         * 
         * @param lifecyclePolicyDetail
         *        Details about the created lifecycle policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecyclePolicyDetail(LifecyclePolicyDetail lifecyclePolicyDetail);

        /**
         * <p>
         * Details about the created lifecycle policy.
         * </p>
         * This is a convenience method that creates an instance of the {@link LifecyclePolicyDetail.Builder} avoiding
         * the need to create one manually via {@link LifecyclePolicyDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LifecyclePolicyDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #lifecyclePolicyDetail(LifecyclePolicyDetail)}.
         * 
         * @param lifecyclePolicyDetail
         *        a consumer that will call methods on {@link LifecyclePolicyDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lifecyclePolicyDetail(LifecyclePolicyDetail)
         */
        default Builder lifecyclePolicyDetail(Consumer<LifecyclePolicyDetail.Builder> lifecyclePolicyDetail) {
            return lifecyclePolicyDetail(LifecyclePolicyDetail.builder().applyMutation(lifecyclePolicyDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private LifecyclePolicyDetail lifecyclePolicyDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLifecyclePolicyResponse model) {
            super(model);
            lifecyclePolicyDetail(model.lifecyclePolicyDetail);
        }

        public final LifecyclePolicyDetail.Builder getLifecyclePolicyDetail() {
            return lifecyclePolicyDetail != null ? lifecyclePolicyDetail.toBuilder() : null;
        }

        public final void setLifecyclePolicyDetail(LifecyclePolicyDetail.BuilderImpl lifecyclePolicyDetail) {
            this.lifecyclePolicyDetail = lifecyclePolicyDetail != null ? lifecyclePolicyDetail.build() : null;
        }

        @Override
        public final Builder lifecyclePolicyDetail(LifecyclePolicyDetail lifecyclePolicyDetail) {
            this.lifecyclePolicyDetail = lifecyclePolicyDetail;
            return this;
        }

        @Override
        public CreateLifecyclePolicyResponse build() {
            return new CreateLifecyclePolicyResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
