/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes IAM Identity Center options for an OpenSearch Serverless security configuration in the form of a key-value
 * map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IamIdentityCenterConfigOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<IamIdentityCenterConfigOptions.Builder, IamIdentityCenterConfigOptions> {
    private static final SdkField<String> APPLICATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationArn").getter(getter(IamIdentityCenterConfigOptions::applicationArn))
            .setter(setter(Builder::applicationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationArn").build()).build();

    private static final SdkField<String> APPLICATION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationDescription").getter(getter(IamIdentityCenterConfigOptions::applicationDescription))
            .setter(setter(Builder::applicationDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationDescription").build())
            .build();

    private static final SdkField<String> APPLICATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("applicationName").getter(getter(IamIdentityCenterConfigOptions::applicationName))
            .setter(setter(Builder::applicationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationName").build()).build();

    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupAttribute").getter(getter(IamIdentityCenterConfigOptions::groupAttributeAsString))
            .setter(setter(Builder::groupAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAttribute").build()).build();

    private static final SdkField<String> INSTANCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("instanceArn").getter(getter(IamIdentityCenterConfigOptions::instanceArn))
            .setter(setter(Builder::instanceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceArn").build()).build();

    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAttribute").getter(getter(IamIdentityCenterConfigOptions::userAttributeAsString))
            .setter(setter(Builder::userAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ARN_FIELD,
            APPLICATION_DESCRIPTION_FIELD, APPLICATION_NAME_FIELD, GROUP_ATTRIBUTE_FIELD, INSTANCE_ARN_FIELD,
            USER_ATTRIBUTE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String applicationArn;

    private final String applicationDescription;

    private final String applicationName;

    private final String groupAttribute;

    private final String instanceArn;

    private final String userAttribute;

    private IamIdentityCenterConfigOptions(BuilderImpl builder) {
        this.applicationArn = builder.applicationArn;
        this.applicationDescription = builder.applicationDescription;
        this.applicationName = builder.applicationName;
        this.groupAttribute = builder.groupAttribute;
        this.instanceArn = builder.instanceArn;
        this.userAttribute = builder.userAttribute;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center application used to integrate with OpenSearch Serverless.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center application used to integrate with OpenSearch Serverless.
     */
    public final String applicationArn() {
        return applicationArn;
    }

    /**
     * <p>
     * The description of the IAM Identity Center application used to integrate with OpenSearch Serverless.
     * </p>
     * 
     * @return The description of the IAM Identity Center application used to integrate with OpenSearch Serverless.
     */
    public final String applicationDescription() {
        return applicationDescription;
    }

    /**
     * <p>
     * The name of the IAM Identity Center application used to integrate with OpenSearch Serverless.
     * </p>
     * 
     * @return The name of the IAM Identity Center application used to integrate with OpenSearch Serverless.
     */
    public final String applicationName() {
        return applicationName;
    }

    /**
     * <p>
     * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupAttribute}
     * will return {@link IamIdentityCenterGroupAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #groupAttributeAsString}.
     * </p>
     * 
     * @return The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * @see IamIdentityCenterGroupAttribute
     */
    public final IamIdentityCenterGroupAttribute groupAttribute() {
        return IamIdentityCenterGroupAttribute.fromValue(groupAttribute);
    }

    /**
     * <p>
     * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #groupAttribute}
     * will return {@link IamIdentityCenterGroupAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #groupAttributeAsString}.
     * </p>
     * 
     * @return The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
     * @see IamIdentityCenterGroupAttribute
     */
    public final String groupAttributeAsString() {
        return groupAttribute;
    }

    /**
     * <p>
     * The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
     * </p>
     * 
     * @return The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
     */
    public final String instanceArn() {
        return instanceArn;
    }

    /**
     * <p>
     * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userAttribute}
     * will return {@link IamIdentityCenterUserAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #userAttributeAsString}.
     * </p>
     * 
     * @return The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
     * @see IamIdentityCenterUserAttribute
     */
    public final IamIdentityCenterUserAttribute userAttribute() {
        return IamIdentityCenterUserAttribute.fromValue(userAttribute);
    }

    /**
     * <p>
     * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #userAttribute}
     * will return {@link IamIdentityCenterUserAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #userAttributeAsString}.
     * </p>
     * 
     * @return The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
     * @see IamIdentityCenterUserAttribute
     */
    public final String userAttributeAsString() {
        return userAttribute;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(applicationArn());
        hashCode = 31 * hashCode + Objects.hashCode(applicationDescription());
        hashCode = 31 * hashCode + Objects.hashCode(applicationName());
        hashCode = 31 * hashCode + Objects.hashCode(groupAttributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(instanceArn());
        hashCode = 31 * hashCode + Objects.hashCode(userAttributeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IamIdentityCenterConfigOptions)) {
            return false;
        }
        IamIdentityCenterConfigOptions other = (IamIdentityCenterConfigOptions) obj;
        return Objects.equals(applicationArn(), other.applicationArn())
                && Objects.equals(applicationDescription(), other.applicationDescription())
                && Objects.equals(applicationName(), other.applicationName())
                && Objects.equals(groupAttributeAsString(), other.groupAttributeAsString())
                && Objects.equals(instanceArn(), other.instanceArn())
                && Objects.equals(userAttributeAsString(), other.userAttributeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IamIdentityCenterConfigOptions").add("ApplicationArn", applicationArn())
                .add("ApplicationDescription", applicationDescription()).add("ApplicationName", applicationName())
                .add("GroupAttribute", groupAttributeAsString()).add("InstanceArn", instanceArn())
                .add("UserAttribute", userAttributeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "applicationArn":
            return Optional.ofNullable(clazz.cast(applicationArn()));
        case "applicationDescription":
            return Optional.ofNullable(clazz.cast(applicationDescription()));
        case "applicationName":
            return Optional.ofNullable(clazz.cast(applicationName()));
        case "groupAttribute":
            return Optional.ofNullable(clazz.cast(groupAttributeAsString()));
        case "instanceArn":
            return Optional.ofNullable(clazz.cast(instanceArn()));
        case "userAttribute":
            return Optional.ofNullable(clazz.cast(userAttributeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("applicationArn", APPLICATION_ARN_FIELD);
        map.put("applicationDescription", APPLICATION_DESCRIPTION_FIELD);
        map.put("applicationName", APPLICATION_NAME_FIELD);
        map.put("groupAttribute", GROUP_ATTRIBUTE_FIELD);
        map.put("instanceArn", INSTANCE_ARN_FIELD);
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<IamIdentityCenterConfigOptions, T> g) {
        return obj -> g.apply((IamIdentityCenterConfigOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IamIdentityCenterConfigOptions> {
        /**
         * <p>
         * The ARN of the IAM Identity Center application used to integrate with OpenSearch Serverless.
         * </p>
         * 
         * @param applicationArn
         *        The ARN of the IAM Identity Center application used to integrate with OpenSearch Serverless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationArn(String applicationArn);

        /**
         * <p>
         * The description of the IAM Identity Center application used to integrate with OpenSearch Serverless.
         * </p>
         * 
         * @param applicationDescription
         *        The description of the IAM Identity Center application used to integrate with OpenSearch Serverless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationDescription(String applicationDescription);

        /**
         * <p>
         * The name of the IAM Identity Center application used to integrate with OpenSearch Serverless.
         * </p>
         * 
         * @param applicationName
         *        The name of the IAM Identity Center application used to integrate with OpenSearch Serverless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationName(String applicationName);

        /**
         * <p>
         * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * </p>
         * 
         * @param groupAttribute
         *        The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * @see IamIdentityCenterGroupAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterGroupAttribute
         */
        Builder groupAttribute(String groupAttribute);

        /**
         * <p>
         * The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * </p>
         * 
         * @param groupAttribute
         *        The group attribute for this IAM Identity Center integration. Defaults to <code>GroupId</code>.
         * @see IamIdentityCenterGroupAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterGroupAttribute
         */
        Builder groupAttribute(IamIdentityCenterGroupAttribute groupAttribute);

        /**
         * <p>
         * The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
         * </p>
         * 
         * @param instanceArn
         *        The ARN of the IAM Identity Center instance used to integrate with OpenSearch Serverless.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceArn(String instanceArn);

        /**
         * <p>
         * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
         * </p>
         * 
         * @param userAttribute
         *        The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
         * @see IamIdentityCenterUserAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterUserAttribute
         */
        Builder userAttribute(String userAttribute);

        /**
         * <p>
         * The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
         * </p>
         * 
         * @param userAttribute
         *        The user attribute for this IAM Identity Center integration. Defaults to <code>UserId</code>
         * @see IamIdentityCenterUserAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IamIdentityCenterUserAttribute
         */
        Builder userAttribute(IamIdentityCenterUserAttribute userAttribute);
    }

    static final class BuilderImpl implements Builder {
        private String applicationArn;

        private String applicationDescription;

        private String applicationName;

        private String groupAttribute;

        private String instanceArn;

        private String userAttribute;

        private BuilderImpl() {
        }

        private BuilderImpl(IamIdentityCenterConfigOptions model) {
            applicationArn(model.applicationArn);
            applicationDescription(model.applicationDescription);
            applicationName(model.applicationName);
            groupAttribute(model.groupAttribute);
            instanceArn(model.instanceArn);
            userAttribute(model.userAttribute);
        }

        public final String getApplicationArn() {
            return applicationArn;
        }

        public final void setApplicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
        }

        @Override
        public final Builder applicationArn(String applicationArn) {
            this.applicationArn = applicationArn;
            return this;
        }

        public final String getApplicationDescription() {
            return applicationDescription;
        }

        public final void setApplicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
        }

        @Override
        public final Builder applicationDescription(String applicationDescription) {
            this.applicationDescription = applicationDescription;
            return this;
        }

        public final String getApplicationName() {
            return applicationName;
        }

        public final void setApplicationName(String applicationName) {
            this.applicationName = applicationName;
        }

        @Override
        public final Builder applicationName(String applicationName) {
            this.applicationName = applicationName;
            return this;
        }

        public final String getGroupAttribute() {
            return groupAttribute;
        }

        public final void setGroupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
        }

        @Override
        public final Builder groupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
            return this;
        }

        @Override
        public final Builder groupAttribute(IamIdentityCenterGroupAttribute groupAttribute) {
            this.groupAttribute(groupAttribute == null ? null : groupAttribute.toString());
            return this;
        }

        public final String getInstanceArn() {
            return instanceArn;
        }

        public final void setInstanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
        }

        @Override
        public final Builder instanceArn(String instanceArn) {
            this.instanceArn = instanceArn;
            return this;
        }

        public final String getUserAttribute() {
            return userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        @Override
        public final Builder userAttribute(IamIdentityCenterUserAttribute userAttribute) {
            this.userAttribute(userAttribute == null ? null : userAttribute.toString());
            return this;
        }

        @Override
        public IamIdentityCenterConfigOptions build() {
            return new IamIdentityCenterConfigOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
