/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSecurityConfigsResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<ListSecurityConfigsResponse.Builder, ListSecurityConfigsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSecurityConfigsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<SecurityConfigSummary>> SECURITY_CONFIG_SUMMARIES_FIELD = SdkField
            .<List<SecurityConfigSummary>> builder(MarshallingType.LIST)
            .memberName("securityConfigSummaries")
            .getter(getter(ListSecurityConfigsResponse::securityConfigSummaries))
            .setter(setter(Builder::securityConfigSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityConfigSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SecurityConfigSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(SecurityConfigSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            SECURITY_CONFIG_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<SecurityConfigSummary> securityConfigSummaries;

    private ListSecurityConfigsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.securityConfigSummaries = builder.securityConfigSummaries;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the SecurityConfigSummaries property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSecurityConfigSummaries() {
        return securityConfigSummaries != null && !(securityConfigSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about the security configurations in your account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSecurityConfigSummaries} method.
     * </p>
     * 
     * @return Details about the security configurations in your account.
     */
    public final List<SecurityConfigSummary> securityConfigSummaries() {
        return securityConfigSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasSecurityConfigSummaries() ? securityConfigSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSecurityConfigsResponse)) {
            return false;
        }
        ListSecurityConfigsResponse other = (ListSecurityConfigsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken())
                && hasSecurityConfigSummaries() == other.hasSecurityConfigSummaries()
                && Objects.equals(securityConfigSummaries(), other.securityConfigSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSecurityConfigsResponse").add("NextToken", nextToken())
                .add("SecurityConfigSummaries", hasSecurityConfigSummaries() ? securityConfigSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "securityConfigSummaries":
            return Optional.ofNullable(clazz.cast(securityConfigSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("securityConfigSummaries", SECURITY_CONFIG_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSecurityConfigsResponse, T> g) {
        return obj -> g.apply((ListSecurityConfigsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListSecurityConfigsResponse> {
        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Details about the security configurations in your account.
         * </p>
         * 
         * @param securityConfigSummaries
         *        Details about the security configurations in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigSummaries(Collection<SecurityConfigSummary> securityConfigSummaries);

        /**
         * <p>
         * Details about the security configurations in your account.
         * </p>
         * 
         * @param securityConfigSummaries
         *        Details about the security configurations in your account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigSummaries(SecurityConfigSummary... securityConfigSummaries);

        /**
         * <p>
         * Details about the security configurations in your account.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #securityConfigSummaries(List<SecurityConfigSummary>)}.
         * 
         * @param securityConfigSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.SecurityConfigSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfigSummaries(java.util.Collection<SecurityConfigSummary>)
         */
        Builder securityConfigSummaries(Consumer<SecurityConfigSummary.Builder>... securityConfigSummaries);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<SecurityConfigSummary> securityConfigSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListSecurityConfigsResponse model) {
            super(model);
            nextToken(model.nextToken);
            securityConfigSummaries(model.securityConfigSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SecurityConfigSummary.Builder> getSecurityConfigSummaries() {
            List<SecurityConfigSummary.Builder> result = SecurityConfigSummariesCopier
                    .copyToBuilder(this.securityConfigSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityConfigSummaries(Collection<SecurityConfigSummary.BuilderImpl> securityConfigSummaries) {
            this.securityConfigSummaries = SecurityConfigSummariesCopier.copyFromBuilder(securityConfigSummaries);
        }

        @Override
        public final Builder securityConfigSummaries(Collection<SecurityConfigSummary> securityConfigSummaries) {
            this.securityConfigSummaries = SecurityConfigSummariesCopier.copy(securityConfigSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigSummaries(SecurityConfigSummary... securityConfigSummaries) {
            securityConfigSummaries(Arrays.asList(securityConfigSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityConfigSummaries(Consumer<SecurityConfigSummary.Builder>... securityConfigSummaries) {
            securityConfigSummaries(Stream.of(securityConfigSummaries)
                    .map(c -> SecurityConfigSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListSecurityConfigsResponse build() {
            return new ListSecurityConfigsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
