/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListVpcEndpointsResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<ListVpcEndpointsResponse.Builder, ListVpcEndpointsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListVpcEndpointsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<List<VpcEndpointSummary>> VPC_ENDPOINT_SUMMARIES_FIELD = SdkField
            .<List<VpcEndpointSummary>> builder(MarshallingType.LIST)
            .memberName("vpcEndpointSummaries")
            .getter(getter(ListVpcEndpointsResponse::vpcEndpointSummaries))
            .setter(setter(Builder::vpcEndpointSummaries))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcEndpointSummaries").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<VpcEndpointSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(VpcEndpointSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD,
            VPC_ENDPOINT_SUMMARIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String nextToken;

    private final List<VpcEndpointSummary> vpcEndpointSummaries;

    private ListVpcEndpointsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.vpcEndpointSummaries = builder.vpcEndpointSummaries;
    }

    /**
     * <p>
     * When <code>nextToken</code> is returned, there are more results available. The value of <code>nextToken</code> is
     * a unique pagination token for each page. Make the call again using the returned token to retrieve the next page.
     * </p>
     * 
     * @return When <code>nextToken</code> is returned, there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
     *         token to retrieve the next page.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the VpcEndpointSummaries property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasVpcEndpointSummaries() {
        return vpcEndpointSummaries != null && !(vpcEndpointSummaries instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Details about each VPC endpoint, including the name and current status.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVpcEndpointSummaries} method.
     * </p>
     * 
     * @return Details about each VPC endpoint, including the name and current status.
     */
    public final List<VpcEndpointSummary> vpcEndpointSummaries() {
        return vpcEndpointSummaries;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(hasVpcEndpointSummaries() ? vpcEndpointSummaries() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListVpcEndpointsResponse)) {
            return false;
        }
        ListVpcEndpointsResponse other = (ListVpcEndpointsResponse) obj;
        return Objects.equals(nextToken(), other.nextToken()) && hasVpcEndpointSummaries() == other.hasVpcEndpointSummaries()
                && Objects.equals(vpcEndpointSummaries(), other.vpcEndpointSummaries());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListVpcEndpointsResponse").add("NextToken", nextToken())
                .add("VpcEndpointSummaries", hasVpcEndpointSummaries() ? vpcEndpointSummaries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "vpcEndpointSummaries":
            return Optional.ofNullable(clazz.cast(vpcEndpointSummaries()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("vpcEndpointSummaries", VPC_ENDPOINT_SUMMARIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListVpcEndpointsResponse, T> g) {
        return obj -> g.apply((ListVpcEndpointsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListVpcEndpointsResponse> {
        /**
         * <p>
         * When <code>nextToken</code> is returned, there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. Make the call again using the returned
         * token to retrieve the next page.
         * </p>
         * 
         * @param nextToken
         *        When <code>nextToken</code> is returned, there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. Make the call again using the
         *        returned token to retrieve the next page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * Details about each VPC endpoint, including the name and current status.
         * </p>
         * 
         * @param vpcEndpointSummaries
         *        Details about each VPC endpoint, including the name and current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointSummaries(Collection<VpcEndpointSummary> vpcEndpointSummaries);

        /**
         * <p>
         * Details about each VPC endpoint, including the name and current status.
         * </p>
         * 
         * @param vpcEndpointSummaries
         *        Details about each VPC endpoint, including the name and current status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcEndpointSummaries(VpcEndpointSummary... vpcEndpointSummaries);

        /**
         * <p>
         * Details about each VPC endpoint, including the name and current status.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary.Builder#build()} is
         * called immediately and its result is passed to {@link #vpcEndpointSummaries(List<VpcEndpointSummary>)}.
         * 
         * @param vpcEndpointSummaries
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.opensearchserverless.model.VpcEndpointSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcEndpointSummaries(java.util.Collection<VpcEndpointSummary>)
         */
        Builder vpcEndpointSummaries(Consumer<VpcEndpointSummary.Builder>... vpcEndpointSummaries);
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private String nextToken;

        private List<VpcEndpointSummary> vpcEndpointSummaries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListVpcEndpointsResponse model) {
            super(model);
            nextToken(model.nextToken);
            vpcEndpointSummaries(model.vpcEndpointSummaries);
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<VpcEndpointSummary.Builder> getVpcEndpointSummaries() {
            List<VpcEndpointSummary.Builder> result = VpcEndpointSummariesCopier.copyToBuilder(this.vpcEndpointSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVpcEndpointSummaries(Collection<VpcEndpointSummary.BuilderImpl> vpcEndpointSummaries) {
            this.vpcEndpointSummaries = VpcEndpointSummariesCopier.copyFromBuilder(vpcEndpointSummaries);
        }

        @Override
        public final Builder vpcEndpointSummaries(Collection<VpcEndpointSummary> vpcEndpointSummaries) {
            this.vpcEndpointSummaries = VpcEndpointSummariesCopier.copy(vpcEndpointSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointSummaries(VpcEndpointSummary... vpcEndpointSummaries) {
            vpcEndpointSummaries(Arrays.asList(vpcEndpointSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder vpcEndpointSummaries(Consumer<VpcEndpointSummary.Builder>... vpcEndpointSummaries) {
            vpcEndpointSummaries(Stream.of(vpcEndpointSummaries).map(c -> VpcEndpointSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListVpcEndpointsResponse build() {
            return new ListVpcEndpointsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
