/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAccountSettingsResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<UpdateAccountSettingsResponse.Builder, UpdateAccountSettingsResponse> {
    private static final SdkField<AccountSettingsDetail> ACCOUNT_SETTINGS_DETAIL_FIELD = SdkField
            .<AccountSettingsDetail> builder(MarshallingType.SDK_POJO).memberName("accountSettingsDetail")
            .getter(getter(UpdateAccountSettingsResponse::accountSettingsDetail)).setter(setter(Builder::accountSettingsDetail))
            .constructor(AccountSettingsDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountSettingsDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(ACCOUNT_SETTINGS_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AccountSettingsDetail accountSettingsDetail;

    private UpdateAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountSettingsDetail = builder.accountSettingsDetail;
    }

    /**
     * <p>
     * OpenSearch Serverless-related settings for the current Amazon Web Services account.
     * </p>
     * 
     * @return OpenSearch Serverless-related settings for the current Amazon Web Services account.
     */
    public final AccountSettingsDetail accountSettingsDetail() {
        return accountSettingsDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountSettingsDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAccountSettingsResponse)) {
            return false;
        }
        UpdateAccountSettingsResponse other = (UpdateAccountSettingsResponse) obj;
        return Objects.equals(accountSettingsDetail(), other.accountSettingsDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAccountSettingsResponse").add("AccountSettingsDetail", accountSettingsDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountSettingsDetail":
            return Optional.ofNullable(clazz.cast(accountSettingsDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountSettingsDetail", ACCOUNT_SETTINGS_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAccountSettingsResponse, T> g) {
        return obj -> g.apply((UpdateAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateAccountSettingsResponse> {
        /**
         * <p>
         * OpenSearch Serverless-related settings for the current Amazon Web Services account.
         * </p>
         * 
         * @param accountSettingsDetail
         *        OpenSearch Serverless-related settings for the current Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSettingsDetail(AccountSettingsDetail accountSettingsDetail);

        /**
         * <p>
         * OpenSearch Serverless-related settings for the current Amazon Web Services account.
         * </p>
         * This is a convenience method that creates an instance of the {@link AccountSettingsDetail.Builder} avoiding
         * the need to create one manually via {@link AccountSettingsDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AccountSettingsDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #accountSettingsDetail(AccountSettingsDetail)}.
         * 
         * @param accountSettingsDetail
         *        a consumer that will call methods on {@link AccountSettingsDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSettingsDetail(AccountSettingsDetail)
         */
        default Builder accountSettingsDetail(Consumer<AccountSettingsDetail.Builder> accountSettingsDetail) {
            return accountSettingsDetail(AccountSettingsDetail.builder().applyMutation(accountSettingsDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private AccountSettingsDetail accountSettingsDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAccountSettingsResponse model) {
            super(model);
            accountSettingsDetail(model.accountSettingsDetail);
        }

        public final AccountSettingsDetail.Builder getAccountSettingsDetail() {
            return accountSettingsDetail != null ? accountSettingsDetail.toBuilder() : null;
        }

        public final void setAccountSettingsDetail(AccountSettingsDetail.BuilderImpl accountSettingsDetail) {
            this.accountSettingsDetail = accountSettingsDetail != null ? accountSettingsDetail.build() : null;
        }

        @Override
        public final Builder accountSettingsDetail(AccountSettingsDetail accountSettingsDetail) {
            this.accountSettingsDetail = accountSettingsDetail;
            return this;
        }

        @Override
        public UpdateAccountSettingsResponse build() {
            return new UpdateAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
