/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an updated OpenSearch Serverless collection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateCollectionDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<UpdateCollectionDetail.Builder, UpdateCollectionDetail> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(UpdateCollectionDetail::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createdDate").getter(getter(UpdateCollectionDetail::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateCollectionDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(UpdateCollectionDetail::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedDate").getter(getter(UpdateCollectionDetail::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateCollectionDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateCollectionDetail::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(UpdateCollectionDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, CREATED_DATE_FIELD,
            DESCRIPTION_FIELD, ID_FIELD, LAST_MODIFIED_DATE_FIELD, NAME_FIELD, STATUS_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final Long createdDate;

    private final String description;

    private final String id;

    private final Long lastModifiedDate;

    private final String name;

    private final String status;

    private final String type;

    private UpdateCollectionDetail(BuilderImpl builder) {
        this.arn = builder.arn;
        this.createdDate = builder.createdDate;
        this.description = builder.description;
        this.id = builder.id;
        this.lastModifiedDate = builder.lastModifiedDate;
        this.name = builder.name;
        this.status = builder.status;
        this.type = builder.type;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the collection.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the collection.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The date and time when the collection was created.
     * </p>
     * 
     * @return The date and time when the collection was created.
     */
    public final Long createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The description of the collection.
     * </p>
     * 
     * @return The description of the collection.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the collection.
     * </p>
     * 
     * @return The unique identifier of the collection.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The date and time when the collection was last modified.
     * </p>
     * 
     * @return The date and time when the collection was last modified.
     */
    public final Long lastModifiedDate() {
        return lastModifiedDate;
    }

    /**
     * <p>
     * The name of the collection.
     * </p>
     * 
     * @return The name of the collection.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The current status of the collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CollectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the collection.
     * @see CollectionStatus
     */
    public final CollectionStatus status() {
        return CollectionStatus.fromValue(status);
    }

    /**
     * <p>
     * The current status of the collection.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link CollectionStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The current status of the collection.
     * @see CollectionStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The collection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The collection type.
     * @see CollectionType
     */
    public final CollectionType type() {
        return CollectionType.fromValue(type);
    }

    /**
     * <p>
     * The collection type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link CollectionType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The collection type.
     * @see CollectionType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateCollectionDetail)) {
            return false;
        }
        UpdateCollectionDetail other = (UpdateCollectionDetail) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(description(), other.description()) && Objects.equals(id(), other.id())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate()) && Objects.equals(name(), other.name())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateCollectionDetail").add("Arn", arn()).add("CreatedDate", createdDate())
                .add("Description", description()).add("Id", id()).add("LastModifiedDate", lastModifiedDate())
                .add("Name", name()).add("Status", statusAsString()).add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("arn", ARN_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateCollectionDetail, T> g) {
        return obj -> g.apply((UpdateCollectionDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UpdateCollectionDetail> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the collection.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The date and time when the collection was created.
         * </p>
         * 
         * @param createdDate
         *        The date and time when the collection was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Long createdDate);

        /**
         * <p>
         * The description of the collection.
         * </p>
         * 
         * @param description
         *        The description of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the collection.
         * </p>
         * 
         * @param id
         *        The unique identifier of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The date and time when the collection was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The date and time when the collection was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Long lastModifiedDate);

        /**
         * <p>
         * The name of the collection.
         * </p>
         * 
         * @param name
         *        The name of the collection.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The current status of the collection.
         * </p>
         * 
         * @param status
         *        The current status of the collection.
         * @see CollectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The current status of the collection.
         * </p>
         * 
         * @param status
         *        The current status of the collection.
         * @see CollectionStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionStatus
         */
        Builder status(CollectionStatus status);

        /**
         * <p>
         * The collection type.
         * </p>
         * 
         * @param type
         *        The collection type.
         * @see CollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionType
         */
        Builder type(String type);

        /**
         * <p>
         * The collection type.
         * </p>
         * 
         * @param type
         *        The collection type.
         * @see CollectionType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CollectionType
         */
        Builder type(CollectionType type);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private Long createdDate;

        private String description;

        private String id;

        private Long lastModifiedDate;

        private String name;

        private String status;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateCollectionDetail model) {
            arn(model.arn);
            createdDate(model.createdDate);
            description(model.description);
            id(model.id);
            lastModifiedDate(model.lastModifiedDate);
            name(model.name);
            status(model.status);
            type(model.type);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Long getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(CollectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CollectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public UpdateCollectionDetail build() {
            return new UpdateCollectionDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
