/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateSecurityConfigResponse extends OpenSearchServerlessResponse implements
        ToCopyableBuilder<UpdateSecurityConfigResponse.Builder, UpdateSecurityConfigResponse> {
    private static final SdkField<SecurityConfigDetail> SECURITY_CONFIG_DETAIL_FIELD = SdkField
            .<SecurityConfigDetail> builder(MarshallingType.SDK_POJO).memberName("securityConfigDetail")
            .getter(getter(UpdateSecurityConfigResponse::securityConfigDetail)).setter(setter(Builder::securityConfigDetail))
            .constructor(SecurityConfigDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("securityConfigDetail").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SECURITY_CONFIG_DETAIL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SecurityConfigDetail securityConfigDetail;

    private UpdateSecurityConfigResponse(BuilderImpl builder) {
        super(builder);
        this.securityConfigDetail = builder.securityConfigDetail;
    }

    /**
     * <p>
     * Details about the updated security configuration.
     * </p>
     * 
     * @return Details about the updated security configuration.
     */
    public final SecurityConfigDetail securityConfigDetail() {
        return securityConfigDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(securityConfigDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSecurityConfigResponse)) {
            return false;
        }
        UpdateSecurityConfigResponse other = (UpdateSecurityConfigResponse) obj;
        return Objects.equals(securityConfigDetail(), other.securityConfigDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateSecurityConfigResponse").add("SecurityConfigDetail", securityConfigDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "securityConfigDetail":
            return Optional.ofNullable(clazz.cast(securityConfigDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("securityConfigDetail", SECURITY_CONFIG_DETAIL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSecurityConfigResponse, T> g) {
        return obj -> g.apply((UpdateSecurityConfigResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends OpenSearchServerlessResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateSecurityConfigResponse> {
        /**
         * <p>
         * Details about the updated security configuration.
         * </p>
         * 
         * @param securityConfigDetail
         *        Details about the updated security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder securityConfigDetail(SecurityConfigDetail securityConfigDetail);

        /**
         * <p>
         * Details about the updated security configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link SecurityConfigDetail.Builder} avoiding
         * the need to create one manually via {@link SecurityConfigDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SecurityConfigDetail.Builder#build()} is called immediately and
         * its result is passed to {@link #securityConfigDetail(SecurityConfigDetail)}.
         * 
         * @param securityConfigDetail
         *        a consumer that will call methods on {@link SecurityConfigDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #securityConfigDetail(SecurityConfigDetail)
         */
        default Builder securityConfigDetail(Consumer<SecurityConfigDetail.Builder> securityConfigDetail) {
            return securityConfigDetail(SecurityConfigDetail.builder().applyMutation(securityConfigDetail).build());
        }
    }

    static final class BuilderImpl extends OpenSearchServerlessResponse.BuilderImpl implements Builder {
        private SecurityConfigDetail securityConfigDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSecurityConfigResponse model) {
            super(model);
            securityConfigDetail(model.securityConfigDetail);
        }

        public final SecurityConfigDetail.Builder getSecurityConfigDetail() {
            return securityConfigDetail != null ? securityConfigDetail.toBuilder() : null;
        }

        public final void setSecurityConfigDetail(SecurityConfigDetail.BuilderImpl securityConfigDetail) {
            this.securityConfigDetail = securityConfigDetail != null ? securityConfigDetail.build() : null;
        }

        @Override
        public final Builder securityConfigDetail(SecurityConfigDetail securityConfigDetail) {
            this.securityConfigDetail = securityConfigDetail;
            return this;
        }

        @Override
        public UpdateSecurityConfigResponse build() {
            return new UpdateSecurityConfigResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
