/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.opensearchserverless.model.CollectionType;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessRequest;
import software.amazon.awssdk.services.opensearchserverless.model.StandbyReplicas;
import software.amazon.awssdk.services.opensearchserverless.model.Tag;
import software.amazon.awssdk.services.opensearchserverless.model.TagsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateCollectionRequest
extends OpenSearchServerlessRequest
implements ToCopyableBuilder<Builder, CreateCollectionRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateCollectionRequest.getter(CreateCollectionRequest::name)).setter(CreateCollectionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateCollectionRequest.getter(CreateCollectionRequest::typeAsString)).setter(CreateCollectionRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateCollectionRequest.getter(CreateCollectionRequest::description)).setter(CreateCollectionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("tags").getter(CreateCollectionRequest.getter(CreateCollectionRequest::tags)).setter(CreateCollectionRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> STANDBY_REPLICAS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("standbyReplicas").getter(CreateCollectionRequest.getter(CreateCollectionRequest::standbyReplicasAsString)).setter(CreateCollectionRequest.setter(Builder::standbyReplicas)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("standbyReplicas").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateCollectionRequest.getter(CreateCollectionRequest::clientToken)).setter(CreateCollectionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, TYPE_FIELD, DESCRIPTION_FIELD, TAGS_FIELD, STANDBY_REPLICAS_FIELD, CLIENT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateCollectionRequest.memberNameToFieldInitializer();
    private final String name;
    private final String type;
    private final String description;
    private final List<Tag> tags;
    private final String standbyReplicas;
    private final String clientToken;

    private CreateCollectionRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.type = builder.type;
        this.description = builder.description;
        this.tags = builder.tags;
        this.standbyReplicas = builder.standbyReplicas;
        this.clientToken = builder.clientToken;
    }

    public final String name() {
        return this.name;
    }

    public final CollectionType type() {
        return CollectionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public final StandbyReplicas standbyReplicas() {
        return StandbyReplicas.fromValue(this.standbyReplicas);
    }

    public final String standbyReplicasAsString() {
        return this.standbyReplicas;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.standbyReplicasAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCollectionRequest)) {
            return false;
        }
        CreateCollectionRequest other = (CreateCollectionRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.standbyReplicasAsString(), other.standbyReplicasAsString()) && Objects.equals(this.clientToken(), other.clientToken());
    }

    public final String toString() {
        return ToString.builder((String)"CreateCollectionRequest").add("Name", (Object)this.name()).add("Type", (Object)this.typeAsString()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).add("StandbyReplicas", (Object)this.standbyReplicasAsString()).add("ClientToken", (Object)this.clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "standbyReplicas": {
                return Optional.ofNullable(clazz.cast(this.standbyReplicasAsString()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("standbyReplicas", STANDBY_REPLICAS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateCollectionRequest, T> g) {
        return obj -> g.apply((CreateCollectionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends OpenSearchServerlessRequest.BuilderImpl
    implements Builder {
        private String name;
        private String type;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();
        private String standbyReplicas;
        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateCollectionRequest model) {
            super(model);
            this.name(model.name);
            this.type(model.type);
            this.description(model.description);
            this.tags(model.tags);
            this.standbyReplicas(model.standbyReplicas);
            this.clientToken(model.clientToken);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CollectionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagsCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagsCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getStandbyReplicas() {
            return this.standbyReplicas;
        }

        public final void setStandbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
        }

        @Override
        public final Builder standbyReplicas(String standbyReplicas) {
            this.standbyReplicas = standbyReplicas;
            return this;
        }

        @Override
        public final Builder standbyReplicas(StandbyReplicas standbyReplicas) {
            this.standbyReplicas(standbyReplicas == null ? null : standbyReplicas.toString());
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateCollectionRequest build() {
            return new CreateCollectionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends OpenSearchServerlessRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateCollectionRequest> {
        public Builder name(String var1);

        public Builder type(String var1);

        public Builder type(CollectionType var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder standbyReplicas(String var1);

        public Builder standbyReplicas(StandbyReplicas var1);

        public Builder clientToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

