/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics for an OpenSearch Serverless access policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccessPolicyStats implements SdkPojo, Serializable,
        ToCopyableBuilder<AccessPolicyStats.Builder, AccessPolicyStats> {
    private static final SdkField<Long> DATA_POLICY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("DataPolicyCount").getter(getter(AccessPolicyStats::dataPolicyCount))
            .setter(setter(Builder::dataPolicyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPolicyCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_POLICY_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long dataPolicyCount;

    private AccessPolicyStats(BuilderImpl builder) {
        this.dataPolicyCount = builder.dataPolicyCount;
    }

    /**
     * <p>
     * The number of data access policies in the current account.
     * </p>
     * 
     * @return The number of data access policies in the current account.
     */
    public final Long dataPolicyCount() {
        return dataPolicyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dataPolicyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessPolicyStats)) {
            return false;
        }
        AccessPolicyStats other = (AccessPolicyStats) obj;
        return Objects.equals(dataPolicyCount(), other.dataPolicyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccessPolicyStats").add("DataPolicyCount", dataPolicyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataPolicyCount":
            return Optional.ofNullable(clazz.cast(dataPolicyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DataPolicyCount", DATA_POLICY_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AccessPolicyStats, T> g) {
        return obj -> g.apply((AccessPolicyStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccessPolicyStats> {
        /**
         * <p>
         * The number of data access policies in the current account.
         * </p>
         * 
         * @param dataPolicyCount
         *        The number of data access policies in the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPolicyCount(Long dataPolicyCount);
    }

    static final class BuilderImpl implements Builder {
        private Long dataPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(AccessPolicyStats model) {
            dataPolicyCount(model.dataPolicyCount);
        }

        public final Long getDataPolicyCount() {
            return dataPolicyCount;
        }

        public final void setDataPolicyCount(Long dataPolicyCount) {
            this.dataPolicyCount = dataPolicyCount;
        }

        @Override
        public final Builder dataPolicyCount(Long dataPolicyCount) {
            this.dataPolicyCount = dataPolicyCount;
            return this;
        }

        @Override
        public AccessPolicyStats build() {
            return new AccessPolicyStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
