/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateSecurityConfigRequest extends OpenSearchServerlessRequest implements
        ToCopyableBuilder<CreateSecurityConfigRequest.Builder, CreateSecurityConfigRequest> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(CreateSecurityConfigRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateSecurityConfigRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateSecurityConfigRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SamlConfigOptions> SAML_OPTIONS_FIELD = SdkField
            .<SamlConfigOptions> builder(MarshallingType.SDK_POJO).memberName("samlOptions")
            .getter(getter(CreateSecurityConfigRequest::samlOptions)).setter(setter(Builder::samlOptions))
            .constructor(SamlConfigOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("samlOptions").build()).build();

    private static final SdkField<CreateIamIdentityCenterConfigOptions> IAM_IDENTITY_CENTER_OPTIONS_FIELD = SdkField
            .<CreateIamIdentityCenterConfigOptions> builder(MarshallingType.SDK_POJO).memberName("iamIdentityCenterOptions")
            .getter(getter(CreateSecurityConfigRequest::iamIdentityCenterOptions))
            .setter(setter(Builder::iamIdentityCenterOptions)).constructor(CreateIamIdentityCenterConfigOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamIdentityCenterOptions").build())
            .build();

    private static final SdkField<IamFederationConfigOptions> IAM_FEDERATION_OPTIONS_FIELD = SdkField
            .<IamFederationConfigOptions> builder(MarshallingType.SDK_POJO).memberName("iamFederationOptions")
            .getter(getter(CreateSecurityConfigRequest::iamFederationOptions)).setter(setter(Builder::iamFederationOptions))
            .constructor(IamFederationConfigOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamFederationOptions").build())
            .build();

    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateSecurityConfigRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, SAML_OPTIONS_FIELD, IAM_IDENTITY_CENTER_OPTIONS_FIELD, IAM_FEDERATION_OPTIONS_FIELD,
            CLIENT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String type;

    private final String name;

    private final String description;

    private final SamlConfigOptions samlOptions;

    private final CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions;

    private final IamFederationConfigOptions iamFederationOptions;

    private final String clientToken;

    private CreateSecurityConfigRequest(BuilderImpl builder) {
        super(builder);
        this.type = builder.type;
        this.name = builder.name;
        this.description = builder.description;
        this.samlOptions = builder.samlOptions;
        this.iamIdentityCenterOptions = builder.iamIdentityCenterOptions;
        this.iamFederationOptions = builder.iamFederationOptions;
        this.clientToken = builder.clientToken;
    }

    /**
     * <p>
     * The type of security configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of security configuration.
     * @see SecurityConfigType
     */
    public final SecurityConfigType type() {
        return SecurityConfigType.fromValue(type);
    }

    /**
     * <p>
     * The type of security configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of security configuration.
     * @see SecurityConfigType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the security configuration.
     * </p>
     * 
     * @return The name of the security configuration.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A description of the security configuration.
     * </p>
     * 
     * @return A description of the security configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Describes SAML options in in the form of a key-value map. This field is required if you specify <code>SAML</code>
     * for the <code>type</code> parameter.
     * </p>
     * 
     * @return Describes SAML options in in the form of a key-value map. This field is required if you specify
     *         <code>SAML</code> for the <code>type</code> parameter.
     */
    public final SamlConfigOptions samlOptions() {
        return samlOptions;
    }

    /**
     * <p>
     * Describes IAM Identity Center options in the form of a key-value map. This field is required if you specify
     * iamidentitycenter for the type parameter.
     * </p>
     * 
     * @return Describes IAM Identity Center options in the form of a key-value map. This field is required if you
     *         specify iamidentitycenter for the type parameter.
     */
    public final CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions() {
        return iamIdentityCenterOptions;
    }

    /**
     * <p>
     * Describes IAM federation options in the form of a key-value map. This field is required if you specify
     * <code>iamFederation</code> for the <code>type</code> parameter.
     * </p>
     * 
     * @return Describes IAM federation options in the form of a key-value map. This field is required if you specify
     *         <code>iamFederation</code> for the <code>type</code> parameter.
     */
    public final IamFederationConfigOptions iamFederationOptions() {
        return iamFederationOptions;
    }

    /**
     * <p>
     * Unique, case-sensitive identifier to ensure idempotency of the request.
     * </p>
     * 
     * @return Unique, case-sensitive identifier to ensure idempotency of the request.
     */
    public final String clientToken() {
        return clientToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(samlOptions());
        hashCode = 31 * hashCode + Objects.hashCode(iamIdentityCenterOptions());
        hashCode = 31 * hashCode + Objects.hashCode(iamFederationOptions());
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateSecurityConfigRequest)) {
            return false;
        }
        CreateSecurityConfigRequest other = (CreateSecurityConfigRequest) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(samlOptions(), other.samlOptions())
                && Objects.equals(iamIdentityCenterOptions(), other.iamIdentityCenterOptions())
                && Objects.equals(iamFederationOptions(), other.iamFederationOptions())
                && Objects.equals(clientToken(), other.clientToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateSecurityConfigRequest").add("Type", typeAsString()).add("Name", name())
                .add("Description", description()).add("SamlOptions", samlOptions())
                .add("IamIdentityCenterOptions", iamIdentityCenterOptions()).add("IamFederationOptions", iamFederationOptions())
                .add("ClientToken", clientToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "samlOptions":
            return Optional.ofNullable(clazz.cast(samlOptions()));
        case "iamIdentityCenterOptions":
            return Optional.ofNullable(clazz.cast(iamIdentityCenterOptions()));
        case "iamFederationOptions":
            return Optional.ofNullable(clazz.cast(iamFederationOptions()));
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("samlOptions", SAML_OPTIONS_FIELD);
        map.put("iamIdentityCenterOptions", IAM_IDENTITY_CENTER_OPTIONS_FIELD);
        map.put("iamFederationOptions", IAM_FEDERATION_OPTIONS_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateSecurityConfigRequest, T> g) {
        return obj -> g.apply((CreateSecurityConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends OpenSearchServerlessRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateSecurityConfigRequest> {
        /**
         * <p>
         * The type of security configuration.
         * </p>
         * 
         * @param type
         *        The type of security configuration.
         * @see SecurityConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityConfigType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of security configuration.
         * </p>
         * 
         * @param type
         *        The type of security configuration.
         * @see SecurityConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityConfigType
         */
        Builder type(SecurityConfigType type);

        /**
         * <p>
         * The name of the security configuration.
         * </p>
         * 
         * @param name
         *        The name of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A description of the security configuration.
         * </p>
         * 
         * @param description
         *        A description of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Describes SAML options in in the form of a key-value map. This field is required if you specify
         * <code>SAML</code> for the <code>type</code> parameter.
         * </p>
         * 
         * @param samlOptions
         *        Describes SAML options in in the form of a key-value map. This field is required if you specify
         *        <code>SAML</code> for the <code>type</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder samlOptions(SamlConfigOptions samlOptions);

        /**
         * <p>
         * Describes SAML options in in the form of a key-value map. This field is required if you specify
         * <code>SAML</code> for the <code>type</code> parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link SamlConfigOptions.Builder} avoiding the
         * need to create one manually via {@link SamlConfigOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SamlConfigOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #samlOptions(SamlConfigOptions)}.
         * 
         * @param samlOptions
         *        a consumer that will call methods on {@link SamlConfigOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #samlOptions(SamlConfigOptions)
         */
        default Builder samlOptions(Consumer<SamlConfigOptions.Builder> samlOptions) {
            return samlOptions(SamlConfigOptions.builder().applyMutation(samlOptions).build());
        }

        /**
         * <p>
         * Describes IAM Identity Center options in the form of a key-value map. This field is required if you specify
         * iamidentitycenter for the type parameter.
         * </p>
         * 
         * @param iamIdentityCenterOptions
         *        Describes IAM Identity Center options in the form of a key-value map. This field is required if you
         *        specify iamidentitycenter for the type parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions);

        /**
         * <p>
         * Describes IAM Identity Center options in the form of a key-value map. This field is required if you specify
         * iamidentitycenter for the type parameter.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CreateIamIdentityCenterConfigOptions.Builder} avoiding the need to create one manually via
         * {@link CreateIamIdentityCenterConfigOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateIamIdentityCenterConfigOptions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #iamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions)}.
         * 
         * @param iamIdentityCenterOptions
         *        a consumer that will call methods on {@link CreateIamIdentityCenterConfigOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions)
         */
        default Builder iamIdentityCenterOptions(Consumer<CreateIamIdentityCenterConfigOptions.Builder> iamIdentityCenterOptions) {
            return iamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions.builder()
                    .applyMutation(iamIdentityCenterOptions).build());
        }

        /**
         * <p>
         * Describes IAM federation options in the form of a key-value map. This field is required if you specify
         * <code>iamFederation</code> for the <code>type</code> parameter.
         * </p>
         * 
         * @param iamFederationOptions
         *        Describes IAM federation options in the form of a key-value map. This field is required if you specify
         *        <code>iamFederation</code> for the <code>type</code> parameter.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamFederationOptions(IamFederationConfigOptions iamFederationOptions);

        /**
         * <p>
         * Describes IAM federation options in the form of a key-value map. This field is required if you specify
         * <code>iamFederation</code> for the <code>type</code> parameter.
         * </p>
         * This is a convenience method that creates an instance of the {@link IamFederationConfigOptions.Builder}
         * avoiding the need to create one manually via {@link IamFederationConfigOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IamFederationConfigOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #iamFederationOptions(IamFederationConfigOptions)}.
         * 
         * @param iamFederationOptions
         *        a consumer that will call methods on {@link IamFederationConfigOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #iamFederationOptions(IamFederationConfigOptions)
         */
        default Builder iamFederationOptions(Consumer<IamFederationConfigOptions.Builder> iamFederationOptions) {
            return iamFederationOptions(IamFederationConfigOptions.builder().applyMutation(iamFederationOptions).build());
        }

        /**
         * <p>
         * Unique, case-sensitive identifier to ensure idempotency of the request.
         * </p>
         * 
         * @param clientToken
         *        Unique, case-sensitive identifier to ensure idempotency of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends OpenSearchServerlessRequest.BuilderImpl implements Builder {
        private String type;

        private String name;

        private String description;

        private SamlConfigOptions samlOptions;

        private CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions;

        private IamFederationConfigOptions iamFederationOptions;

        private String clientToken;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateSecurityConfigRequest model) {
            super(model);
            type(model.type);
            name(model.name);
            description(model.description);
            samlOptions(model.samlOptions);
            iamIdentityCenterOptions(model.iamIdentityCenterOptions);
            iamFederationOptions(model.iamFederationOptions);
            clientToken(model.clientToken);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SamlConfigOptions.Builder getSamlOptions() {
            return samlOptions != null ? samlOptions.toBuilder() : null;
        }

        public final void setSamlOptions(SamlConfigOptions.BuilderImpl samlOptions) {
            this.samlOptions = samlOptions != null ? samlOptions.build() : null;
        }

        @Override
        public final Builder samlOptions(SamlConfigOptions samlOptions) {
            this.samlOptions = samlOptions;
            return this;
        }

        public final CreateIamIdentityCenterConfigOptions.Builder getIamIdentityCenterOptions() {
            return iamIdentityCenterOptions != null ? iamIdentityCenterOptions.toBuilder() : null;
        }

        public final void setIamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions.BuilderImpl iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions != null ? iamIdentityCenterOptions.build() : null;
        }

        @Override
        public final Builder iamIdentityCenterOptions(CreateIamIdentityCenterConfigOptions iamIdentityCenterOptions) {
            this.iamIdentityCenterOptions = iamIdentityCenterOptions;
            return this;
        }

        public final IamFederationConfigOptions.Builder getIamFederationOptions() {
            return iamFederationOptions != null ? iamFederationOptions.toBuilder() : null;
        }

        public final void setIamFederationOptions(IamFederationConfigOptions.BuilderImpl iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions != null ? iamFederationOptions.build() : null;
        }

        @Override
        public final Builder iamFederationOptions(IamFederationConfigOptions iamFederationOptions) {
            this.iamFederationOptions = iamFederationOptions;
            return this;
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateSecurityConfigRequest build() {
            return new CreateSecurityConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
