/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes SAML options for an OpenSearch Serverless security configuration in the form of a key-value map.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SamlConfigOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<SamlConfigOptions.Builder, SamlConfigOptions> {
    private static final SdkField<String> METADATA_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("metadata").getter(getter(SamlConfigOptions::metadata)).setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("metadata").build()).build();

    private static final SdkField<String> USER_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("userAttribute").getter(getter(SamlConfigOptions::userAttribute)).setter(setter(Builder::userAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userAttribute").build()).build();

    private static final SdkField<String> GROUP_ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("groupAttribute").getter(getter(SamlConfigOptions::groupAttribute))
            .setter(setter(Builder::groupAttribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupAttribute").build()).build();

    private static final SdkField<String> OPEN_SEARCH_SERVERLESS_ENTITY_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("openSearchServerlessEntityId")
            .getter(getter(SamlConfigOptions::openSearchServerlessEntityId))
            .setter(setter(Builder::openSearchServerlessEntityId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openSearchServerlessEntityId")
                    .build()).build();

    private static final SdkField<Integer> SESSION_TIMEOUT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("sessionTimeout").getter(getter(SamlConfigOptions::sessionTimeout))
            .setter(setter(Builder::sessionTimeout))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionTimeout").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_FIELD,
            USER_ATTRIBUTE_FIELD, GROUP_ATTRIBUTE_FIELD, OPEN_SEARCH_SERVERLESS_ENTITY_ID_FIELD, SESSION_TIMEOUT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String metadata;

    private final String userAttribute;

    private final String groupAttribute;

    private final String openSearchServerlessEntityId;

    private final Integer sessionTimeout;

    private SamlConfigOptions(BuilderImpl builder) {
        this.metadata = builder.metadata;
        this.userAttribute = builder.userAttribute;
        this.groupAttribute = builder.groupAttribute;
        this.openSearchServerlessEntityId = builder.openSearchServerlessEntityId;
        this.sessionTimeout = builder.sessionTimeout;
    }

    /**
     * <p>
     * The XML IdP metadata file generated from your identity provider.
     * </p>
     * 
     * @return The XML IdP metadata file generated from your identity provider.
     */
    public final String metadata() {
        return metadata;
    }

    /**
     * <p>
     * A user attribute for this SAML integration.
     * </p>
     * 
     * @return A user attribute for this SAML integration.
     */
    public final String userAttribute() {
        return userAttribute;
    }

    /**
     * <p>
     * The group attribute for this SAML integration.
     * </p>
     * 
     * @return The group attribute for this SAML integration.
     */
    public final String groupAttribute() {
        return groupAttribute;
    }

    /**
     * <p>
     * Custom entity ID attribute to override the default entity ID for this SAML integration.
     * </p>
     * 
     * @return Custom entity ID attribute to override the default entity ID for this SAML integration.
     */
    public final String openSearchServerlessEntityId() {
        return openSearchServerlessEntityId;
    }

    /**
     * <p>
     * The session timeout, in minutes. Default is 60 minutes (12 hours).
     * </p>
     * 
     * @return The session timeout, in minutes. Default is 60 minutes (12 hours).
     */
    public final Integer sessionTimeout() {
        return sessionTimeout;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        hashCode = 31 * hashCode + Objects.hashCode(userAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(groupAttribute());
        hashCode = 31 * hashCode + Objects.hashCode(openSearchServerlessEntityId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionTimeout());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SamlConfigOptions)) {
            return false;
        }
        SamlConfigOptions other = (SamlConfigOptions) obj;
        return Objects.equals(metadata(), other.metadata()) && Objects.equals(userAttribute(), other.userAttribute())
                && Objects.equals(groupAttribute(), other.groupAttribute())
                && Objects.equals(openSearchServerlessEntityId(), other.openSearchServerlessEntityId())
                && Objects.equals(sessionTimeout(), other.sessionTimeout());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SamlConfigOptions").add("Metadata", metadata()).add("UserAttribute", userAttribute())
                .add("GroupAttribute", groupAttribute()).add("OpenSearchServerlessEntityId", openSearchServerlessEntityId())
                .add("SessionTimeout", sessionTimeout()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        case "userAttribute":
            return Optional.ofNullable(clazz.cast(userAttribute()));
        case "groupAttribute":
            return Optional.ofNullable(clazz.cast(groupAttribute()));
        case "openSearchServerlessEntityId":
            return Optional.ofNullable(clazz.cast(openSearchServerlessEntityId()));
        case "sessionTimeout":
            return Optional.ofNullable(clazz.cast(sessionTimeout()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("metadata", METADATA_FIELD);
        map.put("userAttribute", USER_ATTRIBUTE_FIELD);
        map.put("groupAttribute", GROUP_ATTRIBUTE_FIELD);
        map.put("openSearchServerlessEntityId", OPEN_SEARCH_SERVERLESS_ENTITY_ID_FIELD);
        map.put("sessionTimeout", SESSION_TIMEOUT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SamlConfigOptions, T> g) {
        return obj -> g.apply((SamlConfigOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SamlConfigOptions> {
        /**
         * <p>
         * The XML IdP metadata file generated from your identity provider.
         * </p>
         * 
         * @param metadata
         *        The XML IdP metadata file generated from your identity provider.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(String metadata);

        /**
         * <p>
         * A user attribute for this SAML integration.
         * </p>
         * 
         * @param userAttribute
         *        A user attribute for this SAML integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userAttribute(String userAttribute);

        /**
         * <p>
         * The group attribute for this SAML integration.
         * </p>
         * 
         * @param groupAttribute
         *        The group attribute for this SAML integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupAttribute(String groupAttribute);

        /**
         * <p>
         * Custom entity ID attribute to override the default entity ID for this SAML integration.
         * </p>
         * 
         * @param openSearchServerlessEntityId
         *        Custom entity ID attribute to override the default entity ID for this SAML integration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openSearchServerlessEntityId(String openSearchServerlessEntityId);

        /**
         * <p>
         * The session timeout, in minutes. Default is 60 minutes (12 hours).
         * </p>
         * 
         * @param sessionTimeout
         *        The session timeout, in minutes. Default is 60 minutes (12 hours).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionTimeout(Integer sessionTimeout);
    }

    static final class BuilderImpl implements Builder {
        private String metadata;

        private String userAttribute;

        private String groupAttribute;

        private String openSearchServerlessEntityId;

        private Integer sessionTimeout;

        private BuilderImpl() {
        }

        private BuilderImpl(SamlConfigOptions model) {
            metadata(model.metadata);
            userAttribute(model.userAttribute);
            groupAttribute(model.groupAttribute);
            openSearchServerlessEntityId(model.openSearchServerlessEntityId);
            sessionTimeout(model.sessionTimeout);
        }

        public final String getMetadata() {
            return metadata;
        }

        public final void setMetadata(String metadata) {
            this.metadata = metadata;
        }

        @Override
        public final Builder metadata(String metadata) {
            this.metadata = metadata;
            return this;
        }

        public final String getUserAttribute() {
            return userAttribute;
        }

        public final void setUserAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
        }

        @Override
        public final Builder userAttribute(String userAttribute) {
            this.userAttribute = userAttribute;
            return this;
        }

        public final String getGroupAttribute() {
            return groupAttribute;
        }

        public final void setGroupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
        }

        @Override
        public final Builder groupAttribute(String groupAttribute) {
            this.groupAttribute = groupAttribute;
            return this;
        }

        public final String getOpenSearchServerlessEntityId() {
            return openSearchServerlessEntityId;
        }

        public final void setOpenSearchServerlessEntityId(String openSearchServerlessEntityId) {
            this.openSearchServerlessEntityId = openSearchServerlessEntityId;
        }

        @Override
        public final Builder openSearchServerlessEntityId(String openSearchServerlessEntityId) {
            this.openSearchServerlessEntityId = openSearchServerlessEntityId;
            return this;
        }

        public final Integer getSessionTimeout() {
            return sessionTimeout;
        }

        public final void setSessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
        }

        @Override
        public final Builder sessionTimeout(Integer sessionTimeout) {
            this.sessionTimeout = sessionTimeout;
            return this;
        }

        @Override
        public SamlConfigOptions build() {
            return new SamlConfigOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
