/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of a security configuration for OpenSearch Serverless.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityConfigSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityConfigSummary.Builder, SecurityConfigSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("id")
            .getter(getter(SecurityConfigSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SecurityConfigSummary::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> CONFIG_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("configVersion").getter(getter(SecurityConfigSummary::configVersion))
            .setter(setter(Builder::configVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SecurityConfigSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createdDate").getter(getter(SecurityConfigSummary::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedDate").getter(getter(SecurityConfigSummary::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, TYPE_FIELD,
            CONFIG_VERSION_FIELD, DESCRIPTION_FIELD, CREATED_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String type;

    private final String configVersion;

    private final String description;

    private final Long createdDate;

    private final Long lastModifiedDate;

    private SecurityConfigSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.type = builder.type;
        this.configVersion = builder.configVersion;
        this.description = builder.description;
        this.createdDate = builder.createdDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The unique identifier of the security configuration.
     * </p>
     * 
     * @return The unique identifier of the security configuration.
     */
    public final String id() {
        return id;
    }

    /**
     * <p>
     * The type of security configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of security configuration.
     * @see SecurityConfigType
     */
    public final SecurityConfigType type() {
        return SecurityConfigType.fromValue(type);
    }

    /**
     * <p>
     * The type of security configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityConfigType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of security configuration.
     * @see SecurityConfigType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The version of the security configuration.
     * </p>
     * 
     * @return The version of the security configuration.
     */
    public final String configVersion() {
        return configVersion;
    }

    /**
     * <p>
     * The description of the security configuration.
     * </p>
     * 
     * @return The description of the security configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Epoch time when the security configuration was created.
     * </p>
     * 
     * @return The Epoch time when the security configuration was created.
     */
    public final Long createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp of when the configuration was last modified.
     * </p>
     * 
     * @return The timestamp of when the configuration was last modified.
     */
    public final Long lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(configVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityConfigSummary)) {
            return false;
        }
        SecurityConfigSummary other = (SecurityConfigSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(configVersion(), other.configVersion()) && Objects.equals(description(), other.description())
                && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityConfigSummary").add("Id", id()).add("Type", typeAsString())
                .add("ConfigVersion", configVersion()).add("Description", description()).add("CreatedDate", createdDate())
                .add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "id":
            return Optional.ofNullable(clazz.cast(id()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "configVersion":
            return Optional.ofNullable(clazz.cast(configVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("id", ID_FIELD);
        map.put("type", TYPE_FIELD);
        map.put("configVersion", CONFIG_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityConfigSummary, T> g) {
        return obj -> g.apply((SecurityConfigSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityConfigSummary> {
        /**
         * <p>
         * The unique identifier of the security configuration.
         * </p>
         * 
         * @param id
         *        The unique identifier of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The type of security configuration.
         * </p>
         * 
         * @param type
         *        The type of security configuration.
         * @see SecurityConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityConfigType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of security configuration.
         * </p>
         * 
         * @param type
         *        The type of security configuration.
         * @see SecurityConfigType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityConfigType
         */
        Builder type(SecurityConfigType type);

        /**
         * <p>
         * The version of the security configuration.
         * </p>
         * 
         * @param configVersion
         *        The version of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder configVersion(String configVersion);

        /**
         * <p>
         * The description of the security configuration.
         * </p>
         * 
         * @param description
         *        The description of the security configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Epoch time when the security configuration was created.
         * </p>
         * 
         * @param createdDate
         *        The Epoch time when the security configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Long createdDate);

        /**
         * <p>
         * The timestamp of when the configuration was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The timestamp of when the configuration was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Long lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String type;

        private String configVersion;

        private String description;

        private Long createdDate;

        private Long lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityConfigSummary model) {
            id(model.id);
            type(model.type);
            configVersion(model.configVersion);
            description(model.description);
            createdDate(model.createdDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getId() {
            return id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityConfigType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getConfigVersion() {
            return configVersion;
        }

        public final void setConfigVersion(String configVersion) {
            this.configVersion = configVersion;
        }

        @Override
        public final Builder configVersion(String configVersion) {
            this.configVersion = configVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Long getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Long getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public SecurityConfigSummary build() {
            return new SecurityConfigSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
