/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Details about an OpenSearch Serverless security policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityPolicyDetail implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityPolicyDetail.Builder, SecurityPolicyDetail> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(SecurityPolicyDetail::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(SecurityPolicyDetail::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> POLICY_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("policyVersion").getter(getter(SecurityPolicyDetail::policyVersion))
            .setter(setter(Builder::policyVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policyVersion").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(SecurityPolicyDetail::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<Document> POLICY_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("policy").getter(getter(SecurityPolicyDetail::policy)).setter(setter(Builder::policy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("policy").build()).build();

    private static final SdkField<Long> CREATED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("createdDate").getter(getter(SecurityPolicyDetail::createdDate)).setter(setter(Builder::createdDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdDate").build()).build();

    private static final SdkField<Long> LAST_MODIFIED_DATE_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("lastModifiedDate").getter(getter(SecurityPolicyDetail::lastModifiedDate))
            .setter(setter(Builder::lastModifiedDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastModifiedDate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, NAME_FIELD,
            POLICY_VERSION_FIELD, DESCRIPTION_FIELD, POLICY_FIELD, CREATED_DATE_FIELD, LAST_MODIFIED_DATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String name;

    private final String policyVersion;

    private final String description;

    private final Document policy;

    private final Long createdDate;

    private final Long lastModifiedDate;

    private SecurityPolicyDetail(BuilderImpl builder) {
        this.type = builder.type;
        this.name = builder.name;
        this.policyVersion = builder.policyVersion;
        this.description = builder.description;
        this.policy = builder.policy;
        this.createdDate = builder.createdDate;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    /**
     * <p>
     * The type of security policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of security policy.
     * @see SecurityPolicyType
     */
    public final SecurityPolicyType type() {
        return SecurityPolicyType.fromValue(type);
    }

    /**
     * <p>
     * The type of security policy.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link SecurityPolicyType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of security policy.
     * @see SecurityPolicyType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The name of the policy.
     * </p>
     * 
     * @return The name of the policy.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The version of the policy.
     * </p>
     * 
     * @return The version of the policy.
     */
    public final String policyVersion() {
        return policyVersion;
    }

    /**
     * <p>
     * The description of the security policy.
     * </p>
     * 
     * @return The description of the security policy.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The JSON policy document without any whitespaces.
     * </p>
     * 
     * @return The JSON policy document without any whitespaces.
     */
    public final Document policy() {
        return policy;
    }

    /**
     * <p>
     * The date the policy was created.
     * </p>
     * 
     * @return The date the policy was created.
     */
    public final Long createdDate() {
        return createdDate;
    }

    /**
     * <p>
     * The timestamp of when the policy was last modified.
     * </p>
     * 
     * @return The timestamp of when the policy was last modified.
     */
    public final Long lastModifiedDate() {
        return lastModifiedDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(policyVersion());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(policy());
        hashCode = 31 * hashCode + Objects.hashCode(createdDate());
        hashCode = 31 * hashCode + Objects.hashCode(lastModifiedDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityPolicyDetail)) {
            return false;
        }
        SecurityPolicyDetail other = (SecurityPolicyDetail) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(name(), other.name())
                && Objects.equals(policyVersion(), other.policyVersion()) && Objects.equals(description(), other.description())
                && Objects.equals(policy(), other.policy()) && Objects.equals(createdDate(), other.createdDate())
                && Objects.equals(lastModifiedDate(), other.lastModifiedDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityPolicyDetail").add("Type", typeAsString()).add("Name", name())
                .add("PolicyVersion", policyVersion()).add("Description", description()).add("Policy", policy())
                .add("CreatedDate", createdDate()).add("LastModifiedDate", lastModifiedDate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "policyVersion":
            return Optional.ofNullable(clazz.cast(policyVersion()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "policy":
            return Optional.ofNullable(clazz.cast(policy()));
        case "createdDate":
            return Optional.ofNullable(clazz.cast(createdDate()));
        case "lastModifiedDate":
            return Optional.ofNullable(clazz.cast(lastModifiedDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("type", TYPE_FIELD);
        map.put("name", NAME_FIELD);
        map.put("policyVersion", POLICY_VERSION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("policy", POLICY_FIELD);
        map.put("createdDate", CREATED_DATE_FIELD);
        map.put("lastModifiedDate", LAST_MODIFIED_DATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityPolicyDetail, T> g) {
        return obj -> g.apply((SecurityPolicyDetail) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityPolicyDetail> {
        /**
         * <p>
         * The type of security policy.
         * </p>
         * 
         * @param type
         *        The type of security policy.
         * @see SecurityPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityPolicyType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of security policy.
         * </p>
         * 
         * @param type
         *        The type of security policy.
         * @see SecurityPolicyType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SecurityPolicyType
         */
        Builder type(SecurityPolicyType type);

        /**
         * <p>
         * The name of the policy.
         * </p>
         * 
         * @param name
         *        The name of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The version of the policy.
         * </p>
         * 
         * @param policyVersion
         *        The version of the policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyVersion(String policyVersion);

        /**
         * <p>
         * The description of the security policy.
         * </p>
         * 
         * @param description
         *        The description of the security policy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The JSON policy document without any whitespaces.
         * </p>
         * 
         * @param policy
         *        The JSON policy document without any whitespaces.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policy(Document policy);

        /**
         * <p>
         * The date the policy was created.
         * </p>
         * 
         * @param createdDate
         *        The date the policy was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdDate(Long createdDate);

        /**
         * <p>
         * The timestamp of when the policy was last modified.
         * </p>
         * 
         * @param lastModifiedDate
         *        The timestamp of when the policy was last modified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastModifiedDate(Long lastModifiedDate);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String name;

        private String policyVersion;

        private String description;

        private Document policy;

        private Long createdDate;

        private Long lastModifiedDate;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityPolicyDetail model) {
            type(model.type);
            name(model.name);
            policyVersion(model.policyVersion);
            description(model.description);
            policy(model.policy);
            createdDate(model.createdDate);
            lastModifiedDate(model.lastModifiedDate);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SecurityPolicyType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getPolicyVersion() {
            return policyVersion;
        }

        public final void setPolicyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
        }

        @Override
        public final Builder policyVersion(String policyVersion) {
            this.policyVersion = policyVersion;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Document getPolicy() {
            return policy;
        }

        public final void setPolicy(Document policy) {
            this.policy = policy;
        }

        @Override
        public final Builder policy(Document policy) {
            this.policy = policy;
            return this;
        }

        public final Long getCreatedDate() {
            return createdDate;
        }

        public final void setCreatedDate(Long createdDate) {
            this.createdDate = createdDate;
        }

        @Override
        public final Builder createdDate(Long createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public final Long getLastModifiedDate() {
            return lastModifiedDate;
        }

        public final void setLastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
        }

        @Override
        public final Builder lastModifiedDate(Long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        @Override
        public SecurityPolicyDetail build() {
            return new SecurityPolicyDetail(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
