/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Statistics for an OpenSearch Serverless security policy.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SecurityPolicyStats implements SdkPojo, Serializable,
        ToCopyableBuilder<SecurityPolicyStats.Builder, SecurityPolicyStats> {
    private static final SdkField<Long> ENCRYPTION_POLICY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("EncryptionPolicyCount").getter(getter(SecurityPolicyStats::encryptionPolicyCount))
            .setter(setter(Builder::encryptionPolicyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionPolicyCount").build())
            .build();

    private static final SdkField<Long> NETWORK_POLICY_COUNT_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NetworkPolicyCount").getter(getter(SecurityPolicyStats::networkPolicyCount))
            .setter(setter(Builder::networkPolicyCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkPolicyCount").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENCRYPTION_POLICY_COUNT_FIELD,
            NETWORK_POLICY_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long encryptionPolicyCount;

    private final Long networkPolicyCount;

    private SecurityPolicyStats(BuilderImpl builder) {
        this.encryptionPolicyCount = builder.encryptionPolicyCount;
        this.networkPolicyCount = builder.networkPolicyCount;
    }

    /**
     * <p>
     * The number of encryption policies in the current account.
     * </p>
     * 
     * @return The number of encryption policies in the current account.
     */
    public final Long encryptionPolicyCount() {
        return encryptionPolicyCount;
    }

    /**
     * <p>
     * The number of network policies in the current account.
     * </p>
     * 
     * @return The number of network policies in the current account.
     */
    public final Long networkPolicyCount() {
        return networkPolicyCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(encryptionPolicyCount());
        hashCode = 31 * hashCode + Objects.hashCode(networkPolicyCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SecurityPolicyStats)) {
            return false;
        }
        SecurityPolicyStats other = (SecurityPolicyStats) obj;
        return Objects.equals(encryptionPolicyCount(), other.encryptionPolicyCount())
                && Objects.equals(networkPolicyCount(), other.networkPolicyCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SecurityPolicyStats").add("EncryptionPolicyCount", encryptionPolicyCount())
                .add("NetworkPolicyCount", networkPolicyCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EncryptionPolicyCount":
            return Optional.ofNullable(clazz.cast(encryptionPolicyCount()));
        case "NetworkPolicyCount":
            return Optional.ofNullable(clazz.cast(networkPolicyCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EncryptionPolicyCount", ENCRYPTION_POLICY_COUNT_FIELD);
        map.put("NetworkPolicyCount", NETWORK_POLICY_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SecurityPolicyStats, T> g) {
        return obj -> g.apply((SecurityPolicyStats) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SecurityPolicyStats> {
        /**
         * <p>
         * The number of encryption policies in the current account.
         * </p>
         * 
         * @param encryptionPolicyCount
         *        The number of encryption policies in the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder encryptionPolicyCount(Long encryptionPolicyCount);

        /**
         * <p>
         * The number of network policies in the current account.
         * </p>
         * 
         * @param networkPolicyCount
         *        The number of network policies in the current account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkPolicyCount(Long networkPolicyCount);
    }

    static final class BuilderImpl implements Builder {
        private Long encryptionPolicyCount;

        private Long networkPolicyCount;

        private BuilderImpl() {
        }

        private BuilderImpl(SecurityPolicyStats model) {
            encryptionPolicyCount(model.encryptionPolicyCount);
            networkPolicyCount(model.networkPolicyCount);
        }

        public final Long getEncryptionPolicyCount() {
            return encryptionPolicyCount;
        }

        public final void setEncryptionPolicyCount(Long encryptionPolicyCount) {
            this.encryptionPolicyCount = encryptionPolicyCount;
        }

        @Override
        public final Builder encryptionPolicyCount(Long encryptionPolicyCount) {
            this.encryptionPolicyCount = encryptionPolicyCount;
            return this;
        }

        public final Long getNetworkPolicyCount() {
            return networkPolicyCount;
        }

        public final void setNetworkPolicyCount(Long networkPolicyCount) {
            this.networkPolicyCount = networkPolicyCount;
        }

        @Override
        public final Builder networkPolicyCount(Long networkPolicyCount) {
            this.networkPolicyCount = networkPolicyCount;
            return this;
        }

        @Override
        public SecurityPolicyStats build() {
            return new SecurityPolicyStats(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
