/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.opensearchserverless;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ConflictException;
import software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateIndexRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateIndexResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteIndexRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteIndexResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetIndexRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetIndexResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.InternalServerException;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.OcuLimitExceededException;
import software.amazon.awssdk.services.opensearchserverless.model.OpenSearchServerlessException;
import software.amazon.awssdk.services.opensearchserverless.model.ResourceNotFoundException;
import software.amazon.awssdk.services.opensearchserverless.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest;
import software.amazon.awssdk.services.opensearchserverless.model.TagResourceResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UntagResourceRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UntagResourceResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateIndexRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateIndexResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyResponse;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest;
import software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointResponse;
import software.amazon.awssdk.services.opensearchserverless.model.ValidationException;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesIterable;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsIterable;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesIterable;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsIterable;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesIterable;
import software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsIterable;

/**
 * Service client for accessing OpenSearch Service Serverless. This can be created using the static {@link #builder()}
 * method.
 *
 * <p>
 * Use the Amazon OpenSearch Serverless API to create, configure, and manage OpenSearch Serverless collections and
 * security policies.
 * </p>
 * <p>
 * OpenSearch Serverless is an on-demand, pre-provisioned serverless configuration for Amazon OpenSearch Service.
 * OpenSearch Serverless removes the operational complexities of provisioning, configuring, and tuning your OpenSearch
 * clusters. It enables you to easily search and analyze petabytes of data without having to worry about the underlying
 * infrastructure and data management.
 * </p>
 * <p>
 * To learn more about OpenSearch Serverless, see <a
 * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-overview.html">What is Amazon
 * OpenSearch Serverless?</a>
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface OpenSearchServerlessClient extends AwsClient {
    String SERVICE_NAME = "aoss";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "aoss";

    /**
     * <p>
     * Returns attributes for one or more collections, including the collection endpoint, the OpenSearch Dashboards
     * endpoint, and FIPS-compliant endpoints. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param batchGetCollectionRequest
     * @return Result of the BatchGetCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCollectionResponse batchGetCollection(BatchGetCollectionRequest batchGetCollectionRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns attributes for one or more collections, including the collection endpoint, the OpenSearch Dashboards
     * endpoint, and FIPS-compliant endpoints. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetCollectionRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetCollectionRequest#builder()}
     * </p>
     *
     * @param batchGetCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetCollectionRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetCollectionResponse batchGetCollection(Consumer<BatchGetCollectionRequest.Builder> batchGetCollectionRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return batchGetCollection(BatchGetCollectionRequest.builder().applyMutation(batchGetCollectionRequest).build());
    }

    /**
     * <p>
     * Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     *
     * @param batchGetEffectiveLifecyclePolicyRequest
     * @return Result of the BatchGetEffectiveLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetEffectiveLifecyclePolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetEffectiveLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetEffectiveLifecyclePolicyResponse batchGetEffectiveLifecyclePolicy(
            BatchGetEffectiveLifecyclePolicyRequest batchGetEffectiveLifecyclePolicyRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of successful and failed retrievals for the OpenSearch Serverless indexes. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetEffectiveLifecyclePolicyRequest.Builder}
     * avoiding the need to create one manually via {@link BatchGetEffectiveLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param batchGetEffectiveLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetEffectiveLifecyclePolicyRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetEffectiveLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetEffectiveLifecyclePolicy
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetEffectiveLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetEffectiveLifecyclePolicyResponse batchGetEffectiveLifecyclePolicy(
            Consumer<BatchGetEffectiveLifecyclePolicyRequest.Builder> batchGetEffectiveLifecyclePolicyRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return batchGetEffectiveLifecyclePolicy(BatchGetEffectiveLifecyclePolicyRequest.builder()
                .applyMutation(batchGetEffectiveLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     *
     * @param batchGetLifecyclePolicyRequest
     * @return Result of the BatchGetLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetLifecyclePolicyResponse batchGetLifecyclePolicy(BatchGetLifecyclePolicyRequest batchGetLifecyclePolicyRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns one or more configured OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetLifecyclePolicyRequest.Builder} avoiding
     * the need to create one manually via {@link BatchGetLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param batchGetLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetLifecyclePolicyRequest.Builder}
     *        to create a request.
     * @return Result of the BatchGetLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetLifecyclePolicyResponse batchGetLifecyclePolicy(
            Consumer<BatchGetLifecyclePolicyRequest.Builder> batchGetLifecyclePolicyRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return batchGetLifecyclePolicy(BatchGetLifecyclePolicyRequest.builder().applyMutation(batchGetLifecyclePolicyRequest)
                .build());
    }

    /**
     * <p>
     * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param batchGetVpcEndpointRequest
     * @return Result of the BatchGetVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetVpcEndpointResponse batchGetVpcEndpoint(BatchGetVpcEndpointRequest batchGetVpcEndpointRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns attributes for one or more VPC endpoints associated with the current account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetVpcEndpointRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetVpcEndpointRequest#builder()}
     * </p>
     *
     * @param batchGetVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.BatchGetVpcEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the BatchGetVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.BatchGetVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/BatchGetVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchGetVpcEndpointResponse batchGetVpcEndpoint(
            Consumer<BatchGetVpcEndpointRequest.Builder> batchGetVpcEndpointRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return batchGetVpcEndpoint(BatchGetVpcEndpointRequest.builder().applyMutation(batchGetVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the
     * resources within them, and allow a user to access that data irrespective of the access mechanism or network
     * source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param createAccessPolicyRequest
     * @return Result of the CreateAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessPolicyResponse createAccessPolicy(CreateAccessPolicyRequest createAccessPolicyRequest)
            throws InternalServerException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a data access policy for OpenSearch Serverless. Access policies limit access to collections and the
     * resources within them, and allow a user to access that data irrespective of the access mechanism or network
     * source. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param createAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateAccessPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the CreateAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateAccessPolicyResponse createAccessPolicy(Consumer<CreateAccessPolicyRequest.Builder> createAccessPolicyRequest)
            throws InternalServerException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return createAccessPolicy(CreateAccessPolicyRequest.builder().applyMutation(createAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Creates a new OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param createCollectionRequest
     * @return Result of the CreateCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws OcuLimitExceededException
     *         Thrown when the collection you're attempting to create results in a number of search or indexing OCUs
     *         that exceeds the account limit.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCollectionResponse createCollection(CreateCollectionRequest createCollectionRequest)
            throws InternalServerException, OcuLimitExceededException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link CreateCollectionRequest#builder()}
     * </p>
     *
     * @param createCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateCollectionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws OcuLimitExceededException
     *         Thrown when the collection you're attempting to create results in a number of search or indexing OCUs
     *         that exceeds the account limit.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateCollectionResponse createCollection(Consumer<CreateCollectionRequest.Builder> createCollectionRequest)
            throws InternalServerException, OcuLimitExceededException, ConflictException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return createCollection(CreateCollectionRequest.builder().applyMutation(createCollectionRequest).build());
    }

    /**
     * <p>
     * Creates an index within an OpenSearch Serverless collection. Unlike other OpenSearch indexes, indexes created by
     * this API are automatically configured to conduct automatic semantic enrichment ingestion and search. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a> in the <i>OpenSearch User Guide</i>.
     * </p>
     *
     * @param createIndexRequest
     * @return Result of the CreateIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIndexResponse createIndex(CreateIndexRequest createIndexRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an index within an OpenSearch Serverless collection. Unlike other OpenSearch indexes, indexes created by
     * this API are automatically configured to conduct automatic semantic enrichment ingestion and search. For more
     * information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a> in the <i>OpenSearch User Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link CreateIndexRequest#builder()}
     * </p>
     *
     * @param createIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateIndexRequest.Builder} to create a
     *        request.
     * @return Result of the CreateIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateIndexResponse createIndex(Consumer<CreateIndexRequest.Builder> createIndexRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return createIndex(CreateIndexRequest.builder().applyMutation(createIndexRequest).build());
    }

    /**
     * <p>
     * Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of
     * days or hours to retain the data on an OpenSearch Serverless index. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create"
     * >Creating data lifecycle policies</a>.
     * </p>
     *
     * @param createLifecyclePolicyRequest
     * @return Result of the CreateLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLifecyclePolicyResponse createLifecyclePolicy(CreateLifecyclePolicyRequest createLifecyclePolicyRequest)
            throws InternalServerException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a lifecyle policy to be applied to OpenSearch Serverless indexes. Lifecycle policies define the number of
     * days or hours to retain the data on an OpenSearch Serverless index. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-create"
     * >Creating data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param createLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateLifecyclePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLifecyclePolicyResponse createLifecyclePolicy(
            Consumer<CreateLifecyclePolicyRequest.Builder> createLifecyclePolicyRequest) throws InternalServerException,
            ConflictException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return createLifecyclePolicy(CreateLifecyclePolicyRequest.builder().applyMutation(createLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Specifies a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param createSecurityConfigRequest
     * @return Result of the CreateSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityConfigResponse createSecurityConfig(CreateSecurityConfigRequest createSecurityConfigRequest)
            throws InternalServerException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Specifies a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityConfigRequest#builder()}
     * </p>
     *
     * @param createSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityConfigRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityConfigResponse createSecurityConfig(
            Consumer<CreateSecurityConfigRequest.Builder> createSecurityConfigRequest) throws InternalServerException,
            ConflictException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return createSecurityConfig(CreateSecurityConfigRequest.builder().applyMutation(createSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide
     * access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints.
     * They also allow you to secure a collection with a KMS encryption key. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param createSecurityPolicyRequest
     * @return Result of the CreateSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityPolicyResponse createSecurityPolicy(CreateSecurityPolicyRequest createSecurityPolicyRequest)
            throws InternalServerException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a security policy to be used by one or more OpenSearch Serverless collections. Security policies provide
     * access to a collection and its OpenSearch Dashboards endpoint from public networks or specific VPC endpoints.
     * They also allow you to secure a collection with a KMS encryption key. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link CreateSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param createSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the CreateSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateSecurityPolicyResponse createSecurityPolicy(
            Consumer<CreateSecurityPolicyRequest.Builder> createSecurityPolicyRequest) throws InternalServerException,
            ConflictException, ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return createSecurityPolicy(CreateSecurityPolicyRequest.builder().applyMutation(createSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param createVpcEndpointRequest
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointResponse createVpcEndpoint(CreateVpcEndpointRequest createVpcEndpointRequest)
            throws InternalServerException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an OpenSearch Serverless-managed interface VPC endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link CreateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param createVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.CreateVpcEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the CreateVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.CreateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/CreateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateVpcEndpointResponse createVpcEndpoint(Consumer<CreateVpcEndpointRequest.Builder> createVpcEndpointRequest)
            throws InternalServerException, ConflictException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return createVpcEndpoint(CreateVpcEndpointRequest.builder().applyMutation(createVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param deleteAccessPolicyRequest
     * @return Result of the DeleteAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessPolicyResponse deleteAccessPolicy(DeleteAccessPolicyRequest deleteAccessPolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteAccessPolicyRequest#builder()}
     * </p>
     *
     * @param deleteAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteAccessPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteAccessPolicyResponse deleteAccessPolicy(Consumer<DeleteAccessPolicyRequest.Builder> deleteAccessPolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return deleteAccessPolicy(DeleteAccessPolicyRequest.builder().applyMutation(deleteAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param deleteCollectionRequest
     * @return Result of the DeleteCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCollectionResponse deleteCollection(DeleteCollectionRequest deleteCollectionRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless collection. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteCollectionRequest#builder()}
     * </p>
     *
     * @param deleteCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteCollectionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteCollectionResponse deleteCollection(Consumer<DeleteCollectionRequest.Builder> deleteCollectionRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return deleteCollection(DeleteCollectionRequest.builder().applyMutation(deleteCollectionRequest).build());
    }

    /**
     * <p>
     * Deletes an index from an OpenSearch Serverless collection. Be aware that the index might be configured to conduct
     * automatic semantic enrichment ingestion and search. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a>.
     * </p>
     *
     * @param deleteIndexRequest
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(DeleteIndexRequest deleteIndexRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an index from an OpenSearch Serverless collection. Be aware that the index might be configured to conduct
     * automatic semantic enrichment ingestion and search. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteIndexRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteIndexRequest#builder()}
     * </p>
     *
     * @param deleteIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteIndexRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteIndexResponse deleteIndex(Consumer<DeleteIndexRequest.Builder> deleteIndexRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        return deleteIndex(DeleteIndexRequest.builder().applyMutation(deleteIndexRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless lifecycle policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete"
     * >Deleting data lifecycle policies</a>.
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     * @return Result of the DeleteLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLifecyclePolicyResponse deleteLifecyclePolicy(DeleteLifecyclePolicyRequest deleteLifecyclePolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless lifecycle policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-delete"
     * >Deleting data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param deleteLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteLifecyclePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLifecyclePolicyResponse deleteLifecyclePolicy(
            Consumer<DeleteLifecyclePolicyRequest.Builder> deleteLifecyclePolicyRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return deleteLifecyclePolicy(DeleteLifecyclePolicyRequest.builder().applyMutation(deleteLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Deletes a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param deleteSecurityConfigRequest
     * @return Result of the DeleteSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityConfigResponse deleteSecurityConfig(DeleteSecurityConfigRequest deleteSecurityConfigRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityConfigRequest#builder()}
     * </p>
     *
     * @param deleteSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityConfigRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityConfigResponse deleteSecurityConfig(
            Consumer<DeleteSecurityConfigRequest.Builder> deleteSecurityConfigRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return deleteSecurityConfig(DeleteSecurityConfigRequest.builder().applyMutation(deleteSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless security policy.
     * </p>
     *
     * @param deleteSecurityPolicyRequest
     * @return Result of the DeleteSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityPolicyResponse deleteSecurityPolicy(DeleteSecurityPolicyRequest deleteSecurityPolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless security policy.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param deleteSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteSecurityPolicyResponse deleteSecurityPolicy(
            Consumer<DeleteSecurityPolicyRequest.Builder> deleteSecurityPolicyRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return deleteSecurityPolicy(DeleteSecurityPolicyRequest.builder().applyMutation(deleteSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param deleteVpcEndpointRequest
     * @return Result of the DeleteVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointResponse deleteVpcEndpoint(DeleteVpcEndpointRequest deleteVpcEndpointRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteVpcEndpointRequest#builder()}
     * </p>
     *
     * @param deleteVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.DeleteVpcEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.DeleteVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/DeleteVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteVpcEndpointResponse deleteVpcEndpoint(Consumer<DeleteVpcEndpointRequest.Builder> deleteVpcEndpointRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return deleteVpcEndpoint(DeleteVpcEndpointRequest.builder().applyMutation(deleteVpcEndpointRequest).build());
    }

    /**
     * <p>
     * Returns an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param getAccessPolicyRequest
     * @return Result of the GetAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessPolicyResponse getAccessPolicy(GetAccessPolicyRequest getAccessPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccessPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetAccessPolicyRequest#builder()}
     * </p>
     *
     * @param getAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetAccessPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccessPolicyResponse getAccessPolicy(Consumer<GetAccessPolicyRequest.Builder> getAccessPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        return getAccessPolicy(GetAccessPolicyRequest.builder().applyMutation(getAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Returns account-level settings related to OpenSearch Serverless.
     * </p>
     *
     * @param getAccountSettingsRequest
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(GetAccountSettingsRequest getAccountSettingsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns account-level settings related to OpenSearch Serverless.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link GetAccountSettingsRequest#builder()}
     * </p>
     *
     * @param getAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetAccountSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the GetAccountSettings operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default GetAccountSettingsResponse getAccountSettings(Consumer<GetAccountSettingsRequest.Builder> getAccountSettingsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return getAccountSettings(GetAccountSettingsRequest.builder().applyMutation(getAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Retrieves information about an index in an OpenSearch Serverless collection, including its schema definition. The
     * index might be configured to conduct automatic semantic enrichment ingestion and search. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a>.
     * </p>
     *
     * @param getIndexRequest
     * @return Result of the GetIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIndexResponse getIndex(GetIndexRequest getIndexRequest) throws InternalServerException, ResourceNotFoundException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves information about an index in an OpenSearch Serverless collection, including its schema definition. The
     * index might be configured to conduct automatic semantic enrichment ingestion and search. For more information,
     * see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIndexRequest.Builder} avoiding the need to
     * create one manually via {@link GetIndexRequest#builder()}
     * </p>
     *
     * @param getIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetIndexRequest.Builder} to create a
     *        request.
     * @return Result of the GetIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetIndex" target="_top">AWS
     *      API Documentation</a>
     */
    default GetIndexResponse getIndex(Consumer<GetIndexRequest.Builder> getIndexRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return getIndex(GetIndexRequest.builder().applyMutation(getIndexRequest).build());
    }

    /**
     * <p>
     * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and
     * security policies.
     * </p>
     *
     * @param getPoliciesStatsRequest
     * @return Result of the GetPoliciesStats operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetPoliciesStats
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetPoliciesStats"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPoliciesStatsResponse getPoliciesStats(GetPoliciesStatsRequest getPoliciesStatsRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns statistical information about your OpenSearch Serverless access policies, security configurations, and
     * security policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetPoliciesStatsRequest.Builder} avoiding the need
     * to create one manually via {@link GetPoliciesStatsRequest#builder()}
     * </p>
     *
     * @param getPoliciesStatsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetPoliciesStatsRequest.Builder} to
     *        create a request.
     * @return Result of the GetPoliciesStats operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetPoliciesStats
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetPoliciesStats"
     *      target="_top">AWS API Documentation</a>
     */
    default GetPoliciesStatsResponse getPoliciesStats(Consumer<GetPoliciesStatsRequest.Builder> getPoliciesStatsRequest)
            throws InternalServerException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return getPoliciesStats(GetPoliciesStatsRequest.builder().applyMutation(getPoliciesStatsRequest).build());
    }

    /**
     * <p>
     * Returns information about an OpenSearch Serverless security configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param getSecurityConfigRequest
     * @return Result of the GetSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityConfigResponse getSecurityConfig(GetSecurityConfigRequest getSecurityConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about an OpenSearch Serverless security configuration. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityConfigRequest.Builder} avoiding the need
     * to create one manually via {@link GetSecurityConfigRequest#builder()}
     * </p>
     *
     * @param getSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetSecurityConfigRequest.Builder} to
     *        create a request.
     * @return Result of the GetSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityConfigResponse getSecurityConfig(Consumer<GetSecurityConfigRequest.Builder> getSecurityConfigRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        return getSecurityConfig(GetSecurityConfigRequest.builder().applyMutation(getSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Returns information about a configured OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param getSecurityPolicyRequest
     * @return Result of the GetSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityPolicyResponse getSecurityPolicy(GetSecurityPolicyRequest getSecurityPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a configured OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSecurityPolicyRequest.Builder} avoiding the need
     * to create one manually via {@link GetSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param getSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.GetSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the GetSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.GetSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/GetSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSecurityPolicyResponse getSecurityPolicy(Consumer<GetSecurityPolicyRequest.Builder> getSecurityPolicyRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        return getSecurityPolicy(GetSecurityPolicyRequest.builder().applyMutation(getSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Returns information about a list of OpenSearch Serverless access policies.
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return Result of the ListAccessPolicies operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesResponse listAccessPolicies(ListAccessPoliciesRequest listAccessPoliciesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about a list of OpenSearch Serverless access policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListAccessPolicies operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesResponse listAccessPolicies(Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return listAccessPolicies(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesIterable responses = client
     *             .listAccessPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAccessPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesIterable listAccessPoliciesPaginator(ListAccessPoliciesRequest listAccessPoliciesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return new ListAccessPoliciesIterable(this, listAccessPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesIterable responses = client
     *             .listAccessPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListAccessPoliciesIterable responses = client.listAccessPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAccessPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAccessPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListAccessPoliciesRequest#builder()}
     * </p>
     *
     * @param listAccessPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListAccessPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListAccessPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListAccessPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAccessPoliciesIterable listAccessPoliciesPaginator(
            Consumer<ListAccessPoliciesRequest.Builder> listAccessPoliciesRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return listAccessPoliciesPaginator(ListAccessPoliciesRequest.builder().applyMutation(listAccessPoliciesRequest).build());
    }

    /**
     * <p>
     * Lists all OpenSearch Serverless collections. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <note>
     * <p>
     * Make sure to include an empty request body {} if you don't include any collection filters in the request.
     * </p>
     * </note>
     *
     * @param listCollectionsRequest
     * @return Result of the ListCollections operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectionsResponse listCollections(ListCollectionsRequest listCollectionsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all OpenSearch Serverless collections. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html">Creating and
     * managing Amazon OpenSearch Serverless collections</a>.
     * </p>
     * <note>
     * <p>
     * Make sure to include an empty request body {} if you don't include any collection filters in the request.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCollectionsRequest#builder()}
     * </p>
     *
     * @param listCollectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest.Builder} to
     *        create a request.
     * @return Result of the ListCollections operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectionsResponse listCollections(Consumer<ListCollectionsRequest.Builder> listCollectionsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return listCollections(ListCollectionsRequest.builder().applyMutation(listCollectionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsIterable responses = client.listCollectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsIterable responses = client
     *             .listCollectionsPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsIterable responses = client.listCollectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listCollectionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectionsIterable listCollectionsPaginator(ListCollectionsRequest listCollectionsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return new ListCollectionsIterable(this, listCollectionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsIterable responses = client.listCollectionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsIterable responses = client
     *             .listCollectionsPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListCollectionsIterable responses = client.listCollectionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listCollections(software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListCollectionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListCollectionsRequest#builder()}
     * </p>
     *
     * @param listCollectionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListCollectionsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListCollections
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListCollections"
     *      target="_top">AWS API Documentation</a>
     */
    default ListCollectionsIterable listCollectionsPaginator(Consumer<ListCollectionsRequest.Builder> listCollectionsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return listCollectionsPaginator(ListCollectionsRequest.builder().applyMutation(listCollectionsRequest).build());
    }

    /**
     * <p>
     * Returns a list of OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     * @return Result of the ListLifecyclePolicies operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLifecyclePoliciesResponse listLifecyclePolicies(ListLifecyclePoliciesRequest listLifecyclePoliciesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of OpenSearch Serverless lifecycle policies. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-list"
     * >Viewing data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLifecyclePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListLifecyclePoliciesRequest#builder()}
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListLifecyclePolicies operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLifecyclePoliciesResponse listLifecyclePolicies(
            Consumer<ListLifecyclePoliciesRequest.Builder> listLifecyclePoliciesRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return listLifecyclePolicies(ListLifecyclePoliciesRequest.builder().applyMutation(listLifecyclePoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesIterable responses = client.listLifecyclePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesIterable responses = client
     *             .listLifecyclePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesIterable responses = client.listLifecyclePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLifecyclePoliciesIterable listLifecyclePoliciesPaginator(ListLifecyclePoliciesRequest listLifecyclePoliciesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return new ListLifecyclePoliciesIterable(this, listLifecyclePoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesIterable responses = client.listLifecyclePoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesIterable responses = client
     *             .listLifecyclePoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListLifecyclePoliciesIterable responses = client.listLifecyclePoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listLifecyclePolicies(software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListLifecyclePoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListLifecyclePoliciesRequest#builder()}
     * </p>
     *
     * @param listLifecyclePoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListLifecyclePoliciesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListLifecyclePolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListLifecyclePolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListLifecyclePoliciesIterable listLifecyclePoliciesPaginator(
            Consumer<ListLifecyclePoliciesRequest.Builder> listLifecyclePoliciesRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return listLifecyclePoliciesPaginator(ListLifecyclePoliciesRequest.builder().applyMutation(listLifecyclePoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param listSecurityConfigsRequest
     * @return Result of the ListSecurityConfigs operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigsResponse listSecurityConfigs(ListSecurityConfigsRequest listSecurityConfigsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security configurations. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityConfigsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest.Builder} to
     *        create a request.
     * @return Result of the ListSecurityConfigs operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigsResponse listSecurityConfigs(
            Consumer<ListSecurityConfigsRequest.Builder> listSecurityConfigsRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return listSecurityConfigs(ListSecurityConfigsRequest.builder().applyMutation(listSecurityConfigsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsIterable responses = client.listSecurityConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsIterable responses = client
     *             .listSecurityConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsIterable responses = client.listSecurityConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityConfigsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigsIterable listSecurityConfigsPaginator(ListSecurityConfigsRequest listSecurityConfigsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return new ListSecurityConfigsIterable(this, listSecurityConfigsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsIterable responses = client.listSecurityConfigsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsIterable responses = client
     *             .listSecurityConfigsPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityConfigsIterable responses = client.listSecurityConfigsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityConfigs(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityConfigsRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityConfigsRequest#builder()}
     * </p>
     *
     * @param listSecurityConfigsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityConfigsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityConfigsIterable listSecurityConfigsPaginator(
            Consumer<ListSecurityConfigsRequest.Builder> listSecurityConfigsRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return listSecurityConfigsPaginator(ListSecurityConfigsRequest.builder().applyMutation(listSecurityConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security policies.
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return Result of the ListSecurityPolicies operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityPoliciesResponse listSecurityPolicies(ListSecurityPoliciesRequest listSecurityPoliciesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns information about configured OpenSearch Serverless security policies.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest.Builder} to
     *        create a request.
     * @return Result of the ListSecurityPolicies operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityPoliciesResponse listSecurityPolicies(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return listSecurityPolicies(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesIterable responses = client
     *             .listSecurityPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSecurityPoliciesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityPoliciesIterable listSecurityPoliciesPaginator(ListSecurityPoliciesRequest listSecurityPoliciesRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return new ListSecurityPoliciesIterable(this, listSecurityPoliciesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesIterable responses = client
     *             .listSecurityPoliciesPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListSecurityPoliciesIterable responses = client.listSecurityPoliciesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSecurityPolicies(software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSecurityPoliciesRequest.Builder} avoiding the
     * need to create one manually via {@link ListSecurityPoliciesRequest#builder()}
     * </p>
     *
     * @param listSecurityPoliciesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListSecurityPoliciesRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListSecurityPolicies
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListSecurityPolicies"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSecurityPoliciesIterable listSecurityPoliciesPaginator(
            Consumer<ListSecurityPoliciesRequest.Builder> listSecurityPoliciesRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return listSecurityPoliciesPaginator(ListSecurityPoliciesRequest.builder().applyMutation(listSecurityPoliciesRequest)
                .build());
    }

    /**
     * <p>
     * Returns the tags for an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the tags for an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListTagsForResourceRequest.Builder} to
     *        create a request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param listVpcEndpointsRequest
     * @return Result of the ListVpcEndpoints operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointsResponse listVpcEndpoints(ListVpcEndpointsRequest listVpcEndpointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns the OpenSearch Serverless-managed interface VPC endpoints associated with the current account. For more
     * information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest.Builder} to
     *        create a request.
     * @return Result of the ListVpcEndpoints operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointsResponse listVpcEndpoints(Consumer<ListVpcEndpointsRequest.Builder> listVpcEndpointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return listVpcEndpoints(ListVpcEndpointsRequest.builder().applyMutation(listVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsIterable responses = client.listVpcEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsIterable responses = client
     *             .listVpcEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsIterable responses = client.listVpcEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listVpcEndpointsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointsIterable listVpcEndpointsPaginator(ListVpcEndpointsRequest listVpcEndpointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return new ListVpcEndpointsIterable(this, listVpcEndpointsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsIterable responses = client.listVpcEndpointsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsIterable responses = client
     *             .listVpcEndpointsPaginator(request);
     *     for (software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.opensearchserverless.paginators.ListVpcEndpointsIterable responses = client.listVpcEndpointsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listVpcEndpoints(software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListVpcEndpointsRequest.Builder} avoiding the need
     * to create one manually via {@link ListVpcEndpointsRequest#builder()}
     * </p>
     *
     * @param listVpcEndpointsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.ListVpcEndpointsRequest.Builder} to
     *        create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.ListVpcEndpoints
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/ListVpcEndpoints"
     *      target="_top">AWS API Documentation</a>
     */
    default ListVpcEndpointsIterable listVpcEndpointsPaginator(Consumer<ListVpcEndpointsRequest.Builder> listVpcEndpointsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return listVpcEndpointsPaginator(ListVpcEndpointsRequest.builder().applyMutation(listVpcEndpointsRequest).build());
    }

    /**
     * <p>
     * Associates tags with an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates tags with an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.TagResourceRequest.Builder} to create a
     *        request.
     * @return Result of the TagResource operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/TagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes a tag or set of tags from an OpenSearch Serverless resource. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/tag-collection.html">Tagging Amazon
     * OpenSearch Serverless collections</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UntagResourceRequest.Builder} to create
     *        a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UntagResource"
     *      target="_top">AWS API Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateAccessPolicyRequest
     * @return Result of the UpdateAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessPolicyResponse updateAccessPolicy(UpdateAccessPolicyRequest updateAccessPolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-data-access.html">Data
     * access control for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccessPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccessPolicyRequest#builder()}
     * </p>
     *
     * @param updateAccessPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateAccessPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAccessPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateAccessPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccessPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccessPolicyResponse updateAccessPolicy(Consumer<UpdateAccessPolicyRequest.Builder> updateAccessPolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return updateAccessPolicy(UpdateAccessPolicyRequest.builder().applyMutation(updateAccessPolicyRequest).build());
    }

    /**
     * <p>
     * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html">Managing
     * capacity limits for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateAccountSettingsRequest
     * @return Result of the UpdateAccountSettings operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountSettingsResponse updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest)
            throws InternalServerException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update the OpenSearch Serverless settings for the current Amazon Web Services account. For more information, see
     * <a href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-scaling.html">Managing
     * capacity limits for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateAccountSettingsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateAccountSettingsRequest#builder()}
     * </p>
     *
     * @param updateAccountSettingsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateAccountSettingsRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateAccountSettings operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateAccountSettingsResponse updateAccountSettings(
            Consumer<UpdateAccountSettingsRequest.Builder> updateAccountSettingsRequest) throws InternalServerException,
            ValidationException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return updateAccountSettings(UpdateAccountSettingsRequest.builder().applyMutation(updateAccountSettingsRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless collection.
     * </p>
     *
     * @param updateCollectionRequest
     * @return Result of the UpdateCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCollectionResponse updateCollection(UpdateCollectionRequest updateCollectionRequest)
            throws InternalServerException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless collection.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateCollectionRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateCollectionRequest#builder()}
     * </p>
     *
     * @param updateCollectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateCollectionRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateCollection operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateCollection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateCollection"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateCollectionResponse updateCollection(Consumer<UpdateCollectionRequest.Builder> updateCollectionRequest)
            throws InternalServerException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return updateCollection(UpdateCollectionRequest.builder().applyMutation(updateCollectionRequest).build());
    }

    /**
     * <p>
     * Updates an existing index in an OpenSearch Serverless collection. This operation allows you to modify the index
     * schema, including adding new fields or changing field mappings. You can also enable automatic semantic enrichment
     * ingestion and search. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a>.
     * </p>
     *
     * @param updateIndexRequest
     * @return Result of the UpdateIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIndexResponse updateIndex(UpdateIndexRequest updateIndexRequest) throws InternalServerException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing index in an OpenSearch Serverless collection. This operation allows you to modify the index
     * schema, including adding new fields or changing field mappings. You can also enable automatic semantic enrichment
     * ingestion and search. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-manage.html#serverless-semantic-enrichment"
     * >About automatic semantic enrichment</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateIndexRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateIndexRequest#builder()}
     * </p>
     *
     * @param updateIndexRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateIndexRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateIndex operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateIndex
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateIndex"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateIndexResponse updateIndex(Consumer<UpdateIndexRequest.Builder> updateIndexRequest)
            throws InternalServerException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, OpenSearchServerlessException {
        return updateIndex(UpdateIndexRequest.builder().applyMutation(updateIndexRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update"
     * >Updating data lifecycle policies</a>.
     * </p>
     *
     * @param updateLifecyclePolicyRequest
     * @return Result of the UpdateLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLifecyclePolicyResponse updateLifecyclePolicy(UpdateLifecyclePolicyRequest updateLifecyclePolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless access policy. For more information, see <a href=
     * "https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-lifecycle.html#serverless-lifecycle-update"
     * >Updating data lifecycle policies</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLifecyclePolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateLifecyclePolicyRequest#builder()}
     * </p>
     *
     * @param updateLifecyclePolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateLifecyclePolicyRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLifecyclePolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateLifecyclePolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateLifecyclePolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLifecyclePolicyResponse updateLifecyclePolicy(
            Consumer<UpdateLifecyclePolicyRequest.Builder> updateLifecyclePolicyRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return updateLifecyclePolicy(UpdateLifecyclePolicyRequest.builder().applyMutation(updateLifecyclePolicyRequest).build());
    }

    /**
     * <p>
     * Updates a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateSecurityConfigRequest
     * @return Result of the UpdateSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityConfigResponse updateSecurityConfig(UpdateSecurityConfigRequest updateSecurityConfigRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a security configuration for OpenSearch Serverless. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html">SAML
     * authentication for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSecurityConfigRequest#builder()}
     * </p>
     *
     * @param updateSecurityConfigRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityConfigRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSecurityConfig operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateSecurityConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityConfigResponse updateSecurityConfig(
            Consumer<UpdateSecurityConfigRequest.Builder> updateSecurityConfigRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return updateSecurityConfig(UpdateSecurityConfigRequest.builder().applyMutation(updateSecurityConfigRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     *
     * @param updateSecurityPolicyRequest
     * @return Result of the UpdateSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityPolicyResponse updateSecurityPolicy(UpdateSecurityPolicyRequest updateSecurityPolicyRequest)
            throws InternalServerException, ConflictException, ResourceNotFoundException, ValidationException,
            ServiceQuotaExceededException, AwsServiceException, SdkClientException, OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless security policy. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-network.html">Network
     * access for Amazon OpenSearch Serverless</a> and <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-encryption.html">Encryption
     * at rest for Amazon OpenSearch Serverless</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSecurityPolicyRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateSecurityPolicyRequest#builder()}
     * </p>
     *
     * @param updateSecurityPolicyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateSecurityPolicyRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSecurityPolicy operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ResourceNotFoundException
     *         Thrown when accessing or deleting a resource that does not exist.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws ServiceQuotaExceededException
     *         Thrown when you attempt to create more resources than the service allows based on service quotas.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateSecurityPolicy
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateSecurityPolicy"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSecurityPolicyResponse updateSecurityPolicy(
            Consumer<UpdateSecurityPolicyRequest.Builder> updateSecurityPolicyRequest) throws InternalServerException,
            ConflictException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            AwsServiceException, SdkClientException, OpenSearchServerlessException {
        return updateSecurityPolicy(UpdateSecurityPolicyRequest.builder().applyMutation(updateSecurityPolicyRequest).build());
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     *
     * @param updateVpcEndpointRequest
     * @return Result of the UpdateVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVpcEndpointResponse updateVpcEndpoint(UpdateVpcEndpointRequest updateVpcEndpointRequest)
            throws InternalServerException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an OpenSearch Serverless-managed interface endpoint. For more information, see <a
     * href="https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-vpc.html">Access Amazon
     * OpenSearch Serverless using an interface endpoint</a>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateVpcEndpointRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateVpcEndpointRequest#builder()}
     * </p>
     *
     * @param updateVpcEndpointRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.opensearchserverless.model.UpdateVpcEndpointRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateVpcEndpoint operation returned by the service.
     * @throws InternalServerException
     *         Thrown when an error internal to the service occurs while processing a request.
     * @throws ConflictException
     *         When creating a resource, thrown when a resource with the same name already exists or is being created.
     *         When deleting a resource, thrown when the resource is not in the ACTIVE or FAILED state.
     * @throws ValidationException
     *         Thrown when the HTTP request contains invalid input or is missing required input.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws OpenSearchServerlessException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample OpenSearchServerlessClient.UpdateVpcEndpoint
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/opensearchserverless-2021-11-01/UpdateVpcEndpoint"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateVpcEndpointResponse updateVpcEndpoint(Consumer<UpdateVpcEndpointRequest.Builder> updateVpcEndpointRequest)
            throws InternalServerException, ConflictException, ValidationException, AwsServiceException, SdkClientException,
            OpenSearchServerlessException {
        return updateVpcEndpoint(UpdateVpcEndpointRequest.builder().applyMutation(updateVpcEndpointRequest).build());
    }

    /**
     * Create a {@link OpenSearchServerlessClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static OpenSearchServerlessClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link OpenSearchServerlessClient}.
     */
    static OpenSearchServerlessClientBuilder builder() {
        return new DefaultOpenSearchServerlessClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default OpenSearchServerlessServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
